/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RainbowIdentifierHighlighterPass
extends TextEditorHighlightingPass {
    protected final PsiFile myFile;
    protected final RainbowHighlighter myRainbowHighlighter;
    protected List<HighlightInfo> toHighlight;
    protected final EditorColorsScheme myEditorColorsScheme;

    protected RainbowIdentifierHighlighterPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/RainbowIdentifierHighlighterPass", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/RainbowIdentifierHighlighterPass", "<init>"));
        }
        super(file2.getProject(), editor.getDocument(), false);
        this.myFile = file2;
        this.myEditorColorsScheme = editor.getColorsScheme();
        this.myRainbowHighlighter = new RainbowHighlighter((TextAttributesScheme)this.myEditorColorsScheme);
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/RainbowIdentifierHighlighterPass", "doCollectInformation"));
        }
        final ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        this.myFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement e) {
                HighlightInfo attrs;
                if (e instanceof PsiReference) {
                    attrs = RainbowIdentifierHighlighterPass.this.getInfo(e.getText(), e, null);
                } else if (e instanceof PsiNameIdentifierOwner) {
                    PsiNameIdentifierOwner identifierOwner = (PsiNameIdentifierOwner)e;
                    attrs = RainbowIdentifierHighlighterPass.this.getInfo(identifierOwner.getName(), identifierOwner.getNameIdentifier(), null);
                } else {
                    attrs = null;
                }
                if (attrs != null) {
                    infos.add(attrs);
                }
                super.visitElement(e);
            }
        });
        this.toHighlight = infos;
    }

    @Override
    public void doApplyInformationToEditor() {
        if (this.toHighlight == null || this.myDocument == null) {
            return;
        }
        UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, 0, this.myFile.getTextLength(), this.toHighlight, this.getColorsScheme(), this.getId());
    }

    protected HighlightInfo getInfo(@Nullable String nameKey, @Nullable PsiElement id, @Nullable TextAttributesKey colorKey) {
        if (id == null || nameKey == null || StringUtil.isEmpty((String)nameKey)) {
            return null;
        }
        if (colorKey == null) {
            colorKey = DefaultLanguageHighlighterColors.LOCAL_VARIABLE;
        }
        TextAttributes attributes = this.myRainbowHighlighter.getAttributes(nameKey, this.myEditorColorsScheme.getAttributes(colorKey));
        return HighlightInfo.newHighlightInfo(RainbowHighlighter.RAINBOW_ELEMENT).textAttributes(attributes).range(id).create();
    }
}

