/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodReturnTypeFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class AddReturnFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AddReturnFix");
    private final PsiMethod myMethod;

    public AddReturnFix(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/quickfix/AddReturnFix", "<init>"));
        }
        this.myMethod = method;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("add.return.statement.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddReturnFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddReturnFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddReturnFix", "isAvailable"));
        }
        return this.myMethod.isValid() && this.myMethod.getManager().isInProject((PsiElement)this.myMethod) && this.myMethod.getBody() != null && this.myMethod.getBody().getRBrace() != null;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddReturnFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(this.myMethod.getContainingFile())) {
            return;
        }
        try {
            String value = this.suggestReturnValue();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myMethod.getProject()).getElementFactory();
            PsiReturnStatement returnStatement = (PsiReturnStatement)factory.createStatementFromText("return " + value + ";", (PsiElement)this.myMethod);
            PsiCodeBlock body = this.myMethod.getBody();
            returnStatement = (PsiReturnStatement)body.addBefore((PsiElement)returnStatement, (PsiElement)body.getRBrace());
            MethodReturnTypeFix.selectReturnValueInEditor(returnStatement, editor);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private String suggestReturnValue() {
        PsiVariable[] variables;
        PsiType type = this.myMethod.getReturnType();
        for (PsiVariable variable : variables = AddReturnFix.getDeclaredVariables(this.myMethod)) {
            PsiType varType = variable.getType();
            if (!varType.equals(type)) continue;
            return variable.getName();
        }
        return PsiTypesUtil.getDefaultValueOfType((PsiType)type);
    }

    private static PsiVariable[] getDeclaredVariables(PsiMethod method) {
        PsiStatement[] statements;
        ArrayList<PsiVariable> variables = new ArrayList<PsiVariable>();
        for (PsiStatement statement2 : statements = method.getBody().getStatements()) {
            PsiElement[] declaredElements;
            if (!(statement2 instanceof PsiDeclarationStatement)) continue;
            for (PsiElement declaredElement : declaredElements = ((PsiDeclarationStatement)statement2).getDeclaredElements()) {
                if (!(declaredElement instanceof PsiLocalVariable)) continue;
                variables.add((PsiVariable)declaredElement);
            }
        }
        Object[] parameters = method.getParameterList().getParameters();
        ContainerUtil.addAll(variables, (Object[])parameters);
        return variables.toArray(new PsiVariable[variables.size()]);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

