/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiUtilBase;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackspaceHandler
extends EditorWriteActionHandler {
    private static final Logger LOGGER = Logger.getInstance(BackspaceHandler.class);
    protected final EditorActionHandler myOriginalHandler;

    public BackspaceHandler(EditorActionHandler originalHandler) {
        super(true);
        this.myOriginalHandler = originalHandler;
    }

    public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
        if (!this.handleBackspace(editor, caret, dataContext, false)) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
        }
    }

    protected boolean handleBackspace(Editor editor, Caret caret, DataContext dataContext, boolean toWordStart) {
        int injectedOffset;
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return false;
        }
        PsiFile file2 = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project2);
        if (file2 == null) {
            return false;
        }
        if (editor.getSelectionModel().hasSelection()) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset() - 1;
        if (offset < 0) {
            return false;
        }
        CharSequence chars = editor.getDocument().getCharsSequence();
        char c = chars.charAt(offset);
        Editor injectedEditor = TypedHandler.injectedEditorIfCharTypedIsSignificant(c, editor, file2);
        Editor originalEditor = editor;
        if (injectedEditor != editor && BackspaceHandler.isOffsetInsideInjected(injectedEditor, injectedOffset = injectedEditor.getCaretModel().getOffset())) {
            file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(injectedEditor.getDocument());
            editor = injectedEditor;
            offset = injectedOffset - 1;
        }
        BackspaceHandlerDelegate[] delegates = (BackspaceHandlerDelegate[])Extensions.getExtensions((ExtensionPointName)BackspaceHandlerDelegate.EP_NAME);
        if (!toWordStart) {
            for (BackspaceHandlerDelegate delegate : delegates) {
                delegate.beforeCharDeleted(c, file2, editor);
            }
        }
        FileType fileType = file2.getFileType();
        QuoteHandler quoteHandler = TypedHandler.getQuoteHandler(file2, editor);
        HighlighterIterator hiterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        boolean wasClosingQuote = quoteHandler != null && quoteHandler.isClosingQuote(hiterator, offset);
        this.myOriginalHandler.execute(originalEditor, caret, dataContext);
        if (!toWordStart) {
            for (BackspaceHandlerDelegate delegate : delegates) {
                if (!delegate.charDeleted(c, file2, editor)) continue;
                return true;
            }
        }
        if (offset >= editor.getDocument().getTextLength()) {
            return true;
        }
        chars = editor.getDocument().getCharsSequence();
        if ((c == '(' || c == '[' || c == '{') && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            boolean matched;
            char c1 = chars.charAt(offset);
            if (c1 != BackspaceHandler.getRightChar(c)) {
                return true;
            }
            HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
            BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
            if (!braceMatcher.isLBraceToken(iterator, chars, fileType) && !braceMatcher.isRBraceToken(iterator, chars, fileType)) {
                return true;
            }
            int rparenOffset = BraceMatchingUtil.findRightmostRParen(iterator, iterator.getTokenType(), chars, fileType);
            if (rparenOffset >= 0 && (matched = BraceMatchingUtil.matchBrace(chars, fileType, iterator = ((EditorEx)editor).getHighlighter().createIterator(rparenOffset), false))) {
                return true;
            }
            editor.getDocument().deleteString(offset, offset + 1);
        } else if ((c == '\"' || c == '\'' || c == '`') && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
            char c1 = chars.charAt(offset);
            if (c1 != c) {
                return true;
            }
            if (wasClosingQuote) {
                return true;
            }
            HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
            if (quoteHandler == null || !quoteHandler.isOpeningQuote(iterator, offset)) {
                return true;
            }
            editor.getDocument().deleteString(offset, offset + 1);
        }
        return true;
    }

    public static char getRightChar(char c) {
        if (c == '(') {
            return ')';
        }
        if (c == '[') {
            return ']';
        }
        if (c == '{') {
            return '}';
        }
        assert (false);
        return c;
    }

    private static boolean isOffsetInsideInjected(Editor injectedEditor, int injectedOffset) {
        TextRange rangeToEdit;
        if (injectedOffset == 0 || injectedOffset >= injectedEditor.getDocument().getTextLength()) {
            return false;
        }
        PsiFile injectedFile = ((EditorWindow)injectedEditor).getInjectedFile();
        InjectedLanguageManager ilm = InjectedLanguageManager.getInstance((Project)injectedFile.getProject());
        List editables = ilm.intersectWithAllEditableFragments(injectedFile, rangeToEdit = new TextRange(injectedOffset - 1, injectedOffset + 1));
        return editables.size() == 1 && ((TextRange)editables.get(0)).equals((Object)rangeToEdit);
    }

    @Nullable
    public static LogicalPosition getBackspaceUnindentPosition(PsiFile file2, Editor editor) {
        if (editor.getSelectionModel().hasSelection()) {
            return null;
        }
        LogicalPosition caretPos = editor.getCaretModel().getLogicalPosition();
        if (caretPos.column == 0) {
            return null;
        }
        if (!BackspaceHandler.isWhitespaceBeforeCaret(editor)) {
            return null;
        }
        int indent = CodeStyleSettingsManager.getSettings((Project)file2.getProject()).getIndentOptionsByFile((PsiFile)file2).INDENT_SIZE;
        int column = (caretPos.column - 1) / indent * indent;
        if (column < 0) {
            column = 0;
        }
        return new LogicalPosition(caretPos.line, column);
    }

    public static void deleteToTargetPosition(@NotNull Editor editor, @NotNull LogicalPosition pos) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/BackspaceHandler", "deleteToTargetPosition"));
        }
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/codeInsight/editorActions/BackspaceHandler", "deleteToTargetPosition"));
        }
        LogicalPosition logicalPosition = editor.getCaretModel().getLogicalPosition();
        if (logicalPosition.line != pos.line) {
            LOGGER.error("Unexpected caret position: " + logicalPosition + ", target indent position: " + pos);
            return;
        }
        if (pos.column < logicalPosition.column) {
            int targetOffset = editor.logicalPositionToOffset(pos);
            int offset = editor.getCaretModel().getOffset();
            editor.getSelectionModel().setSelection(targetOffset, offset);
            EditorModificationUtil.deleteSelectedText((Editor)editor);
        } else if (pos.column > logicalPosition.column) {
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)StringUtil.repeatSymbol((char)' ', (int)(pos.column - logicalPosition.column)));
        }
    }

    public static boolean isWhitespaceBeforeCaret(Editor editor) {
        LogicalPosition caretPos = editor.getCaretModel().getLogicalPosition();
        CharSequence charSeq = editor.getDocument().getCharsSequence();
        for (int pos = 0; pos < caretPos.column; ++pos) {
            char c;
            LogicalPosition checkPos = new LogicalPosition(caretPos.line, pos);
            int offset = editor.logicalPositionToOffset(checkPos);
            if (offset >= charSeq.length() || (c = charSeq.charAt(offset)) == '\t' || c == ' ' || c == '\n') continue;
            return false;
        }
        return true;
    }
}

