/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;

public class BlockBraceFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement instanceof PsiCodeBlock && this.afterUnmatchedBrace(editor, psiElement.getContainingFile().getFileType())) {
            PsiCodeBlock block = (PsiCodeBlock)psiElement;
            int stopOffset = block.getTextRange().getEndOffset();
            PsiStatement[] statements = block.getStatements();
            if (statements.length > 0) {
                stopOffset = statements[0].getTextRange().getEndOffset();
            }
            editor.getDocument().insertString(stopOffset, (CharSequence)"}");
        }
    }

    private boolean afterUnmatchedBrace(Editor editor, FileType fileType) {
        return EnterAfterUnmatchedBraceHandler.isAfterUnmatchedLBrace(editor, editor.getCaretModel().getOffset(), fileType);
    }
}

