/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.PatternDescriptor;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.MultiMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateByPatternDialog
extends DialogWrapper {
    private final Project myProject;
    private JPanel myPanel;
    private Splitter mySplitter;
    private Tree myTree;
    private final Editor myEditor;
    private final MultiMap<String, PatternDescriptor> myMap;

    public GenerateByPatternDialog(Project project2, PatternDescriptor[] descriptors) {
        super(project2);
        this.$$$setupUI$$$();
        this.myTree = new Tree();
        this.myProject = project2;
        this.setTitle("Generate by Pattern");
        this.setOKButtonText("Generate");
        this.myMap = new MultiMap();
        for (PatternDescriptor descriptor : descriptors) {
            this.myMap.putValue((Object)descriptor.getParentId(), (Object)descriptor);
        }
        DefaultMutableTreeNode root = this.createNode(null);
        this.myTree = new SimpleTree(){};
        this.myTree.setRootVisible(false);
        this.myTree.setCellRenderer((TreeCellRenderer)new DefaultTreeCellRenderer(){

            @Override
            @NotNull
            public Component getTreeCellRendererComponent(@NotNull JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/codeInsight/generation/GenerateByPatternDialog$2", "getTreeCellRendererComponent"));
                }
                Component component = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                Object object = ((DefaultMutableTreeNode)value).getUserObject();
                if (object instanceof PatternDescriptor) {
                    this.setText(((PatternDescriptor)object).getName());
                    this.setIcon(((PatternDescriptor)object).getIcon());
                }
                Component component2 = component;
                if (component2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateByPatternDialog$2", "getTreeCellRendererComponent"));
                }
                return component2;
            }
        });
        this.myTree.setModel((TreeModel)new DefaultTreeModel(root));
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(@NotNull TreeSelectionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/generation/GenerateByPatternDialog$3", "valueChanged"));
                }
                GenerateByPatternDialog.this.update();
            }
        });
        this.myEditor = TemplateEditorUtil.createEditor(true, "");
        this.mySplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myTree));
        JPanel details = new JPanel(new BorderLayout());
        details.add((Component)this.myEditor.getComponent(), "Center");
        this.mySplitter.setSecondComponent((JComponent)details);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setShowDividerControls(true);
        this.myTree.setSelectionRow(0);
        this.init();
    }

    private void update() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        this.getOKAction().setEnabled(node != null && node.isLeaf());
        PatternDescriptor descriptor = this.getSelectedDescriptor();
        if (descriptor != null) {
            this.updateDetails(descriptor);
        }
    }

    private DefaultMutableTreeNode getSelectedNode() {
        TreePath path = this.myTree.getSelectionModel().getSelectionPath();
        return path == null ? null : (DefaultMutableTreeNode)path.getLastPathComponent();
    }

    PatternDescriptor getSelectedDescriptor() {
        Object object;
        DefaultMutableTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode != null && (object = selectedNode.getUserObject()) instanceof PatternDescriptor) {
            return (PatternDescriptor)object;
        }
        return null;
    }

    private void updateDetails(final PatternDescriptor descriptor) {
        new WriteCommandAction.Simple(this.myProject, new PsiFile[0]){

            protected void run() throws Throwable {
                Template template = descriptor.getTemplate();
                if (template instanceof TemplateImpl) {
                    String text = ((TemplateImpl)template).getString();
                    GenerateByPatternDialog.this.myEditor.getDocument().replaceString(0, GenerateByPatternDialog.this.myEditor.getDocument().getTextLength(), (CharSequence)text);
                    TemplateEditorUtil.setHighlighter(GenerateByPatternDialog.this.myEditor, ((TemplateImpl)template).getTemplateContext());
                } else {
                    GenerateByPatternDialog.this.myEditor.getDocument().replaceString(0, GenerateByPatternDialog.this.myEditor.getDocument().getTextLength(), (CharSequence)"");
                }
            }
        }.execute();
    }

    private DefaultMutableTreeNode createNode(@Nullable PatternDescriptor descriptor) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(descriptor){

            @Override
            @NotNull
            public String toString() {
                Object object = this.getUserObject();
                String string = object == null ? "" : ((PatternDescriptor)object).getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateByPatternDialog$5", "toString"));
                }
                return string;
            }
        };
        String id = descriptor == null ? "root" : descriptor.getId();
        Collection collection = this.myMap.get((Object)id);
        for (PatternDescriptor childDescriptor : collection) {
            root.add(this.createNode(childDescriptor));
        }
        return root;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    protected String getDimensionServiceKey() {
        return "generate.patterns.dialog";
    }

    protected void dispose() {
        super.dispose();
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }

    private void createUIComponents() {
        this.mySplitter = new Splitter(false, 0.3f);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Splitter splitter = this.mySplitter;
        jPanel.add((Component)splitter, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(400, 300), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

