/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.surroundWith.JavaStatementsSurrounder;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;

class JavaWithWhileSurrounder
extends JavaStatementsSurrounder {
    JavaWithWhileSurrounder() {
    }

    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.while.template", (Object[])new Object[0]);
    }

    @Override
    public TextRange surroundStatements(Project project2, Editor editor, PsiElement container, PsiElement[] statements) throws IncorrectOperationException {
        PsiManager manager = PsiManager.getInstance((Project)project2);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        if ((statements = SurroundWithUtil.moveDeclarationsOut(container, statements, true)).length == 0) {
            return null;
        }
        String text = "while(true){\n}";
        PsiWhileStatement whileStatement = (PsiWhileStatement)factory.createStatementFromText(text, null);
        whileStatement = (PsiWhileStatement)codeStyleManager.reformat((PsiElement)whileStatement);
        PsiStatement body = (whileStatement = (PsiWhileStatement)container.addAfter((PsiElement)whileStatement, statements[statements.length - 1])).getBody();
        if (!(body instanceof PsiBlockStatement)) {
            return null;
        }
        PsiCodeBlock bodyBlock = ((PsiBlockStatement)body).getCodeBlock();
        SurroundWithUtil.indentCommentIfNecessary(bodyBlock, statements);
        bodyBlock.addRange(statements[0], statements[statements.length - 1]);
        container.deleteChildRange(statements[0], statements[statements.length - 1]);
        PsiExpression condition = whileStatement.getCondition();
        return condition == null ? null : condition.getTextRange();
    }
}

