/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.BraceHighlightingHandler;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.PairedBraceMatcherAdapter;
import com.intellij.codeInsight.highlighting.XmlAwareBraceMatcher;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageBraceMatching;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BraceMatchingUtil {
    public static final int UNDEFINED_TOKEN_GROUP = -1;
    private static final Map<FileType, BraceMatcher> BRACE_MATCHERS = new HashMap<FileType, BraceMatcher>();

    private BraceMatchingUtil() {
    }

    public static boolean isPairedBracesAllowedBeforeTypeInFileType(@NotNull IElementType lbraceType, IElementType tokenType, @NotNull FileType fileType) {
        if (lbraceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lbraceType", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "isPairedBracesAllowedBeforeTypeInFileType"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "isPairedBracesAllowedBeforeTypeInFileType"));
        }
        try {
            return BraceMatchingUtil.getBraceMatcher(fileType, lbraceType).isPairedBracesAllowedBeforeType(lbraceType, tokenType);
        }
        catch (AbstractMethodError abstractMethodError) {
            return true;
        }
    }

    public static void registerBraceMatcher(@NotNull FileType fileType, @NotNull BraceMatcher braceMatcher) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "registerBraceMatcher"));
        }
        if (braceMatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "braceMatcher", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "registerBraceMatcher"));
        }
        BRACE_MATCHERS.put(fileType, braceMatcher);
    }

    public static int getMatchedBraceOffset(@NotNull Editor editor, boolean forward, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "getMatchedBraceOffset"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "getMatchedBraceOffset"));
        }
        Document document2 = editor.getDocument();
        int offset = editor.getCaretModel().getOffset();
        EditorHighlighter editorHighlighter = BraceHighlightingHandler.getLazyParsableHighlighterIfAny(file2.getProject(), editor, file2);
        HighlighterIterator iterator = editorHighlighter.createIterator(offset);
        boolean matched = BraceMatchingUtil.matchBrace(document2.getCharsSequence(), file2.getFileType(), iterator, forward);
        assert (matched);
        return iterator.getStart();
    }

    public static synchronized boolean matchBrace(@NotNull CharSequence fileText, @NotNull FileType fileType, @NotNull HighlighterIterator iterator, boolean forward) {
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "matchBrace"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "matchBrace"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "matchBrace"));
        }
        return new MatchBraceContext(fileText, fileType, iterator, forward).doBraceMatch();
    }

    public static synchronized boolean matchBrace(@NotNull CharSequence fileText, @NotNull FileType fileType, @NotNull HighlighterIterator iterator, boolean forward, boolean isStrict) {
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "matchBrace"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "matchBrace"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "matchBrace"));
        }
        return new MatchBraceContext(fileText, fileType, iterator, forward, isStrict).doBraceMatch();
    }

    public static boolean findStructuralLeftBrace(@NotNull FileType fileType, @NotNull HighlighterIterator iterator, @NotNull CharSequence fileText) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "findStructuralLeftBrace"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "findStructuralLeftBrace"));
        }
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "findStructuralLeftBrace"));
        }
        Stack braceStack = new Stack();
        Stack tagNameStack = new Stack();
        BraceMatcher matcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        while (!iterator.atEnd()) {
            if (BraceMatchingUtil.isStructuralBraceToken(fileType, iterator, fileText)) {
                if (BraceMatchingUtil.isRBraceToken(iterator, fileText, fileType)) {
                    braceStack.push((Object)iterator.getTokenType());
                    tagNameStack.push((Object)BraceMatchingUtil.getTagName(matcher, fileText, iterator));
                }
                if (BraceMatchingUtil.isLBraceToken(iterator, fileText, fileType)) {
                    if (braceStack.isEmpty()) {
                        return true;
                    }
                    int group = matcher.getBraceTokenGroupId(iterator.getTokenType());
                    IElementType topTokenType = (IElementType)braceStack.pop();
                    IElementType tokenType = iterator.getTokenType();
                    boolean isStrict = BraceMatchingUtil.isStrictTagMatching(matcher, fileType, group);
                    boolean isCaseSensitive = BraceMatchingUtil.areTagsCaseSensitive(matcher, fileType, group);
                    String topTagName = null;
                    String tagName = null;
                    if (isStrict) {
                        topTagName = (String)tagNameStack.pop();
                        tagName = BraceMatchingUtil.getTagName(matcher, fileText, iterator);
                    }
                    if (!BraceMatchingUtil.isPairBraces(topTokenType, tokenType, fileType) || isStrict && !Comparing.equal((String)topTagName, (String)tagName, (boolean)isCaseSensitive)) {
                        return false;
                    }
                }
            }
            iterator.retreat();
        }
        return false;
    }

    public static boolean isStructuralBraceToken(@NotNull FileType fileType, @NotNull HighlighterIterator iterator, @NotNull CharSequence text) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "isStructuralBraceToken"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "isStructuralBraceToken"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "isStructuralBraceToken"));
        }
        BraceMatcher matcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        return matcher.isStructuralBrace(iterator, text, fileType);
    }

    public static boolean isLBraceToken(@NotNull HighlighterIterator iterator, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "isLBraceToken"));
        }
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "isLBraceToken"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "isLBraceToken"));
        }
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        return braceMatcher.isLBraceToken(iterator, fileText, fileType);
    }

    public static boolean isRBraceToken(@NotNull HighlighterIterator iterator, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "isRBraceToken"));
        }
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "isRBraceToken"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "isRBraceToken"));
        }
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        return braceMatcher.isRBraceToken(iterator, fileText, fileType);
    }

    public static boolean isPairBraces(@NotNull IElementType tokenType1, @NotNull IElementType tokenType2, @NotNull FileType fileType) {
        if (tokenType1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenType1", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "isPairBraces"));
        }
        if (tokenType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenType2", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "isPairBraces"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "isPairBraces"));
        }
        BraceMatcher matcher = BraceMatchingUtil.getBraceMatcher(fileType, tokenType1);
        return matcher.isPairBraces(tokenType1, tokenType2);
    }

    private static int getTokenGroup(@Nullable IElementType tokenType, FileType fileType) {
        return tokenType == null ? -1 : BraceMatchingUtil.getBraceMatcher(fileType, tokenType).getBraceTokenGroupId(tokenType);
    }

    public static int findLeftmostLParen(HighlighterIterator iterator, IElementType lparenTokenType, CharSequence fileText, FileType fileType) {
        int lastLbraceOffset = -1;
        Stack braceStack = new Stack();
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (BraceMatchingUtil.isLBraceToken(iterator, fileText, fileType)) {
                if (!braceStack.isEmpty()) {
                    IElementType topToken = (IElementType)braceStack.pop();
                    if (!BraceMatchingUtil.isPairBraces(tokenType, topToken, fileType)) {
                        break;
                    }
                } else {
                    if (tokenType != lparenTokenType) break;
                    lastLbraceOffset = iterator.getStart();
                }
            } else if (BraceMatchingUtil.isRBraceToken(iterator, fileText, fileType)) {
                braceStack.push((Object)iterator.getTokenType());
            }
            iterator.retreat();
        }
        return lastLbraceOffset;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int findLeftLParen(HighlighterIterator iterator, IElementType lparenTokenType, CharSequence fileText, FileType fileType) {
        int lastLbraceOffset = -1;
        Stack braceStack = new Stack();
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (BraceMatchingUtil.isLBraceToken(iterator, fileText, fileType)) {
                if (braceStack.isEmpty()) {
                    if (tokenType != lparenTokenType) return lastLbraceOffset;
                    return iterator.getStart();
                }
                IElementType topToken = (IElementType)braceStack.pop();
                if (!BraceMatchingUtil.isPairBraces(tokenType, topToken, fileType)) {
                    return lastLbraceOffset;
                }
            } else if (BraceMatchingUtil.isRBraceToken(iterator, fileText, fileType)) {
                braceStack.push((Object)iterator.getTokenType());
            }
            iterator.retreat();
        }
        return lastLbraceOffset;
    }

    public static int findRightmostRParen(HighlighterIterator iterator, IElementType rparenTokenType, CharSequence fileText, FileType fileType) {
        int lastRbraceOffset = -1;
        Stack braceStack = new Stack();
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (BraceMatchingUtil.isRBraceToken(iterator, fileText, fileType)) {
                if (!braceStack.isEmpty()) {
                    IElementType topToken = (IElementType)braceStack.pop();
                    if (!BraceMatchingUtil.isPairBraces(tokenType, topToken, fileType)) {
                        break;
                    }
                } else {
                    if (tokenType != rparenTokenType) break;
                    lastRbraceOffset = iterator.getStart();
                }
            } else if (BraceMatchingUtil.isLBraceToken(iterator, fileText, fileType)) {
                braceStack.push((Object)iterator.getTokenType());
            }
            iterator.advance();
        }
        return lastRbraceOffset;
    }

    @NotNull
    public static BraceMatcher getBraceMatcher(@NotNull FileType fileType, @NotNull HighlighterIterator iterator) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "getBraceMatcher"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "getBraceMatcher"));
        }
        IElementType tokenType = iterator.getTokenType();
        BraceMatcher braceMatcher = tokenType == null ? BraceMatcherHolder.ourDefaultBraceMatcher : BraceMatchingUtil.getBraceMatcher(fileType, tokenType);
        if (braceMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "getBraceMatcher"));
        }
        return braceMatcher;
    }

    @NotNull
    public static BraceMatcher getBraceMatcher(@NotNull FileType fileType, @NotNull IElementType type) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "getBraceMatcher"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "getBraceMatcher"));
        }
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, type.getLanguage());
        if (braceMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "getBraceMatcher"));
        }
        return braceMatcher;
    }

    @NotNull
    public static BraceMatcher getBraceMatcher(@NotNull FileType fileType, @NotNull Language lang) {
        Language language;
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "getBraceMatcher"));
        }
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "getBraceMatcher"));
        }
        PairedBraceMatcher matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(lang);
        if (matcher != null) {
            if (matcher instanceof XmlAwareBraceMatcher) {
                XmlAwareBraceMatcher xmlAwareBraceMatcher = (XmlAwareBraceMatcher)matcher;
                if (xmlAwareBraceMatcher == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "getBraceMatcher"));
                }
                return xmlAwareBraceMatcher;
            }
            if (matcher instanceof PairedBraceMatcherAdapter) {
                BraceMatcher braceMatcher = (BraceMatcher)matcher;
                if (braceMatcher == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "getBraceMatcher"));
                }
                return braceMatcher;
            }
            PairedBraceMatcherAdapter pairedBraceMatcherAdapter = new PairedBraceMatcherAdapter(matcher, lang);
            if (pairedBraceMatcherAdapter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "getBraceMatcher"));
            }
            return pairedBraceMatcherAdapter;
        }
        BraceMatcher byFileType = BraceMatchingUtil.getBraceMatcherByFileType(fileType);
        if (byFileType != null) {
            BraceMatcher braceMatcher = byFileType;
            if (braceMatcher == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "getBraceMatcher"));
            }
            return braceMatcher;
        }
        if (fileType instanceof LanguageFileType && lang != (language = ((LanguageFileType)fileType).getLanguage())) {
            BraceMatcher braceMatcher;
            LanguageFileType type1 = lang.getAssociatedFileType();
            if (type1 != null && (braceMatcher = BraceMatchingUtil.getBraceMatcherByFileType((FileType)type1)) != null) {
                BraceMatcher braceMatcher2 = braceMatcher;
                if (braceMatcher2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "getBraceMatcher"));
                }
                return braceMatcher2;
            }
            matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(language);
            if (matcher != null) {
                PairedBraceMatcherAdapter pairedBraceMatcherAdapter = new PairedBraceMatcherAdapter(matcher, language);
                if (pairedBraceMatcherAdapter == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "getBraceMatcher"));
                }
                return pairedBraceMatcherAdapter;
            }
        }
        BraceMatcher braceMatcher = BraceMatcherHolder.ourDefaultBraceMatcher;
        if (braceMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "getBraceMatcher"));
        }
        return braceMatcher;
    }

    @Nullable
    private static BraceMatcher getBraceMatcherByFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "getBraceMatcherByFileType"));
        }
        BraceMatcher braceMatcher = BRACE_MATCHERS.get(fileType);
        if (braceMatcher != null) {
            return braceMatcher;
        }
        for (FileTypeExtensionPoint ext : (FileTypeExtensionPoint[])Extensions.getExtensions(BraceMatcher.EP_NAME)) {
            if (!fileType.getName().equals(ext.filetype)) continue;
            braceMatcher = (BraceMatcher)ext.getInstance();
            BRACE_MATCHERS.put(fileType, braceMatcher);
            return braceMatcher;
        }
        return null;
    }

    private static boolean isStrictTagMatching(@NotNull BraceMatcher matcher, @NotNull FileType fileType, int group) {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "isStrictTagMatching"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "isStrictTagMatching"));
        }
        return matcher instanceof XmlAwareBraceMatcher && ((XmlAwareBraceMatcher)matcher).isStrictTagMatching(fileType, group);
    }

    private static boolean areTagsCaseSensitive(@NotNull BraceMatcher matcher, @NotNull FileType fileType, int tokenGroup) {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "areTagsCaseSensitive"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "areTagsCaseSensitive"));
        }
        return matcher instanceof XmlAwareBraceMatcher && ((XmlAwareBraceMatcher)matcher).areTagsCaseSensitive(fileType, tokenGroup);
    }

    @Nullable
    private static String getTagName(@NotNull BraceMatcher matcher, @NotNull CharSequence fileText, @NotNull HighlighterIterator iterator) {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "getTagName"));
        }
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "getTagName"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/codeInsight/highlighting/BraceMatchingUtil", "getTagName"));
        }
        if (matcher instanceof XmlAwareBraceMatcher) {
            return ((XmlAwareBraceMatcher)matcher).getTagName(fileText, iterator);
        }
        return null;
    }

    private static class DefaultBraceMatcher
    implements BraceMatcher {
        private DefaultBraceMatcher() {
        }

        @Override
        public int getBraceTokenGroupId(IElementType tokenType) {
            return -1;
        }

        @Override
        public boolean isLBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
            return false;
        }

        @Override
        public boolean isRBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
            return false;
        }

        @Override
        public boolean isPairBraces(IElementType tokenType, IElementType tokenType2) {
            return false;
        }

        @Override
        public boolean isStructuralBrace(HighlighterIterator iterator, CharSequence text, FileType fileType) {
            return false;
        }

        @Override
        public IElementType getOppositeBraceTokenType(@NotNull IElementType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/highlighting/BraceMatchingUtil$DefaultBraceMatcher", "getOppositeBraceTokenType"));
            }
            return null;
        }

        @Override
        public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
            if (lbraceType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lbraceType", "com/intellij/codeInsight/highlighting/BraceMatchingUtil$DefaultBraceMatcher", "isPairedBracesAllowedBeforeType"));
            }
            return true;
        }

        @Override
        public int getCodeConstructStart(PsiFile file2, int openingBraceOffset) {
            return openingBraceOffset;
        }
    }

    private static class BraceMatcherHolder {
        private static final BraceMatcher ourDefaultBraceMatcher = new DefaultBraceMatcher();

        private BraceMatcherHolder() {
        }
    }

    private static class MatchBraceContext {
        private final CharSequence fileText;
        private final FileType fileType;
        private final HighlighterIterator iterator;
        private final boolean forward;
        private final IElementType brace1Token;
        private final int group;
        private final String brace1TagName;
        private final boolean isStrict;
        private final boolean isCaseSensitive;
        @NotNull
        private final BraceMatcher myMatcher;
        private final Stack<IElementType> myBraceStack;
        private final Stack<String> myTagNameStack;

        MatchBraceContext(@NotNull CharSequence fileText, @NotNull FileType fileType, @NotNull HighlighterIterator iterator, boolean forward) {
            if (fileText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/codeInsight/highlighting/BraceMatchingUtil$MatchBraceContext", "<init>"));
            }
            if (fileType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/highlighting/BraceMatchingUtil$MatchBraceContext", "<init>"));
            }
            if (iterator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/codeInsight/highlighting/BraceMatchingUtil$MatchBraceContext", "<init>"));
            }
            this(fileText, fileType, iterator, forward, BraceMatchingUtil.isStrictTagMatching(BraceMatchingUtil.getBraceMatcher(fileType, iterator), fileType, BraceMatchingUtil.getTokenGroup(iterator.getTokenType(), fileType)));
        }

        MatchBraceContext(@NotNull CharSequence fileText, @NotNull FileType fileType, @NotNull HighlighterIterator iterator, boolean forward, boolean strict) {
            if (fileText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/codeInsight/highlighting/BraceMatchingUtil$MatchBraceContext", "<init>"));
            }
            if (fileType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/highlighting/BraceMatchingUtil$MatchBraceContext", "<init>"));
            }
            if (iterator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/codeInsight/highlighting/BraceMatchingUtil$MatchBraceContext", "<init>"));
            }
            this.myBraceStack = new Stack();
            this.myTagNameStack = new Stack();
            this.fileText = fileText;
            this.fileType = fileType;
            this.iterator = iterator;
            this.forward = forward;
            this.myMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
            this.brace1Token = this.iterator.getTokenType();
            this.group = BraceMatchingUtil.getTokenGroup(this.brace1Token, this.fileType);
            this.brace1TagName = BraceMatchingUtil.getTagName(this.myMatcher, this.fileText, this.iterator);
            this.isCaseSensitive = BraceMatchingUtil.areTagsCaseSensitive(this.myMatcher, this.fileType, this.group);
            this.isStrict = strict;
        }

        boolean doBraceMatch() {
            boolean matched;
            block12: {
                this.myBraceStack.clear();
                this.myTagNameStack.clear();
                this.myBraceStack.push((Object)this.brace1Token);
                if (this.isStrict) {
                    this.myTagNameStack.push((Object)this.brace1TagName);
                }
                matched = false;
                while (true) {
                    if (!this.forward) {
                        this.iterator.retreat();
                    } else {
                        this.iterator.advance();
                    }
                    if (this.iterator.atEnd()) break block12;
                    IElementType tokenType = this.iterator.getTokenType();
                    if (BraceMatchingUtil.getTokenGroup(tokenType, this.fileType) != this.group) continue;
                    String tagName = BraceMatchingUtil.getTagName(this.myMatcher, this.fileText, this.iterator);
                    if (!this.isStrict && !Comparing.equal((String)this.brace1TagName, (String)tagName, (boolean)this.isCaseSensitive)) continue;
                    if (this.forward ? BraceMatchingUtil.isLBraceToken(this.iterator, this.fileText, this.fileType) : BraceMatchingUtil.isRBraceToken(this.iterator, this.fileText, this.fileType)) {
                        this.myBraceStack.push((Object)tokenType);
                        if (!this.isStrict) continue;
                        this.myTagNameStack.push((Object)tagName);
                        continue;
                    }
                    if (!(this.forward ? BraceMatchingUtil.isRBraceToken(this.iterator, this.fileText, this.fileType) : BraceMatchingUtil.isLBraceToken(this.iterator, this.fileText, this.fileType))) continue;
                    IElementType topTokenType = (IElementType)this.myBraceStack.pop();
                    String topTagName = null;
                    if (this.isStrict) {
                        topTagName = (String)this.myTagNameStack.pop();
                    }
                    if (!this.isStrict) {
                        IElementType baseType = this.myMatcher.getOppositeBraceTokenType(tokenType);
                        if (this.myBraceStack.contains((Object)baseType)) {
                            while (!BraceMatchingUtil.isPairBraces(topTokenType, tokenType, this.fileType) && !this.myBraceStack.empty()) {
                                topTokenType = (IElementType)this.myBraceStack.pop();
                            }
                        } else if (!(this.brace1TagName != null && this.brace1TagName.equals(tagName) || BraceMatchingUtil.isPairBraces(topTokenType, tokenType, this.fileType))) {
                            this.myBraceStack.push((Object)topTokenType);
                            continue;
                        }
                    }
                    if (!BraceMatchingUtil.isPairBraces(topTokenType, tokenType, this.fileType) || this.isStrict && !Comparing.equal((String)topTagName, (String)tagName, (boolean)this.isCaseSensitive)) {
                        matched = false;
                        break block12;
                    }
                    if (this.myBraceStack.isEmpty()) break;
                }
                matched = true;
            }
            return matched;
        }
    }
}

