/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class TemplateLanguageErrorFilter
extends HighlightErrorFilter {
    @NotNull
    private final TokenSet myTemplateExpressionStartTokens;
    @NotNull
    private final Class myTemplateFileViewProviderClass;
    private final Set<Language> knownLanguageSet;
    private static final Key<Class> TEMPLATE_VIEW_PROVIDER_CLASS_KEY = Key.create((String)"TEMPLATE_VIEW_PROVIDER_CLASS");

    protected TemplateLanguageErrorFilter(@NotNull TokenSet templateExpressionStartTokens, @NotNull Class templateFileViewProviderClass) {
        if (templateExpressionStartTokens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateExpressionStartTokens", "com/intellij/codeInsight/highlighting/TemplateLanguageErrorFilter", "<init>"));
        }
        if (templateFileViewProviderClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateFileViewProviderClass", "com/intellij/codeInsight/highlighting/TemplateLanguageErrorFilter", "<init>"));
        }
        this(templateExpressionStartTokens, templateFileViewProviderClass, new String[0]);
    }

    protected TemplateLanguageErrorFilter(@NotNull TokenSet templateExpressionStartTokens, @NotNull Class templateFileViewProviderClass, String ... knownSubLanguageNames) {
        if (templateExpressionStartTokens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateExpressionStartTokens", "com/intellij/codeInsight/highlighting/TemplateLanguageErrorFilter", "<init>"));
        }
        if (templateFileViewProviderClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateFileViewProviderClass", "com/intellij/codeInsight/highlighting/TemplateLanguageErrorFilter", "<init>"));
        }
        if (knownSubLanguageNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "knownSubLanguageNames", "com/intellij/codeInsight/highlighting/TemplateLanguageErrorFilter", "<init>"));
        }
        this.myTemplateExpressionStartTokens = TokenSet.create((IElementType[])templateExpressionStartTokens.getTypes());
        this.myTemplateFileViewProviderClass = templateFileViewProviderClass;
        ArrayList<String> knownSubLanguageList = new ArrayList<String>(Arrays.asList(knownSubLanguageNames));
        knownSubLanguageList.add("JavaScript");
        knownSubLanguageList.add("CSS");
        this.knownLanguageSet = new HashSet<Language>();
        for (String name : knownSubLanguageList) {
            Language language = Language.findLanguageByID((String)name);
            if (language == null) continue;
            this.knownLanguageSet.add(language);
        }
    }

    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/highlighting/TemplateLanguageErrorFilter", "shouldHighlightErrorElement"));
        }
        if (this.isKnownSubLanguage(element.getParent().getLanguage())) {
            PsiLanguageInjectionHost host;
            Class templateClass = (Class)element.getUserData(TEMPLATE_VIEW_PROVIDER_CLASS_KEY);
            if (templateClass != null && templateClass != this.myTemplateFileViewProviderClass) {
                return true;
            }
            PsiFile psiFile = element.getContainingFile();
            int offset = element.getTextOffset();
            InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)element.getProject());
            if (injectedLanguageManager.isInjectedFragment(psiFile) && (host = injectedLanguageManager.getInjectionHost((PsiElement)element)) != null) {
                psiFile = host.getContainingFile();
                offset = injectedLanguageManager.injectedToHost((PsiElement)element, offset);
            }
            FileViewProvider viewProvider = psiFile.getViewProvider();
            element.putUserData(TEMPLATE_VIEW_PROVIDER_CLASS_KEY, viewProvider.getClass());
            if (viewProvider.getClass() != this.myTemplateFileViewProviderClass) {
                return true;
            }
            if (this.shouldIgnoreErrorAt(viewProvider, offset) || this.shouldIgnoreErrorAt(viewProvider, offset + 1)) {
                return false;
            }
        }
        return true;
    }

    protected boolean shouldIgnoreErrorAt(@NotNull FileViewProvider viewProvider, int offset) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/codeInsight/highlighting/TemplateLanguageErrorFilter", "shouldIgnoreErrorAt"));
        }
        PsiElement element = viewProvider.findElementAt(offset, viewProvider.getBaseLanguage());
        if (element instanceof PsiWhiteSpace) {
            element = element.getNextSibling();
        }
        return element != null && this.myTemplateExpressionStartTokens.contains(element.getNode().getElementType());
    }

    protected boolean isKnownSubLanguage(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/highlighting/TemplateLanguageErrorFilter", "isKnownSubLanguage"));
        }
        for (Language knownLanguage : this.knownLanguageSet) {
            if (!language.is(knownLanguage) && !knownLanguage.getDialects().contains(language)) continue;
            return true;
        }
        return false;
    }
}

