/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.EmptyLookupItem;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.psi.impl.DebugUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class LookupOffsets
extends DocumentAdapter {
    private String myAdditionalPrefix = "";
    private String myInitialPrefix;
    private boolean myStableStart;
    private String myStartDisposeTrace;
    @NotNull
    private RangeMarker myLookupStartMarker;
    private int myRemovedPrefix;
    private final RangeMarker myLookupOriginalStartMarker;
    private final Editor myEditor;

    public LookupOffsets(Editor editor) {
        this.myEditor = editor;
        int caret = this.getPivotOffset();
        this.myLookupOriginalStartMarker = this.createLeftGreedyMarker(caret);
        this.myLookupStartMarker = this.createLeftGreedyMarker(caret);
        this.myEditor.getDocument().addDocumentListener((DocumentListener)this);
    }

    public void documentChanged(DocumentEvent e) {
        if (this.myStartDisposeTrace == null && !this.myLookupStartMarker.isValid()) {
            this.myStartDisposeTrace = e + "\n" + DebugUtil.currentStackTrace();
        }
    }

    private RangeMarker createLeftGreedyMarker(int start) {
        RangeMarker marker = this.myEditor.getDocument().createRangeMarker(start, start);
        marker.setGreedyToLeft(true);
        return marker;
    }

    private int getPivotOffset() {
        return this.myEditor.getSelectionModel().hasSelection() ? this.myEditor.getSelectionModel().getSelectionStart() : this.myEditor.getCaretModel().getOffset();
    }

    public String getAdditionalPrefix() {
        return this.myAdditionalPrefix;
    }

    public void appendPrefix(char c) {
        this.myAdditionalPrefix = this.myAdditionalPrefix + c;
        this.myInitialPrefix = null;
    }

    public boolean truncatePrefix() {
        int len = this.myAdditionalPrefix.length();
        if (len == 0) {
            ++this.myRemovedPrefix;
            return false;
        }
        this.myAdditionalPrefix = this.myAdditionalPrefix.substring(0, len - 1);
        this.myInitialPrefix = null;
        return true;
    }

    void checkMinPrefixLengthChanges(Collection<LookupElement> items, LookupImpl lookup) {
        if (this.myStableStart) {
            return;
        }
        if (!lookup.isCalculating() && !items.isEmpty()) {
            this.myStableStart = true;
        }
        int minPrefixLength = items.isEmpty() ? 0 : Integer.MAX_VALUE;
        for (LookupElement item : items) {
            if (item instanceof EmptyLookupItem) continue;
            minPrefixLength = Math.min(lookup.itemMatcher(item).getPrefix().length(), minPrefixLength);
        }
        int start = this.getPivotOffset() - minPrefixLength - this.myAdditionalPrefix.length() + this.myRemovedPrefix;
        start = Math.max(Math.min(start, this.myEditor.getDocument().getTextLength()), 0);
        if (this.myLookupStartMarker.isValid() && this.myLookupStartMarker.getStartOffset() == start && this.myLookupStartMarker.getEndOffset() == start) {
            return;
        }
        this.myLookupStartMarker.dispose();
        this.myLookupStartMarker = this.createLeftGreedyMarker(start);
        this.myStartDisposeTrace = null;
    }

    int getLookupStart(String disposeTrace) {
        if (!this.myLookupStartMarker.isValid()) {
            throw new AssertionError((Object)("Invalid lookup start: " + this.myLookupStartMarker + ", " + this.myEditor + ", disposeTrace=" + disposeTrace + ";\n" + this.myStartDisposeTrace));
        }
        return this.myLookupStartMarker.getStartOffset();
    }

    int getLookupOriginalStart() {
        return this.myLookupOriginalStartMarker.isValid() ? this.myLookupOriginalStartMarker.getStartOffset() : -1;
    }

    boolean performGuardedChange(Runnable change) {
        if (!this.myLookupStartMarker.isValid()) {
            throw new AssertionError((Object)("Invalid start: " + this.myEditor + ", trace=" + this.myStartDisposeTrace));
        }
        change.run();
        return this.myLookupStartMarker.isValid();
    }

    void setInitialPrefix(String presentPrefix, boolean explicitlyInvoked) {
        this.myInitialPrefix = this.myAdditionalPrefix.length() == 0 && this.myInitialPrefix == null && !explicitlyInvoked ? presentPrefix : null;
    }

    void clearAdditionalPrefix() {
        this.myAdditionalPrefix = "";
        this.myRemovedPrefix = 0;
    }

    void restorePrefix() {
        if (this.myInitialPrefix == null || !this.myLookupStartMarker.isValid()) {
            return;
        }
        this.myEditor.getDocument().replaceString(this.myLookupStartMarker.getStartOffset(), this.myEditor.getCaretModel().getOffset(), (CharSequence)this.myInitialPrefix);
    }

    void disposeMarkers() {
        this.myEditor.getDocument().removeDocumentListener((DocumentListener)this);
        this.myLookupStartMarker.dispose();
        this.myLookupOriginalStartMarker.dispose();
    }

    public int getPrefixLength(LookupElement item, LookupImpl lookup) {
        return lookup.itemPattern(item).length() - this.myRemovedPrefix;
    }
}

