/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.actions;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandlerBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nullable;

public class GotoBreakContinueHandler
extends GotoDeclarationHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.navigation.actions.GotoBreakContinueHandler");

    @Override
    @Nullable
    public PsiElement getGotoDeclarationTarget(@Nullable PsiElement elementAt, Editor editor) {
        if (elementAt instanceof PsiKeyword) {
            IElementType type = ((PsiKeyword)elementAt).getTokenType();
            if (type == JavaTokenType.CONTINUE_KEYWORD) {
                if (elementAt.getParent() instanceof PsiContinueStatement) {
                    return ((PsiContinueStatement)elementAt.getParent()).findContinuedStatement();
                }
            } else if (type == JavaTokenType.BREAK_KEYWORD && elementAt.getParent() instanceof PsiBreakStatement) {
                PsiElement nextSibling;
                PsiStatement statement2 = ((PsiBreakStatement)elementAt.getParent()).findExitedStatement();
                if (statement2 == null) {
                    return null;
                }
                if (statement2.getParent() instanceof PsiLabeledStatement) {
                    statement2 = (PsiStatement)statement2.getParent();
                }
                for (nextSibling = statement2.getNextSibling(); !(nextSibling instanceof PsiStatement) && nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
                }
                if (nextSibling != null) {
                    return nextSibling;
                }
                nextSibling = statement2.getNextSibling();
                if (nextSibling != null) {
                    return nextSibling;
                }
                return statement2.getLastChild();
            }
        } else if (elementAt instanceof PsiIdentifier) {
            PsiElement parent = elementAt.getParent();
            PsiStatement statement3 = null;
            if (parent instanceof PsiContinueStatement) {
                statement3 = ((PsiContinueStatement)parent).findContinuedStatement();
            } else if (parent instanceof PsiBreakStatement) {
                statement3 = ((PsiBreakStatement)parent).findExitedStatement();
            }
            if (statement3 == null) {
                return null;
            }
            LOG.assertTrue(statement3.getParent() instanceof PsiLabeledStatement);
            return ((PsiLabeledStatement)statement3.getParent()).getLabelIdentifier();
        }
        return null;
    }
}

