/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateContext {
    private final Map<String, Boolean> myContextStates = ContainerUtil.newLinkedHashMap();

    public TemplateContext createCopy() {
        TemplateContext cloneResult = new TemplateContext();
        cloneResult.myContextStates.putAll(this.myContextStates);
        return cloneResult;
    }

    @Nullable
    TemplateContextType getDifference(@NotNull TemplateContext defaultContext) {
        if (defaultContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultContext", "com/intellij/codeInsight/template/impl/TemplateContext", "getDifference"));
        }
        return (TemplateContextType)ContainerUtil.find((Object[])TemplateManagerImpl.getAllContextTypes(), type -> {
            if (defaultContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultContext", "com/intellij/codeInsight/template/impl/TemplateContext", "lambda$getDifference$0"));
            }
            return this.isEnabled((TemplateContextType)type) != defaultContext.isEnabled((TemplateContextType)type);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled(@NotNull TemplateContextType contextType) {
        if (contextType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "com/intellij/codeInsight/template/impl/TemplateContext", "isEnabled"));
        }
        Map<String, Boolean> map = this.myContextStates;
        synchronized (map) {
            Boolean storedValue = this.getOwnValue(contextType);
            if (storedValue == null) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                TemplateContextType baseContextType = contextType.getBaseContextType();
                return baseContextType != null && this.isEnabled(baseContextType);
            }
            return storedValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Boolean getOwnValue(TemplateContextType contextType) {
        Map<String, Boolean> map = this.myContextStates;
        synchronized (map) {
            return this.myContextStates.get(contextType.getContextId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(TemplateContextType contextType, boolean value) {
        Map<String, Boolean> map = this.myContextStates;
        synchronized (map) {
            this.myContextStates.put(contextType.getContextId(), value);
        }
    }

    @VisibleForTesting
    public void setDefaultContext(@NotNull TemplateContext defContext) {
        if (defContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defContext", "com/intellij/codeInsight/template/impl/TemplateContext", "setDefaultContext"));
        }
        HashMap<String, Boolean> copy = new HashMap<String, Boolean>(this.myContextStates);
        this.myContextStates.clear();
        this.myContextStates.putAll(defContext.myContextStates);
        this.myContextStates.putAll(copy);
    }

    @VisibleForTesting
    public void readTemplateContext(Element element) {
        for (Element option : element.getChildren("option")) {
            String name = option.getAttributeValue("name");
            String value = option.getAttributeValue("value");
            if (name == null || value == null) continue;
            this.myContextStates.put(name, Boolean.parseBoolean(value));
        }
        this.myContextStates.putAll(this.makeInheritanceExplicit());
    }

    @NotNull
    private Map<String, Boolean> makeInheritanceExplicit() {
        HashMap explicitStates = ContainerUtil.newHashMap();
        for (TemplateContextType type : ContainerUtil.filter((Object[])TemplateManagerImpl.getAllContextTypes(), this::isDisabledByInheritance)) {
            explicitStates.put(type.getContextId(), false);
        }
        HashMap hashMap = explicitStates;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/TemplateContext", "makeInheritanceExplicit"));
        }
        return hashMap;
    }

    private boolean isDisabledByInheritance(TemplateContextType type) {
        return !this.hasOwnValue(type) && !this.isEnabled(type) && JBIterable.generate((Object)type, TemplateContextType::getBaseContextType).filter(this::hasOwnValue).first() != null;
    }

    private boolean hasOwnValue(TemplateContextType t) {
        return this.getOwnValue(t) != null;
    }

    @VisibleForTesting
    public void writeTemplateContext(Element element) throws WriteExternalException {
        for (TemplateContextType type : TemplateManagerImpl.getAllContextTypes()) {
            boolean baseEnabled;
            Boolean ownValue = this.getOwnValue(type);
            if (ownValue == null) continue;
            TemplateContextType base = type.getBaseContextType();
            boolean bl = baseEnabled = base != null && this.isEnabled(base);
            if (ownValue == baseEnabled) continue;
            Element optionElement = new Element("option");
            optionElement.setAttribute("name", type.getContextId());
            optionElement.setAttribute("value", ownValue.toString());
            element.addContent(optionElement);
        }
    }

    public String toString() {
        return this.myContextStates.toString();
    }
}

