/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SingletonSet;
import gnu.trove.THashMap;
import gnu.trove.TObjectFunction;
import gnu.trove.TObjectObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SmartHashMap<K, V>
extends THashMap<K, V> {
    private K theKey;
    private V theValue;

    public boolean containsKey(@NotNull Object key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/SmartHashMap", "containsKey"));
        }
        K theKey = this.theKey;
        if (theKey != null) {
            return this.eq(theKey, key2);
        }
        return !super.isEmpty() && super.containsKey(key2);
    }

    public V put(@NotNull K key2, V value) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/SmartHashMap", "put"));
        }
        K theKey = this.theKey;
        if (theKey != null) {
            if (this.eq(theKey, key2)) {
                return this.theValue;
            }
            super.put(theKey, this.theValue);
            this.theKey = null;
        } else if (super.isEmpty()) {
            this.theKey = key2;
            this.theValue = value;
            return null;
        }
        return (V)super.put(key2, value);
    }

    private boolean eq(K obj, K theKey) {
        return theKey == obj || this._hashingStrategy.equals(theKey, obj);
    }

    public boolean equals(@NotNull Object other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/codeInspection/SmartHashMap", "equals"));
        }
        K theKey = this.theKey;
        if (theKey != null) {
            if (!(other instanceof Map) || ((Map)other).size() != 1) {
                return false;
            }
            Map.Entry entry = ((Map)other).entrySet().iterator().next();
            return this.eq(theKey, entry.getKey()) && Comparing.equal(this.theValue, entry.getValue());
        }
        return super.equals(other);
    }

    public int hashCode() {
        K theKey = this.theKey;
        if (theKey != null) {
            return this._hashingStrategy.computeHashCode(theKey);
        }
        return super.hashCode();
    }

    public void clear() {
        this.theKey = null;
        this.theValue = null;
        super.clear();
    }

    public int size() {
        K theKey = this.theKey;
        if (theKey != null) {
            return 1;
        }
        return super.size();
    }

    public boolean isEmpty() {
        K theKey = this.theKey;
        return theKey == null && super.isEmpty();
    }

    public V remove(@NotNull Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/codeInspection/SmartHashMap", "remove"));
        }
        K theKey = this.theKey;
        if (theKey != null) {
            if (this.eq(theKey, obj)) {
                this.theKey = null;
                V value = this.theValue;
                this.theValue = null;
                return value;
            }
            return null;
        }
        return (V)super.remove(obj);
    }

    @NotNull
    public Set<K> keySet() {
        K theKey = this.theKey;
        if (theKey != null) {
            SingletonSet singletonSet = new SingletonSet(theKey);
            if (singletonSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SmartHashMap", "keySet"));
            }
            return singletonSet;
        }
        Set set = super.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SmartHashMap", "keySet"));
        }
        return set;
    }

    @NotNull
    public Collection<V> values() {
        K theKey = this.theKey;
        if (theKey != null) {
            SingletonSet singletonSet = new SingletonSet(this.theValue);
            if (singletonSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SmartHashMap", "values"));
            }
            return singletonSet;
        }
        Collection collection = super.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SmartHashMap", "values"));
        }
        return collection;
    }

    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        K theKey = this.theKey;
        if (theKey != null) {
            SingletonSet singletonSet = new SingletonSet(new AbstractMap.SimpleEntry<K, V>(theKey, this.theValue));
            if (singletonSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SmartHashMap", "entrySet"));
            }
            return singletonSet;
        }
        Set set = super.entrySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SmartHashMap", "entrySet"));
        }
        return set;
    }

    public V get(Object key2) {
        K theKey = this.theKey;
        if (theKey != null) {
            return this.eq(theKey, key2) ? (V)this.theValue : null;
        }
        return (V)super.get(key2);
    }

    public boolean containsValue(Object val) {
        K theKey = this.theKey;
        if (theKey != null) {
            return Comparing.equal(this.theValue, (Object)val);
        }
        return super.containsValue(val);
    }

    public THashMap<K, V> clone() {
        throw new IncorrectOperationException();
    }

    public void transformValues(TObjectFunction<V, V> function) {
        throw new IncorrectOperationException();
    }

    public boolean retainEntries(TObjectObjectProcedure<K, V> procedure) {
        throw new IncorrectOperationException();
    }

    public boolean forEachEntry(TObjectObjectProcedure<K, V> procedure) {
        throw new IncorrectOperationException();
    }

    public boolean forEachValue(TObjectProcedure<V> procedure) {
        throw new IncorrectOperationException();
    }

    public boolean forEachKey(TObjectProcedure<K> procedure) {
        throw new IncorrectOperationException();
    }
}

