/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressManagerImpl
extends SuppressManager {
    private static final Logger LOG = Logger.getInstance(SuppressManager.class);

    @NotNull
    public SuppressIntentionAction[] createSuppressActions(@NotNull HighlightDisplayKey displayKey) {
        if (displayKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayKey", "com/intellij/codeInspection/SuppressManagerImpl", "createSuppressActions"));
        }
        SuppressQuickFix[] batchSuppressActions = this.createBatchSuppressActions(displayKey);
        SuppressIntentionAction[] suppressIntentionActionArray = SuppressIntentionActionFromFix.convertBatchToSuppressIntentionActions(batchSuppressActions);
        if (suppressIntentionActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SuppressManagerImpl", "createSuppressActions"));
        }
        return suppressIntentionActionArray;
    }

    @NotNull
    public SuppressQuickFix[] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/SuppressManagerImpl", "getSuppressActions"));
        }
        HighlightDisplayKey displayKey = HighlightDisplayKey.findById((String)toolId);
        LOG.assertTrue(displayKey != null, (Object)("Display key is null for `" + toolId + "` tool"));
        SuppressQuickFix[] suppressQuickFixArray = this.createBatchSuppressActions(displayKey);
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SuppressManagerImpl", "getSuppressActions"));
        }
        return suppressQuickFixArray;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/SuppressManagerImpl", "isSuppressedFor"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/SuppressManagerImpl", "isSuppressedFor"));
        }
        return JavaSuppressionUtil.getElementToolSuppressedIn(element, toolId) != null;
    }

    @Nullable
    public PsiElement getElementMemberSuppressedIn(@NotNull PsiDocCommentOwner owner, @NotNull String inspectionToolID) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/SuppressManagerImpl", "getElementMemberSuppressedIn"));
        }
        if (inspectionToolID == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionToolID", "com/intellij/codeInspection/SuppressManagerImpl", "getElementMemberSuppressedIn"));
        }
        return JavaSuppressionUtil.getElementMemberSuppressedIn(owner, inspectionToolID);
    }

    @Nullable
    public PsiElement getAnnotationMemberSuppressedIn(@NotNull PsiModifierListOwner owner, @NotNull String inspectionToolID) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/SuppressManagerImpl", "getAnnotationMemberSuppressedIn"));
        }
        if (inspectionToolID == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionToolID", "com/intellij/codeInspection/SuppressManagerImpl", "getAnnotationMemberSuppressedIn"));
        }
        return JavaSuppressionUtil.getAnnotationMemberSuppressedIn(owner, inspectionToolID);
    }

    @Nullable
    public PsiElement getDocCommentToolSuppressedIn(@NotNull PsiDocCommentOwner owner, @NotNull String inspectionToolID) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/SuppressManagerImpl", "getDocCommentToolSuppressedIn"));
        }
        if (inspectionToolID == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionToolID", "com/intellij/codeInspection/SuppressManagerImpl", "getDocCommentToolSuppressedIn"));
        }
        return JavaSuppressionUtil.getDocCommentToolSuppressedIn(owner, inspectionToolID);
    }

    @NotNull
    public Collection<String> getInspectionIdsSuppressedInAnnotation(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/SuppressManagerImpl", "getInspectionIdsSuppressedInAnnotation"));
        }
        Collection<String> collection = JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation(owner);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SuppressManagerImpl", "getInspectionIdsSuppressedInAnnotation"));
        }
        return collection;
    }

    @Nullable
    public String getSuppressedInspectionIdsIn(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/SuppressManagerImpl", "getSuppressedInspectionIdsIn"));
        }
        return JavaSuppressionUtil.getSuppressedInspectionIdsIn(element);
    }

    @Nullable
    public PsiElement getElementToolSuppressedIn(@NotNull PsiElement place, @NotNull String toolId) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInspection/SuppressManagerImpl", "getElementToolSuppressedIn"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/SuppressManagerImpl", "getElementToolSuppressedIn"));
        }
        return JavaSuppressionUtil.getElementToolSuppressedIn(place, toolId);
    }

    public boolean canHave15Suppressions(@NotNull PsiElement file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/SuppressManagerImpl", "canHave15Suppressions"));
        }
        return JavaSuppressionUtil.canHave15Suppressions(file2);
    }

    public boolean alreadyHas14Suppressions(@NotNull PsiDocCommentOwner commentOwner) {
        if (commentOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commentOwner", "com/intellij/codeInspection/SuppressManagerImpl", "alreadyHas14Suppressions"));
        }
        return JavaSuppressionUtil.alreadyHas14Suppressions(commentOwner);
    }
}

