/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.PerformFixesModalTask;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class QuickFixAction
extends AnAction
implements CustomComponentAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + QuickFixAction.class.getName()));
    public static final QuickFixAction[] EMPTY = new QuickFixAction[0];
    protected final InspectionToolWrapper myToolWrapper;

    protected static InspectionResultsView getInvoker(AnActionEvent e) {
        return (InspectionResultsView)InspectionResultsView.DATA_KEY.getData(e.getDataContext());
    }

    protected QuickFixAction(String text, @NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/QuickFixAction", "<init>"));
        }
        this(text, AllIcons.Actions.CreateFromUsage, null, toolWrapper);
    }

    protected QuickFixAction(String text, Icon icon, KeyStroke keyStroke, @NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/QuickFixAction", "<init>"));
        }
        super(text, null, icon);
        this.myToolWrapper = toolWrapper;
        if (keyStroke != null) {
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(keyStroke), null);
        }
    }

    public void update(AnActionEvent e) {
        InspectionResultsView view = QuickFixAction.getInvoker(e);
        if (view == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setVisible(false);
        e.getPresentation().setEnabled(false);
        InspectionTree tree = view.getTree();
        InspectionToolWrapper toolWrapper = tree.getSelectedToolWrapper(true);
        if (!view.isSingleToolInSelection() || toolWrapper != this.myToolWrapper) {
            return;
        }
        if (!this.isProblemDescriptorsAcceptable() && tree.getSelectedElements().length > 0 || this.isProblemDescriptorsAcceptable() && tree.getSelectedDescriptors().length > 0) {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(true);
        }
    }

    protected boolean isProblemDescriptorsAcceptable() {
        return false;
    }

    public String getText() {
        return this.getTemplatePresentation().getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent e) {
        InspectionResultsView view = QuickFixAction.getInvoker(e);
        InspectionTree tree = view.getTree();
        try {
            Ref descriptors = Ref.create();
            THashSet readOnlyFiles = new THashSet();
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> QuickFixAction.lambda$actionPerformed$1(descriptors, tree, (Set)readOnlyFiles), InspectionsBundle.message((String)"preparing.for.apply.fix", (Object[])new Object[0]), true, e.getProject())) {
                return;
            }
            if (this.isProblemDescriptorsAcceptable() && ((CommonProblemDescriptor[])descriptors.get()).length > 0) {
                this.doApplyFix(view.getProject(), (CommonProblemDescriptor[])descriptors.get(), (Set<VirtualFile>)readOnlyFiles, tree.getContext());
            } else {
                this.doApplyFix(QuickFixAction.getSelectedElements(view), view);
            }
        }
        finally {
            view.setApplyingFix(false);
        }
    }

    protected void applyFix(@NotNull Project project2, @NotNull GlobalInspectionContextImpl context, @NotNull CommonProblemDescriptor[] descriptors, @NotNull Set<PsiElement> ignoredElements) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/QuickFixAction", "applyFix"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/QuickFixAction", "applyFix"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/ex/QuickFixAction", "applyFix"));
        }
        if (ignoredElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredElements", "com/intellij/codeInspection/ex/QuickFixAction", "applyFix"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doApplyFix(@NotNull Project project2, @NotNull CommonProblemDescriptor[] descriptors, @NotNull Set<VirtualFile> readOnlyFiles, @NotNull GlobalInspectionContextImpl context) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/QuickFixAction", "doApplyFix"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/ex/QuickFixAction", "doApplyFix"));
        }
        if (readOnlyFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readOnlyFiles", "com/intellij/codeInspection/ex/QuickFixAction", "doApplyFix"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/QuickFixAction", "doApplyFix"));
        }
        if (!FileModificationService.getInstance().prepareVirtualFilesForWrite(project2, readOnlyFiles)) {
            return;
        }
        RefManagerImpl refManager = (RefManagerImpl)context.getRefManager();
        boolean initial = refManager.isInProcess();
        refManager.inspectionReadActionFinished();
        try {
            HashSet<PsiElement> ignoredElements = new HashSet<PsiElement>();
            String templatePresentationText = this.getTemplatePresentation().getText();
            assert (templatePresentationText != null);
            CommandProcessor.getInstance().executeCommand(project2, () -> {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/QuickFixAction", "lambda$doApplyFix$2"));
                }
                if (descriptors == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/ex/QuickFixAction", "lambda$doApplyFix$2"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/QuickFixAction", "lambda$doApplyFix$2"));
                }
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project2);
                SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project2, templatePresentationText, true);
                progressTask.setMinIterationTime(200L);
                progressTask.setTask(new PerformFixesTask(project2, descriptors, ignoredElements, progressTask, context));
                ProgressManager.getInstance().run((Task)progressTask);
            }, templatePresentationText, null);
            QuickFixAction.refreshViews(project2, ignoredElements, this.myToolWrapper);
        }
        finally {
            if (initial) {
                refManager.inspectionReadActionStarted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doApplyFix(@NotNull RefEntity[] refElements, @NotNull InspectionResultsView view) {
        if (refElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElements", "com/intellij/codeInspection/ex/QuickFixAction", "doApplyFix"));
        }
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ex/QuickFixAction", "doApplyFix"));
        }
        RefManagerImpl refManager = (RefManagerImpl)view.getGlobalInspectionContext().getRefManager();
        boolean initial = refManager.isInProcess();
        refManager.inspectionReadActionFinished();
        try {
            boolean[] refreshNeeded = new boolean[]{false};
            if (refElements.length > 0) {
                Project project2 = refElements[0].getRefManager().getProject();
                CommandProcessor.getInstance().executeCommand(project2, () -> {
                    if (refElements == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElements", "com/intellij/codeInspection/ex/QuickFixAction", "lambda$doApplyFix$4"));
                    }
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(project2);
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        if (refElements == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElements", "com/intellij/codeInspection/ex/QuickFixAction", "lambda$null$3"));
                        }
                        refreshNeeded[0] = this.applyFix(refElements);
                    });
                }, this.getTemplatePresentation().getText(), null);
            }
            if (refreshNeeded[0]) {
                QuickFixAction.refreshViews(view.getProject(), refElements, this.myToolWrapper);
            }
        }
        finally {
            if (initial) {
                refManager.inspectionReadActionStarted();
            }
        }
    }

    public static void removeElements(@NotNull RefEntity[] refElements, @NotNull Project project2, @NotNull InspectionToolWrapper toolWrapper) {
        if (refElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElements", "com/intellij/codeInspection/ex/QuickFixAction", "removeElements"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/QuickFixAction", "removeElements"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/QuickFixAction", "removeElements"));
        }
        QuickFixAction.refreshViews(project2, refElements, toolWrapper);
        ArrayList deletedRefs = new ArrayList(1);
        for (RefEntity refElement : refElements) {
            if (!(refElement instanceof RefElement)) continue;
            refElement.getRefManager().removeRefElement((RefElement)refElement, deletedRefs);
        }
    }

    private static Set<VirtualFile> getReadOnlyFiles(@NotNull RefEntity[] refElements) {
        if (refElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElements", "com/intellij/codeInspection/ex/QuickFixAction", "getReadOnlyFiles"));
        }
        THashSet readOnlyFiles = new THashSet();
        for (RefEntity refElement : refElements) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiElement = refElement instanceof RefElement ? ((RefElement)refElement).getElement() : null;
            if (psiElement == null || psiElement.getContainingFile() == null) continue;
            readOnlyFiles.add(psiElement.getContainingFile().getVirtualFile());
        }
        return readOnlyFiles;
    }

    private static RefEntity[] getSelectedElements(InspectionResultsView view) {
        if (view == null) {
            return new RefElement[0];
        }
        ArrayList<RefEntity> selection = new ArrayList<RefEntity>(Arrays.asList(view.getTree().getSelectedElements()));
        PsiDocumentManager.getInstance((Project)view.getProject()).commitAllDocuments();
        Collections.sort(selection, (o1, o2) -> {
            if (o1 instanceof RefElement && o2 instanceof RefElement) {
                PsiFile containingFile2;
                RefElement r1 = (RefElement)o1;
                RefElement r2 = (RefElement)o2;
                PsiElement element1 = r1.getElement();
                PsiElement element2 = r2.getElement();
                PsiFile containingFile1 = element1.getContainingFile();
                if (containingFile1 == (containingFile2 = element2.getContainingFile())) {
                    int i2;
                    int i1 = element1.getTextOffset();
                    if (i1 < (i2 = element2.getTextOffset())) {
                        return 1;
                    }
                    if (i1 > i2) {
                        return -1;
                    }
                    return 0;
                }
                return containingFile1.getName().compareTo(containingFile2.getName());
            }
            if (o1 instanceof RefElement) {
                return 1;
            }
            if (o2 instanceof RefElement) {
                return -1;
            }
            return o1.getName().compareTo(o2.getName());
        });
        return selection.toArray(new RefEntity[selection.size()]);
    }

    private static void refreshViews(@NotNull Project project2, @NotNull Set<PsiElement> selectedElements, @NotNull InspectionToolWrapper toolWrapper) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/QuickFixAction", "refreshViews"));
        }
        if (selectedElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedElements", "com/intellij/codeInspection/ex/QuickFixAction", "refreshViews"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/QuickFixAction", "refreshViews"));
        }
        InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project2);
        Set<GlobalInspectionContextImpl> runningContexts = managerEx.getRunningContexts();
        for (GlobalInspectionContextImpl context : runningContexts) {
            for (PsiElement element : selectedElements) {
                context.ignoreElement(toolWrapper.getTool(), element);
            }
            context.refreshViews();
        }
    }

    private static void refreshViews(@NotNull Project project2, @NotNull RefEntity[] refElements, @NotNull InspectionToolWrapper toolWrapper) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/QuickFixAction", "refreshViews"));
        }
        if (refElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElements", "com/intellij/codeInspection/ex/QuickFixAction", "refreshViews"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/QuickFixAction", "refreshViews"));
        }
        HashSet<PsiElement> ignoredElements = new HashSet<PsiElement>();
        for (RefEntity element : refElements) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiElement = element instanceof RefElement ? ((RefElement)element).getElement() : null;
            if (psiElement == null || !psiElement.isValid()) continue;
            ignoredElements.add(psiElement);
        }
        QuickFixAction.refreshViews(project2, ignoredElements, toolWrapper);
    }

    protected boolean applyFix(@NotNull RefEntity[] refElements) {
        Project project2;
        ReadonlyStatusHandler.OperationStatus operationStatus;
        if (refElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElements", "com/intellij/codeInspection/ex/QuickFixAction", "applyFix"));
        }
        Set<VirtualFile> readOnlyFiles = QuickFixAction.getReadOnlyFiles(refElements);
        return readOnlyFiles.isEmpty() || !(operationStatus = ReadonlyStatusHandler.getInstance((Project)(project2 = refElements[0].getRefManager().getProject())).ensureFilesWritable(VfsUtilCore.toVirtualFileArray(readOnlyFiles))).hasReadonlyFiles();
    }

    public JComponent createCustomComponent(Presentation presentation) {
        final JButton button = new JButton(presentation.getText());
        Icon icon = presentation.getIcon();
        if (icon == null) {
            icon = AllIcons.Actions.CreateFromUsage;
        }
        button.setEnabled(presentation.isEnabled());
        button.setIcon(IconLoader.getTransparentIcon((Icon)icon, (float)0.75f));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/ex/QuickFixAction$1", "onClick"));
                }
                ActionToolbar toolbar = (ActionToolbar)UIUtil.getParentOfType(ActionToolbar.class, (Component)button);
                QuickFixAction.this.actionPerformed(AnActionEvent.createFromAnAction((AnAction)QuickFixAction.this, (InputEvent)event, (String)"unknown", (DataContext)(toolbar == null ? DataManager.getInstance().getDataContext((Component)button) : toolbar.getToolbarDataContext())));
                return true;
            }
        }.installOn((Component)button);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.setBorder(IdeBorderFactory.createEmptyBorder((int)7, (int)0, (int)8, (int)0));
        panel.add(button);
        return panel;
    }

    private static /* synthetic */ void lambda$actionPerformed$1(Ref descriptors, InspectionTree tree, Set readOnlyFiles) {
        ReadAction.run(() -> {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            indicator.setText("Checking problem descriptors...");
            descriptors.set((Object)tree.getSelectedDescriptors(true, readOnlyFiles, false));
        });
    }

    private class PerformFixesTask
    extends PerformFixesModalTask {
        @NotNull
        private final GlobalInspectionContextImpl myContext;
        @NotNull
        private final Set<PsiElement> myIgnoredElements;

        PerformFixesTask(@NotNull Project project2, @NotNull CommonProblemDescriptor[] descriptors, @NotNull Set<PsiElement> ignoredElements, @NotNull SequentialModalProgressTask task, GlobalInspectionContextImpl context) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/QuickFixAction$PerformFixesTask", "<init>"));
            }
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/ex/QuickFixAction$PerformFixesTask", "<init>"));
            }
            if (ignoredElements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredElements", "com/intellij/codeInspection/ex/QuickFixAction$PerformFixesTask", "<init>"));
            }
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/codeInspection/ex/QuickFixAction$PerformFixesTask", "<init>"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/QuickFixAction$PerformFixesTask", "<init>"));
            }
            super(project2, descriptors, task);
            this.myContext = context;
            this.myIgnoredElements = ignoredElements;
        }

        @Override
        protected void applyFix(Project project2, CommonProblemDescriptor descriptor) {
            if (descriptor instanceof ProblemDescriptor && ((ProblemDescriptor)descriptor).getStartElement() == null && ((ProblemDescriptor)descriptor).getEndElement() == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invalidated psi for " + descriptor);
                }
                return;
            }
            try {
                QuickFixAction.this.applyFix(this.myProject, this.myContext, new CommonProblemDescriptor[]{descriptor}, this.myIgnoredElements);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }
}

