/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.inferNullity;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.BaseAnalysisAction;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.impl.quickfix.JetBrainsAnnotationsExternalLibraryResolver;
import com.intellij.codeInspection.inferNullity.AnnotateTask;
import com.intellij.codeInspection.inferNullity.NullityInferrer;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.TitledSeparator;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoSearcherAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferNullityAnnotationsAction
extends BaseAnalysisAction {
    @NonNls
    private static final String INFER_NULLITY_ANNOTATIONS = "Infer Nullity Annotations";
    @NonNls
    private static final String ANNOTATE_LOCAL_VARIABLES = "annotate.local.variables";
    private JCheckBox myAnnotateLocalVariablesCb;

    public InferNullityAnnotationsAction() {
        super("Infer Nullity", INFER_NULLITY_ANNOTATIONS);
    }

    @Override
    protected void analyze(final @NotNull Project project2, @NotNull AnalysisScope scope) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "analyze"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "analyze"));
        }
        PropertiesComponent.getInstance().setValue(ANNOTATE_LOCAL_VARIABLES, this.myAnnotateLocalVariablesCb.isSelected());
        ProgressManager progressManager = ProgressManager.getInstance();
        final HashSet<Module> modulesWithoutAnnotations = new HashSet<Module>();
        final HashSet modulesWithLL = new HashSet();
        final JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project2);
        final String defaultNullable = NullableNotNullManager.getInstance((Project)project2).getDefaultNullable();
        final int[] fileCount = new int[]{0};
        if (!progressManager.runProcessWithProgressSynchronously(() -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "lambda$analyze$0"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "lambda$analyze$0"));
            }
            scope.accept(new PsiElementVisitor(){
                private final Set processed = new HashSet();

                public void visitFile(PsiFile file2) {
                    fileCount[0] = fileCount[0] + 1;
                    ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                    if (progressIndicator != null) {
                        VirtualFile virtualFile = file2.getVirtualFile();
                        if (virtualFile != null) {
                            progressIndicator.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)project2));
                        }
                        progressIndicator.setText(AnalysisScopeBundle.message((String)"scanning.scope.progress.title", (Object[])new Object[0]));
                    }
                    if (!(file2 instanceof PsiJavaFile)) {
                        return;
                    }
                    Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2);
                    if (module2 != null && this.processed.add(module2)) {
                        if (PsiUtil.getLanguageLevel((PsiElement)file2).compareTo((Enum)LanguageLevel.JDK_1_5) < 0) {
                            modulesWithLL.add(module2);
                        } else if (javaPsiFacade.findClass(defaultNullable, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2)) == null) {
                            modulesWithoutAnnotations.add(module2);
                        }
                    }
                }
            });
        }, "Check Applicability...", true, project2)) {
            return;
        }
        if (!modulesWithLL.isEmpty()) {
            Messages.showErrorDialog((Project)project2, (String)"Infer Nullity Annotations requires the project language level be set to 1.5 or greater.", (String)INFER_NULLITY_ANNOTATIONS);
            return;
        }
        if (!modulesWithoutAnnotations.isEmpty()) {
            if (InferNullityAnnotationsAction.addAnnotationsDependency(project2, modulesWithoutAnnotations, defaultNullable, INFER_NULLITY_ANNOTATIONS)) {
                this.restartAnalysis(project2, scope);
            }
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        UsageInfo[] usageInfos = this.findUsages(project2, scope, fileCount[0]);
        if (usageInfos == null) {
            return;
        }
        this.processUsages(project2, scope, usageInfos);
    }

    protected void processUsages(@NotNull Project project2, @NotNull AnalysisScope scope, @NotNull UsageInfo[] usageInfos) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "processUsages"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "processUsages"));
        }
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "processUsages"));
        }
        if (usageInfos.length < 5) {
            InferNullityAnnotationsAction.applyRunnable(project2, (Computable<UsageInfo[]>)((Computable)() -> {
                if (usageInfos == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "lambda$processUsages$1"));
                }
                return usageInfos;
            })).run();
        } else {
            this.showUsageView(project2, usageInfos, scope);
        }
    }

    public static boolean addAnnotationsDependency(@NotNull Project project2, @NotNull Set<Module> modulesWithoutAnnotations, @NotNull String annoFQN, String title) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "addAnnotationsDependency"));
        }
        if (modulesWithoutAnnotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesWithoutAnnotations", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "addAnnotationsDependency"));
        }
        if (annoFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annoFQN", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "addAnnotationsDependency"));
        }
        Library annotationsLib = LibraryUtil.findLibraryByClass((String)annoFQN, (Project)project2);
        if (annotationsLib != null) {
            String message = "Module" + (modulesWithoutAnnotations.size() == 1 ? " " : "s ");
            message = message + StringUtil.join(modulesWithoutAnnotations, Module::getName, (String)", ");
            message = message + (modulesWithoutAnnotations.size() == 1 ? " doesn't" : " don't");
            message = message + " refer to the existing '" + annotationsLib.getName() + "' library with IntelliJ IDEA nullity annotations. Would you like to add the dependenc";
            if (Messages.showOkCancelDialog((Project)project2, (String)(message = message + (modulesWithoutAnnotations.size() == 1 ? "y" : "ies") + " now?"), (String)title, (Icon)Messages.getErrorIcon()) == 0) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (modulesWithoutAnnotations == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesWithoutAnnotations", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "lambda$addAnnotationsDependency$2"));
                    }
                    for (Module module2 : modulesWithoutAnnotations) {
                        ModuleRootModificationUtil.addDependency((Module)module2, (Library)annotationsLib);
                    }
                });
                return true;
            }
            return false;
        }
        if (Messages.showOkCancelDialog((Project)project2, (String)"It is required that JetBrains annotations be available in all your project sources.\n\nYou will need to add annotations.jar as a library. It is possible to configure custom JAR\nin e.g. Constant Conditions & Exceptions inspection or use JetBrains annotations available in installation. \nIntelliJ IDEA nullity annotations are freely usable and redistributable under the Apache 2.0 license.\nWould you like to do it now?", (String)title, (Icon)Messages.getErrorIcon()) == 0) {
            Module firstModule = modulesWithoutAnnotations.iterator().next();
            JavaProjectModelModificationService.getInstance(project2).addDependency(modulesWithoutAnnotations, JetBrainsAnnotationsExternalLibraryResolver.getAnnotationsLibraryDescriptor(firstModule), DependencyScope.COMPILE);
            return true;
        }
        return false;
    }

    @Nullable
    protected UsageInfo[] findUsages(final @NotNull Project project2, @NotNull AnalysisScope scope, final int fileCount) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "findUsages"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "findUsages"));
        }
        final NullityInferrer inferrer = new NullityInferrer(this.isAnnotateLocalVariables(), project2);
        final PsiManager psiManager = PsiManager.getInstance((Project)project2);
        Runnable searchForUsages = () -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "lambda$findUsages$3"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "lambda$findUsages$3"));
            }
            scope.accept(new PsiElementVisitor(){
                int myFileCount;

                public void visitFile(PsiFile file2) {
                    Document document2;
                    ++this.myFileCount;
                    VirtualFile virtualFile = file2.getVirtualFile();
                    FileViewProvider viewProvider = psiManager.findViewProvider(virtualFile);
                    Document document3 = document2 = viewProvider == null ? null : viewProvider.getDocument();
                    if (document2 == null || virtualFile.getFileType().isBinary()) {
                        return;
                    }
                    ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                    if (progressIndicator != null) {
                        progressIndicator.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)project2));
                        progressIndicator.setFraction((double)this.myFileCount / (double)fileCount);
                    }
                    if (file2 instanceof PsiJavaFile) {
                        inferrer.collect(file2);
                    }
                }
            });
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(searchForUsages, INFER_NULLITY_ANNOTATIONS, true, project2)) {
                return null;
            }
        } else {
            searchForUsages.run();
        }
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        inferrer.collect(usages);
        return usages.toArray(new UsageInfo[usages.size()]);
    }

    protected boolean isAnnotateLocalVariables() {
        return this.myAnnotateLocalVariablesCb.isSelected();
    }

    private static Runnable applyRunnable(final Project project2, final Computable<UsageInfo[]> computable) {
        return () -> {
            LocalHistoryAction action = LocalHistory.getInstance().startAction(INFER_NULLITY_ANNOTATIONS);
            try {
                new WriteCommandAction(project2, INFER_NULLITY_ANNOTATIONS, new PsiFile[0]){

                    protected void run(@NotNull Result result2) throws Throwable {
                        if (result2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction$3", "run"));
                        }
                        UsageInfo[] infos = (UsageInfo[])computable.compute();
                        if (infos.length > 0) {
                            LinkedHashSet elements = new LinkedHashSet();
                            for (UsageInfo info : infos) {
                                PsiElement element = info.getElement();
                                if (element == null) continue;
                                ContainerUtil.addIfNotNull(elements, (Object)element.getContainingFile());
                            }
                            if (!FileModificationService.getInstance().preparePsiElementsForWrite(elements)) {
                                return;
                            }
                            SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project2, InferNullityAnnotationsAction.INFER_NULLITY_ANNOTATIONS, false);
                            progressTask.setMinIterationTime(200L);
                            progressTask.setTask(new AnnotateTask(project2, progressTask, infos));
                            ProgressManager.getInstance().run((Task)progressTask);
                        } else {
                            NullityInferrer.nothingFoundMessage(project2);
                        }
                    }
                }.execute();
            }
            finally {
                action.finish();
            }
        };
    }

    protected void restartAnalysis(Project project2, AnalysisScope scope) {
        TransactionGuard guard = TransactionGuard.getInstance();
        TransactionId id = guard.getContextTransaction();
        DumbService.getInstance((Project)project2).smartInvokeLater(() -> TransactionGuard.getInstance().submitTransaction((Disposable)project2, id, () -> {
            if (DumbService.isDumb((Project)project2)) {
                this.restartAnalysis(project2, scope);
            } else {
                this.analyze(project2, scope);
            }
        }));
    }

    private void showUsageView(@NotNull Project project2, UsageInfo[] usageInfos, @NotNull AnalysisScope scope) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "showUsageView"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "showUsageView"));
        }
        UsageTarget[] targets = UsageTarget.EMPTY_ARRAY;
        Ref convertUsagesRef = new Ref();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> convertUsagesRef.set((Object)UsageInfo2UsageAdapter.convert((UsageInfo[])usageInfos))), "Preprocess Usages", true, project2)) {
            return;
        }
        if (convertUsagesRef.isNull()) {
            return;
        }
        Usage[] usages = (Usage[])convertUsagesRef.get();
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setTabText("Infer Nullity Preview");
        presentation.setShowReadOnlyStatusAsRed(true);
        presentation.setShowCancelButton(true);
        presentation.setUsagesString(RefactoringBundle.message((String)"usageView.usagesText"));
        UsageView usageView = UsageViewManager.getInstance((Project)project2).showUsages(targets, usages, presentation, this.rerunFactory(project2, scope));
        Runnable refactoringRunnable = InferNullityAnnotationsAction.applyRunnable(project2, (Computable<UsageInfo[]>)((Computable)() -> {
            Set<UsageInfo> infos = UsageViewUtil.getNotExcludedUsageInfos(usageView);
            return infos.toArray(new UsageInfo[infos.size()]);
        }));
        String canNotMakeString = "Cannot perform operation.\nThere were changes in code after usages have been found.\nPlease perform operation search again.";
        usageView.addPerformOperationAction(refactoringRunnable, INFER_NULLITY_ANNOTATIONS, canNotMakeString, INFER_NULLITY_ANNOTATIONS, false);
    }

    @NotNull
    private Factory<UsageSearcher> rerunFactory(final @NotNull Project project2, final @NotNull AnalysisScope scope) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "rerunFactory"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "rerunFactory"));
        }
        Factory factory = () -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "lambda$rerunFactory$10"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "lambda$rerunFactory$10"));
            }
            return new UsageInfoSearcherAdapter(){

                protected UsageInfo[] findUsages() {
                    return InferNullityAnnotationsAction.this.findUsages(project2, scope, scope.getFileCount());
                }

                public void generate(@NotNull Processor<Usage> processor2) {
                    if (processor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction$4", "generate"));
                    }
                    this.processUsages(processor2, project2);
                }
            };
        };
        if (factory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "rerunFactory"));
        }
        return factory;
    }

    @Override
    protected JComponent getAdditionalActionSettings(Project project2, BaseAnalysisActionDialog dialog) {
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel.add((Component)new TitledSeparator());
        this.myAnnotateLocalVariablesCb = new JCheckBox("Annotate local variables", PropertiesComponent.getInstance().getBoolean(ANNOTATE_LOCAL_VARIABLES));
        panel.add(this.myAnnotateLocalVariablesCb);
        return panel;
    }

    @Override
    protected void canceled() {
        super.canceled();
        this.myAnnotateLocalVariablesCb = null;
    }
}

