/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.InspectionTreeTailRenderer;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

class InspectionTreeCellRenderer
extends ColoredTreeCellRenderer {
    private final InspectionResultsView myView;
    private final InspectionTreeTailRenderer myTailRenderer;

    public InspectionTreeCellRenderer(InspectionResultsView view) {
        this.myTailRenderer = new InspectionTreeTailRenderer(view.getGlobalInspectionContext()){

            @Override
            protected void appendText(String text, SimpleTextAttributes attributes) {
                InspectionTreeCellRenderer.this.append(text, attributes);
            }

            @Override
            protected void appendText(String text) {
                InspectionTreeCellRenderer.this.append(text);
            }
        };
        this.myView = view;
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/codeInspection/ui/InspectionTreeCellRenderer", "customizeCellRenderer"));
        }
        InspectionTreeNode node = (InspectionTreeNode)value;
        this.append(node.toString(), this.patchMainTextAttrs(node, node.appearsBold() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : InspectionTreeCellRenderer.getMainForegroundAttributes(node)));
        this.myTailRenderer.appendTailText(node);
        this.setIcon(node.getIcon(expanded));
        this.append(StringUtil.repeat((String)" ", (int)50));
    }

    private SimpleTextAttributes patchMainTextAttrs(InspectionTreeNode node, SimpleTextAttributes attributes) {
        if (node.isExcluded(this.myView.getExcludedManager())) {
            return attributes.derive(attributes.getStyle() | 4, null, null, null);
        }
        if (node instanceof ProblemDescriptionNode && ((ProblemDescriptionNode)node).isQuickFixAppliedFromView()) {
            return attributes.derive(-1, SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor(), null, null);
        }
        if (!node.isValid()) {
            return attributes.derive(-1, FileStatus.IGNORED.getColor(), null, null);
        }
        return attributes;
    }

    private static SimpleTextAttributes getMainForegroundAttributes(InspectionTreeNode node) {
        FileStatus nodeStatus;
        RefEntity refElement;
        SimpleTextAttributes foreground = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (node instanceof RefElementNode && (refElement = ((RefElementNode)node).getElement()) instanceof RefElement && ((RefElement)(refElement = ((RefElement)refElement).getContainingEntry())).isEntry() && ((RefElement)refElement).isPermanentEntry()) {
            foreground = new SimpleTextAttributes(0, (Color)JBColor.blue);
        }
        if ((nodeStatus = node.getNodeStatus()) != FileStatus.NOT_CHANGED) {
            foreground = new SimpleTextAttributes(foreground.getBgColor(), nodeStatus.getColor(), foreground.getWaveColor(), foreground.getStyle());
        }
        return foreground;
    }
}

