/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.actions;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.actions.CompileActionBase;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import java.util.ArrayList;

public class CompileAction
extends CompileActionBase {
    @Override
    protected void doAction(DataContext dataContext, Project project2) {
        Module module2 = (Module)dataContext.getData(LangDataKeys.MODULE_CONTEXT);
        if (module2 != null) {
            CompilerManager.getInstance((Project)project2).compile(module2, null);
        } else {
            VirtualFile[] files = CompileAction.getCompilableFiles(project2, (VirtualFile[])dataContext.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY));
            if (files.length > 0) {
                CompilerManager.getInstance((Project)project2).compile(files, null);
            }
        }
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (!presentation.isEnabled()) {
            return;
        }
        presentation.setText(ActionsBundle.actionText((String)"Compile"));
        presentation.setVisible(true);
        Project project2 = e.getProject();
        if (project2 == null) {
            presentation.setEnabled(false);
            return;
        }
        CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)project2);
        Module module2 = (Module)e.getData(LangDataKeys.MODULE_CONTEXT);
        VirtualFile[] files = CompileAction.getCompilableFiles(project2, (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY));
        if (module2 == null && files.length == 0) {
            presentation.setEnabled(false);
            presentation.setVisible(!ActionPlaces.isPopupPlace((String)e.getPlace()));
            return;
        }
        String elementDescription = null;
        if (module2 != null) {
            elementDescription = CompilerBundle.message((String)"action.compile.description.module", (Object[])new Object[]{module2.getName()});
        } else {
            PsiPackage aPackage = null;
            if (files.length == 1) {
                PsiDirectory directory = PsiManager.getInstance((Project)project2).findDirectory(files[0]);
                if (directory != null) {
                    aPackage = JavaDirectoryService.getInstance().getPackage(directory);
                }
            } else {
                PsiElement element = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
                if (element instanceof PsiPackage) {
                    aPackage = (PsiPackage)element;
                }
            }
            if (aPackage != null) {
                String name = aPackage.getQualifiedName();
                if (name.length() == 0) {
                    name = "<default>";
                }
                elementDescription = "'" + name + "'";
            } else if (files.length == 1) {
                VirtualFile file2 = files[0];
                FileType fileType = file2.getFileType();
                if (CompilerManager.getInstance((Project)project2).isCompilableFileType(fileType) || compilerConfiguration.isCompilableResourceFile(project2, file2)) {
                    elementDescription = "'" + file2.getName() + "'";
                } else if (!ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace())) {
                    presentation.setEnabled(false);
                    presentation.setVisible(false);
                    return;
                }
            } else {
                elementDescription = CompilerBundle.message((String)"action.compile.description.selected.files", (Object[])new Object[0]);
            }
        }
        if (elementDescription == null) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setText(CompileAction.createPresentationText(elementDescription), true);
        presentation.setEnabled(true);
    }

    private static String createPresentationText(String elementDescription) {
        StringBuilder buffer = new StringBuilder(40);
        buffer.append(ActionsBundle.actionText((String)"Compile")).append(" ");
        int length = elementDescription.length();
        if (length > 23) {
            if (StringUtil.startsWithChar((CharSequence)elementDescription, (char)'\'')) {
                buffer.append("'");
            }
            buffer.append("...");
            buffer.append(elementDescription.substring(length - 20, length));
        } else {
            buffer.append(elementDescription);
        }
        return buffer.toString();
    }

    private static VirtualFile[] getCompilableFiles(Project project2, VirtualFile[] files) {
        if (files == null || files.length == 0) {
            return VirtualFile.EMPTY_ARRAY;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)project2);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project2);
        ArrayList<VirtualFile> filesToCompile = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : files) {
            FileType fileType;
            PsiDirectory directory;
            if (!fileIndex.isInSourceContent(file2) || !file2.isInLocalFileSystem() || (file2.isDirectory() ? (directory = psiManager.findDirectory(file2)) == null || JavaDirectoryService.getInstance().getPackage(directory) == null : !compilerManager.isCompilableFileType(fileType = file2.getFileType()) && !compilerConfiguration.isCompilableResourceFile(project2, file2))) continue;
            filesToCompile.add(file2);
        }
        return VfsUtilCore.toVirtualFileArray(filesToCompile);
    }
}

