/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.actions;

import com.intellij.compiler.actions.CompileActionBase;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.project.Project;

public class CompileProjectAction
extends CompileActionBase {
    @Override
    protected void doAction(DataContext dataContext, final Project project2) {
        CompilerManager.getInstance((Project)project2).rebuild(new CompileStatusNotification(){

            public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                if (aborted || project2.isDisposed()) {
                    return;
                }
                String text = CompileProjectAction.this.getTemplatePresentation().getText();
                LocalHistory.getInstance().putSystemLabel(project2, errors == 0 ? CompilerBundle.message((String)"rebuild.lvcs.label.no.errors", (Object[])new Object[]{text}) : CompilerBundle.message((String)"rebuild.lvcs.label.with.errors", (Object[])new Object[]{text}));
            }
        });
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (!presentation.isEnabled()) {
            return;
        }
        presentation.setEnabled(e.getProject() != null);
    }
}

