/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.taskdefs.Exclude;
import com.intellij.compiler.ant.taskdefs.PatternSet;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

public class CompilerExcludes
extends Generator {
    private final PatternSet myPatternSet;

    public CompilerExcludes(Project project2, GenerationOptions genOptions) {
        CompilerConfigurationImpl compilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project2);
        ExcludeEntryDescription[] excludeEntryDescriptions = compilerConfiguration.getExcludedEntriesConfiguration().getExcludeEntryDescriptions();
        this.myPatternSet = new PatternSet("compiler.excluded");
        for (ExcludeEntryDescription entry : excludeEntryDescriptions) {
            String path = GenerationUtils.toRelativePath((VirtualFile)entry.getVirtualFile(), (File)BuildProperties.getProjectBaseDir((Project)project2), (String)BuildProperties.getProjectBaseDirProperty(), (GenerationOptions)genOptions);
            if (path == null) continue;
            if (entry.isFile()) {
                this.myPatternSet.add((Generator)new Exclude(path));
                continue;
            }
            if (entry.isIncludeSubdirectories()) {
                this.myPatternSet.add((Generator)new Exclude(path + "/**"));
                continue;
            }
            this.myPatternSet.add((Generator)new Exclude(path + "/*"));
        }
    }

    public void generate(PrintWriter out) throws IOException {
        this.myPatternSet.generate(out);
    }

    public static boolean isAvailable(Project project2) {
        CompilerConfigurationImpl compilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project2);
        ExcludeEntryDescription[] excludeEntryDescriptions = compilerConfiguration.getExcludedEntriesConfiguration().getExcludeEntryDescriptions();
        return excludeEntryDescriptions.length > 0;
    }
}

