/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch.context;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.Nullable;

public class TargetType {
    private final String myClassQName;
    private final boolean myArray;
    private final PsiType myPsiType;

    public TargetType(String classQName, boolean isArray, PsiType targetType) {
        this.myClassQName = classQName;
        this.myArray = isArray;
        this.myPsiType = targetType;
    }

    public String getClassQName() {
        return this.myClassQName;
    }

    public boolean isArray() {
        return this.myArray;
    }

    public PsiType getPsiType() {
        return this.myPsiType;
    }

    @Nullable
    public static TargetType create(PsiArrayType arrayType) {
        PsiType currentComponentType = arrayType.getComponentType();
        while (currentComponentType instanceof PsiArrayType) {
            currentComponentType = ((PsiArrayType)currentComponentType).getComponentType();
        }
        if (!(currentComponentType instanceof PsiClassType)) {
            return null;
        }
        String targetQName = arrayType.getCanonicalText();
        return new TargetType(targetQName, true, (PsiType)arrayType);
    }

    @Nullable
    public static TargetType create(PsiClassType classType) {
        PsiClassType.ClassResolveResult resolvedGenerics = classType.resolveGenerics();
        PsiClass resolvedClass = resolvedGenerics.getElement();
        if (resolvedClass == null) {
            return null;
        }
        String classQName = resolvedClass.getQualifiedName();
        if (classQName == null) {
            return null;
        }
        if (resolvedClass.hasTypeParameters()) {
            return null;
        }
        return new TargetType(classQName, false, (PsiType)classType);
    }
}

