/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.CompilerMessageImpl;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessagesContainer {
    private final Project myProject;
    private final Map<CompilerMessageCategory, Collection<CompilerMessage>> myMessages = new EnumMap<CompilerMessageCategory, Collection<CompilerMessage>>(CompilerMessageCategory.class);

    public MessagesContainer(Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public Collection<CompilerMessage> getMessages(CompilerMessageCategory category) {
        Collection<CompilerMessage> collection = this.myMessages.get(category);
        if (collection == null) {
            List<CompilerMessage> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/MessagesContainer", "getMessages"));
            }
            return list;
        }
        Collection<CompilerMessage> collection2 = Collections.unmodifiableCollection(collection);
        if (collection2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/MessagesContainer", "getMessages"));
        }
        return collection2;
    }

    @Nullable
    public CompilerMessage addMessage(CompilerMessageCategory category, String message, String url, int lineNum, int columnNum, Navigatable navigatable) {
        CompilerMessageImpl msg = new CompilerMessageImpl(this.myProject, category, message, MessagesContainer.findFileByUrl(url), lineNum, columnNum, navigatable);
        if (this.addMessage(msg)) {
            return msg;
        }
        return null;
    }

    public boolean addMessage(CompilerMessage msg) {
        Collection<CompilerMessage> messages = this.myMessages.get(msg.getCategory());
        if (messages == null) {
            messages = new LinkedHashSet<CompilerMessage>();
            this.myMessages.put(msg.getCategory(), messages);
        }
        return messages.add(msg);
    }

    @Nullable
    private static VirtualFile findFileByUrl(@Nullable String url) {
        if (url == null) {
            return null;
        }
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file2 == null) {
            return VirtualFileManager.getInstance().refreshAndFindFileByUrl(url);
        }
        return file2;
    }

    public int getMessageCount(CompilerMessageCategory category) {
        if (category != null) {
            Collection<CompilerMessage> collection = this.myMessages.get(category);
            return collection != null ? collection.size() : 0;
        }
        int count = 0;
        for (Collection<CompilerMessage> collection : this.myMessages.values()) {
            if (collection == null) continue;
            count += collection.size();
        }
        return count;
    }
}

