/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.configurationStore.SaveSessionBase;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateMapKt;
import com.intellij.configurationStore.StorageBaseEx;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.StreamProviderKt;
import com.intellij.configurationStore.XmlElementStorageKt;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.FileStorageCoreUtil;
import com.intellij.openapi.components.impl.stores.StateStorageBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00016B;\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u0016J\"\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001cH\u0014J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001cH\u0014J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0002H$J\u0012\u0010#\u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u001cH\u0014J*\u0010$\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0019\u001a\u00020\u00022\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(J\u0018\u0010)\u001a\u00020(2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0004H\u0014J\b\u0010*\u001a\u00020\u0002H\u0014J\n\u0010+\u001a\u0004\u0018\u00010\u001cH\u0002J\n\u0010,\u001a\u0004\u0018\u00010\u001cH$J\u0010\u0010-\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J\u000e\u0010.\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001cJ\u001a\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u00020\u00022\b\u00101\u001a\u0004\u0018\u00010\u0002H\u0002J\n\u00102\u001a\u0004\u0018\u00010!H\u0016J\u001c\u00103\u001a\u00020\u00152\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u00105\u001a\u00020(R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0005\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000e\u00a8\u00067"}, d2={"Lcom/intellij/configurationStore/XmlElementStorage;", "Lcom/intellij/configurationStore/StorageBaseEx;", "Lcom/intellij/configurationStore/StateMap;", "fileSpec", "", "rootElementName", "pathMacroSubstitutor", "Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;Lcom/intellij/openapi/components/RoamingType;Lcom/intellij/configurationStore/StreamProvider;)V", "getFileSpec", "()Ljava/lang/String;", "getPathMacroSubstitutor", "()Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;", "getRoamingType", "()Lcom/intellij/openapi/components/RoamingType;", "getRootElementName", "analyzeExternalChangesAndUpdateIfNeed", "", "componentNames", "", "archiveState", "storageData", "componentName", "serializedState", "Lorg/jdom/Element;", "beforeElementLoaded", "element", "beforeElementSaved", "createSaveSession", "Lcom/intellij/openapi/components/StateStorage$ExternalizationSession;", "states", "dataLoadedFromProvider", "getSerializedState", "component", "", "archive", "", "hasState", "loadData", "loadDataFromProvider", "loadLocalData", "loadState", "setDefaultState", "setStates", "oldStorageData", "newStorageData", "startExternalization", "updatedFromStreamProvider", "changedComponentNames", "deleted", "XmlElementStorageSaveSession", "configuration-store-impl"})
public abstract class XmlElementStorage
extends StorageBaseEx<StateMap> {
    @NotNull
    private final RoamingType roamingType;
    private final StreamProvider provider;
    @NotNull
    private final String fileSpec;
    @NotNull
    private final String rootElementName;
    @Nullable
    private final TrackingPathMacroSubstitutor pathMacroSubstitutor;

    @NotNull
    public final RoamingType getRoamingType() {
        return this.roamingType;
    }

    @Nullable
    protected abstract Element loadLocalData();

    @Override
    @Nullable
    public final Element getSerializedState(@NotNull StateMap storageData, @Nullable Object component, @NotNull String componentName, boolean archive) {
        Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        return storageData.getState(componentName, archive);
    }

    @Override
    public void archiveState(@NotNull StateMap storageData, @NotNull String componentName, @Nullable Element serializedState) {
        Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        storageData.archive(componentName, serializedState);
    }

    @Override
    protected boolean hasState(@NotNull StateMap storageData, @NotNull String componentName) {
        Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        return storageData.hasState(componentName);
    }

    @Override
    @NotNull
    protected StateMap loadData() {
        Element element;
        if (this.provider != null && this.provider.getEnabled()) {
            Element element2;
            try {
                element2 = this.loadDataFromProvider();
                Element $receiver = element2;
                this.dataLoadedFromProvider($receiver);
            }
            catch (Exception e) {
                ComponentStoreImplKt.getLOG().error((Throwable)e);
                element2 = null;
            }
            element = element2;
        } else {
            element = this.loadLocalData();
        }
        return element == null ? StateMap.Companion.getEMPTY() : this.loadState(element);
    }

    protected void dataLoadedFromProvider(@Nullable Element element) {
    }

    private final Element loadDataFromProvider() {
        Element element;
        StreamProvider streamProvider = this.provider;
        if (streamProvider == null) {
            Intrinsics.throwNpe();
        }
        InputStream inputStream = streamProvider.read(this.fileSpec, this.roamingType);
        if (inputStream != null) {
            InputStream inputStream2 = inputStream;
            InputStream it = inputStream2;
            element = JdomKt.loadElement(it);
        } else {
            element = null;
        }
        return element;
    }

    private final StateMap loadState(Element element) {
        this.beforeElementLoaded(element);
        Map map = FileStorageCoreUtil.load(element, this.pathMacroSubstitutor, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"FileStorageCoreUtil.load\u2026thMacroSubstitutor, true)");
        return StateMap.Companion.fromMap(map);
    }

    public final void setDefaultState(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        element.setName(this.rootElementName);
        this.getStorageDataRef().set(this.loadState(element));
    }

    @Nullable
    public StateStorage.ExternalizationSession startExternalization() {
        return this.checkIsSavingDisabled() ? (StateStorage.ExternalizationSession)null : this.createSaveSession((StateMap)StateStorageBase.getStorageData$default(this, false, 1, null));
    }

    @NotNull
    protected abstract StateStorage.ExternalizationSession createSaveSession(@NotNull StateMap var1);

    /*
     * WARNING - void declaration
     */
    public void analyzeExternalChangesAndUpdateIfNeed(@NotNull Set<String> componentNames) {
        Intrinsics.checkParameterIsNotNull(componentNames, (String)"componentNames");
        StateMap oldData = (StateMap)this.getStorageDataRef().get();
        StateMap newData = (StateMap)this.getStorageData(true);
        if (oldData == null) {
            void $receiver$iv;
            Logger logger = ComponentStoreImplKt.getLOG();
            if ($receiver$iv.isDebugEnabled()) {
                void var8_6 = $receiver$iv;
                String string = "analyzeExternalChangesAndUpdateIfNeed: old data null, load new for " + this.toString();
                var8_6.debug(string);
            }
            CollectionsKt.addAll((Collection)componentNames, (Object[])newData.keys());
        } else {
            void $receiver$iv;
            Set changedComponentNames = XmlElementStorageKt.access$getChangedComponentNames(oldData, newData);
            Logger $i$a$1$debug = ComponentStoreImplKt.getLOG();
            if ($receiver$iv.isDebugEnabled()) {
                void var8_7 = $receiver$iv;
                String string = "analyzeExternalChangesAndUpdateIfNeed: changedComponentNames " + changedComponentNames + " for " + this.toString();
                var8_7.debug(string);
            }
            if (!ContainerUtil.isEmpty((Collection)changedComponentNames)) {
                componentNames.addAll(changedComponentNames);
            }
        }
    }

    private final void setStates(StateMap oldStorageData, StateMap newStorageData) {
        if (oldStorageData != newStorageData && this.getStorageDataRef().getAndSet(newStorageData) != oldStorageData) {
            ComponentStoreImplKt.getLOG().warn("Old storage data is not equal to current, new storage data was set anyway");
        }
    }

    protected void beforeElementLoaded(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beforeElementSaved(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (this.pathMacroSubstitutor != null) {
            try {
                this.pathMacroSubstitutor.collapsePaths(element);
            }
            finally {
                this.pathMacroSubstitutor.reset();
            }
        }
    }

    public final void updatedFromStreamProvider(@NotNull Set<String> changedComponentNames, boolean deleted) {
        Intrinsics.checkParameterIsNotNull(changedComponentNames, (String)"changedComponentNames");
        if (Intrinsics.areEqual((Object)this.roamingType, (Object)RoamingType.DISABLED)) {
            return;
        }
        try {
            Element newElement = deleted ? (Element)null : this.loadDataFromProvider();
            StateMap states = (StateMap)this.getStorageDataRef().get();
            if (newElement == null) {
                if (states != null) {
                    CollectionsKt.addAll((Collection)changedComponentNames, (Object[])states.keys());
                    this.setStates(states, null);
                }
            } else if (states != null) {
                StateMap newStates = this.loadState(newElement);
                changedComponentNames.addAll(XmlElementStorageKt.access$getChangedComponentNames(states, newStates));
                this.setStates(states, newStates);
            }
        }
        catch (Throwable e) {
            ComponentStoreImplKt.getLOG().error(e);
        }
    }

    @NotNull
    protected final String getFileSpec() {
        return this.fileSpec;
    }

    @NotNull
    protected final String getRootElementName() {
        return this.rootElementName;
    }

    @Nullable
    protected final TrackingPathMacroSubstitutor getPathMacroSubstitutor() {
        return this.pathMacroSubstitutor;
    }

    protected XmlElementStorage(@NotNull String fileSpec, @NotNull String rootElementName, @Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor, @Nullable RoamingType roamingType, @Nullable StreamProvider provider) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)rootElementName, (String)"rootElementName");
        this.fileSpec = fileSpec;
        this.rootElementName = rootElementName;
        this.pathMacroSubstitutor = pathMacroSubstitutor;
        RoamingType roamingType2 = roamingType;
        if (roamingType2 == null) {
            roamingType2 = RoamingType.DEFAULT;
        }
        this.roamingType = roamingType2;
        this.provider = provider == null || Intrinsics.areEqual((Object)roamingType, (Object)RoamingType.DISABLED) || !provider.isApplicable(this.fileSpec, this.roamingType) ? (StreamProvider)null : provider;
    }

    protected /* synthetic */ XmlElementStorage(String string, String string2, TrackingPathMacroSubstitutor trackingPathMacroSubstitutor, RoamingType roamingType, StreamProvider streamProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            trackingPathMacroSubstitutor = null;
        }
        if ((n & 8) != 0) {
            roamingType = RoamingType.DEFAULT;
        }
        if ((n & 0x10) != 0) {
            streamProvider = null;
        }
        this(string, string2, trackingPathMacroSubstitutor, roamingType, streamProvider);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u000eH$J\u001a\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000eH\u0014R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lcom/intellij/configurationStore/XmlElementStorage$XmlElementStorageSaveSession;", "T", "Lcom/intellij/configurationStore/XmlElementStorage;", "Lcom/intellij/configurationStore/SaveSessionBase;", "originalStates", "Lcom/intellij/configurationStore/StateMap;", "storage", "(Lcom/intellij/configurationStore/StateMap;Lcom/intellij/configurationStore/XmlElementStorage;)V", "copiedStates", "", "", "", "newLiveStates", "Lgnu/trove/THashMap;", "Lorg/jdom/Element;", "getStorage", "()Lcom/intellij/configurationStore/XmlElementStorage;", "Lcom/intellij/configurationStore/XmlElementStorage;", "createSaveSession", "save", "", "saveLocally", "element", "setSerializedState", "componentName", "configuration-store-impl"})
    public static abstract class XmlElementStorageSaveSession<T extends XmlElementStorage>
    extends SaveSessionBase {
        private Map<String, Object> copiedStates;
        private final THashMap<String, Element> newLiveStates;
        private final StateMap originalStates;
        @NotNull
        private final T storage;

        @Nullable
        public XmlElementStorageSaveSession<T> createSaveSession() {
            return ((XmlElementStorage)this.storage).checkIsSavingDisabled() || this.copiedStates == null ? (XmlElementStorageSaveSession)null : this;
        }

        @Override
        protected void setSerializedState(@NotNull String componentName, @Nullable Element element) {
            Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
            Element element2 = element;
            if (element2 != null) {
                XmlElementStorageKt.normalizeRootName(element2);
            }
            if (this.copiedStates == null) {
                this.copiedStates = StateMapKt.setStateAndCloneIfNeed(componentName, element, this.originalStates, (Map)this.newLiveStates);
            } else {
                Map<String, Object> map = this.copiedStates;
                if (map == null) {
                    Intrinsics.throwNpe();
                }
                StateMapKt.updateState(map, componentName, element, (Map)this.newLiveStates);
            }
        }

        public void save() {
            StateMap stateMap;
            Element element;
            Map<String, Object> map = this.copiedStates;
            if (map == null) {
                Intrinsics.throwNpe();
            }
            if ((element = XmlElementStorageKt.save(stateMap = StateMap.Companion.fromMap(map), ((XmlElementStorage)this.storage).getRootElementName(), (Map)this.newLiveStates)) == null || JDOMUtil.isEmpty((Element)element)) {
                element = null;
            } else {
                ((XmlElementStorage)this.storage).beforeElementSaved(element);
            }
            StreamProvider provider = ((XmlElementStorage)this.storage).provider;
            if (provider != null && provider.getEnabled()) {
                if (element == null) {
                    provider.delete(((XmlElementStorage)this.storage).getFileSpec(), ((XmlElementStorage)this.storage).getRoamingType());
                } else {
                    StreamProviderKt.write(provider, ((XmlElementStorage)this.storage).getFileSpec(), FileBasedStorageKt.toBufferExposingByteArray$default((Parent)element, null, 1, null), ((XmlElementStorage)this.storage).getRoamingType());
                }
            } else {
                this.saveLocally(element);
            }
            ((XmlElementStorage)this.storage).setStates(this.originalStates, stateMap);
        }

        protected abstract void saveLocally(@Nullable Element var1);

        @NotNull
        protected final T getStorage() {
            return this.storage;
        }

        public XmlElementStorageSaveSession(@NotNull StateMap originalStates, @NotNull T storage2) {
            Intrinsics.checkParameterIsNotNull((Object)originalStates, (String)"originalStates");
            Intrinsics.checkParameterIsNotNull(storage2, (String)"storage");
            this.originalStates = originalStates;
            this.storage = storage2;
            this.newLiveStates = new THashMap();
        }
    }
}

