/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.ThreadDumpAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.ide.actions.ExportToTextFileAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.unscramble.ThreadDumpPanel;
import com.intellij.unscramble.ThreadState;
import java.util.List;

public class ExportThreadsAction
extends AnAction
implements AnAction.TransparentUpdate {
    public void actionPerformed(AnActionEvent e) {
        DebugProcessImpl process2;
        final Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(project2).getContext();
        DebuggerSession session2 = context.getDebuggerSession();
        if (session2 != null && session2.isAttached() && (process2 = context.getDebugProcess()) != null) {
            process2.getManagerThread().invoke(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    List<ThreadState> threads = ThreadDumpAction.buildThreadStates(process2.getVirtualMachineProxy());
                    ApplicationManager.getApplication().invokeLater(() -> ExportToTextFileAction.export(project2, ThreadDumpPanel.createToFileExporter(project2, threads)), ModalityState.NON_MODAL);
                }
            });
        }
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project2 = e.getProject();
        if (project2 == null) {
            presentation.setEnabled(false);
            return;
        }
        DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(project2).getContext().getDebuggerSession();
        presentation.setEnabled(debuggerSession != null && debuggerSession.isPaused());
    }
}

