/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.Range;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodSmartStepTarget
extends SmartStepTarget {
    private final PsiMethod myMethod;

    public MethodSmartStepTarget(@NotNull PsiMethod method, @Nullable String label, @Nullable PsiElement highlightElement, boolean needBreakpointRequest, Range<Integer> lines) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/debugger/actions/MethodSmartStepTarget", "<init>"));
        }
        super(label, highlightElement, needBreakpointRequest, lines);
        this.myMethod = method;
    }

    @NotNull
    public PsiMethod getMethod() {
        PsiMethod psiMethod = this.myMethod;
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/MethodSmartStepTarget", "getMethod"));
        }
        return psiMethod;
    }

    @Override
    public Icon getIcon() {
        return this.myMethod.getIcon(0);
    }

    @Override
    @NotNull
    public String getPresentation() {
        String label = this.getLabel();
        String formatted = PsiFormatUtil.formatMethod((PsiMethod)this.myMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2, (int)999);
        String string = label != null ? label + formatted : formatted;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/MethodSmartStepTarget", "getPresentation"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodSmartStepTarget that = (MethodSmartStepTarget)o;
        return this.myMethod.equals(that.myMethod);
    }

    public int hashCode() {
        return this.myMethod.hashCode();
    }
}

