/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorProvider;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.sun.jdi.Field;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaStaticGroup
extends XValueGroup
implements NodeDescriptorProvider {
    private final StaticDescriptorImpl myStaticDescriptor;
    private final EvaluationContextImpl myEvaluationContext;
    private final NodeManagerImpl myNodeManager;

    public JavaStaticGroup(StaticDescriptorImpl staticDescriptor, EvaluationContextImpl evaluationContext, NodeManagerImpl nodeManager) {
        super(staticDescriptor.getName());
        this.myStaticDescriptor = staticDescriptor;
        this.myEvaluationContext = evaluationContext;
        this.myNodeManager = nodeManager;
    }

    @Nullable
    public String getComment() {
        String res = NodeRendererSettings.getInstance().getClassRenderer().renderTypeName(this.myStaticDescriptor.getType().name());
        if (!StringUtil.isEmpty((String)res)) {
            return " members of " + res;
        }
        return res;
    }

    @NotNull
    public String getSeparator() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/JavaStaticGroup", "getSeparator"));
        }
        return "";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Nodes.Static;
    }

    @Override
    public NodeDescriptorImpl getDescriptor() {
        return this.myStaticDescriptor;
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/debugger/engine/JavaStaticGroup", "computeChildren"));
        }
        JavaValue.scheduleCommand(this.myEvaluationContext, node, new SuspendContextCommandImpl(this.myEvaluationContext.getSuspendContext()){

            @Override
            public void contextAction() throws Exception {
                XValueChildrenList children2 = new XValueChildrenList();
                ReferenceType refType = JavaStaticGroup.this.myStaticDescriptor.getType();
                List<Field> fields = refType.allFields();
                ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
                for (Field field : fields) {
                    if (!field.isStatic()) continue;
                    boolean isSynthetic = DebuggerUtils.isSynthetic((TypeComponent)field);
                    if (!classRenderer.SHOW_SYNTHETICS && isSynthetic) continue;
                    FieldDescriptorImpl fieldDescriptor = JavaStaticGroup.this.myNodeManager.getFieldDescriptor(JavaStaticGroup.this.myStaticDescriptor, null, field);
                    children2.add((XNamedValue)JavaValue.create(fieldDescriptor, JavaStaticGroup.this.myEvaluationContext, JavaStaticGroup.this.myNodeManager));
                }
                node.addChildren(children2, true);
            }
        });
    }
}

