/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.FieldEvaluator;
import com.intellij.debugger.engine.evaluation.expression.LocalVariableEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.evaluation.expression.ThisEvaluator;

public class ReferenceEvaluator
extends LocalVariableEvaluator {
    private final FieldEvaluator myFieldEvaluator;
    private boolean myIsField;

    public ReferenceEvaluator(String localVariableName) {
        super(localVariableName, false);
        this.myFieldEvaluator = new FieldEvaluator(new ThisEvaluator(), FieldEvaluator.TargetClassFilter.ALL, localVariableName);
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        try {
            return super.evaluate(context);
        }
        catch (EvaluateException e) {
            try {
                Object fieldValue = this.myFieldEvaluator.evaluate(context);
                this.myIsField = true;
                return fieldValue;
            }
            catch (EvaluateException e1) {
                throw e;
            }
        }
    }

    @Override
    public Modifier getModifier() {
        return this.myIsField ? this.myFieldEvaluator.getModifier() : super.getModifier();
    }
}

