/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestorImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerHistoryManager;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VoidValue;
import com.sun.jdi.event.LocatableEvent;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

public abstract class Breakpoint<P extends JavaBreakpointProperties>
implements FilteredRequestor,
ClassPrepareRequestor {
    public static final Key<Breakpoint> DATA_KEY = Key.create((String)"JavaBreakpoint");
    final XBreakpoint<P> myXBreakpoint;
    protected final Project myProject;
    @NonNls
    private static final String LOG_MESSAGE_OPTION_NAME = "LOG_MESSAGE";
    public static final Breakpoint[] EMPTY_ARRAY = new Breakpoint[0];
    protected boolean myCachedVerifiedState;

    protected Breakpoint(@NotNull Project project2, XBreakpoint<P> xBreakpoint) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/Breakpoint", "<init>"));
        }
        this.myCachedVerifiedState = false;
        this.myProject = project2;
        this.myXBreakpoint = xBreakpoint;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/Breakpoint", "getProject"));
        }
        return project2;
    }

    @NotNull
    protected P getProperties() {
        JavaBreakpointProperties javaBreakpointProperties = (JavaBreakpointProperties)this.myXBreakpoint.getProperties();
        if (javaBreakpointProperties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/Breakpoint", "getProperties"));
        }
        return (P)((Object)javaBreakpointProperties);
    }

    public XBreakpoint<P> getXBreakpoint() {
        return this.myXBreakpoint;
    }

    @Nullable
    public abstract PsiClass getPsiClass();

    public abstract void createRequest(DebugProcessImpl var1);

    protected boolean shouldCreateRequest(final DebugProcessImpl debugProcess) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                JavaDebugProcess process2 = debugProcess.getXdebugProcess();
                return process2 != null && debugProcess.isAttached() && ((XDebugSessionImpl)process2.getSession()).isBreakpointActive(Breakpoint.this.myXBreakpoint) && debugProcess.getRequestsManager().findRequests(Breakpoint.this).isEmpty();
            }
        });
    }

    public abstract void processClassPrepare(DebugProcess var1, ReferenceType var2);

    public abstract String getDisplayName();

    public String getShortName() {
        return this.getDisplayName();
    }

    @Nullable
    public String getClassName() {
        return null;
    }

    public void markVerified(boolean isVerified) {
        this.myCachedVerifiedState = isVerified;
    }

    public boolean isRemoveAfterHit() {
        return this.myXBreakpoint instanceof XLineBreakpoint && ((XLineBreakpoint)this.myXBreakpoint).isTemporary();
    }

    public void setRemoveAfterHit(boolean value) {
        if (this.myXBreakpoint instanceof XLineBreakpoint) {
            ((XLineBreakpoint)this.myXBreakpoint).setTemporary(value);
        }
    }

    @Nullable
    public String getShortClassName() {
        String className = this.getClassName();
        if (className == null) {
            return null;
        }
        int dotIndex = className.lastIndexOf(46);
        return dotIndex >= 0 && dotIndex + 1 < className.length() ? className.substring(dotIndex + 1) : className;
    }

    @Nullable
    public String getPackageName() {
        return null;
    }

    public abstract Icon getIcon();

    public abstract void reload();

    public abstract String getEventMessage(LocatableEvent var1);

    public abstract boolean isValid();

    public abstract Key<? extends Breakpoint> getCategory();

    protected void createOrWaitPrepare(DebugProcessImpl debugProcess, String classToBeLoaded) {
        debugProcess.getRequestsManager().callbackOnPrepareClasses((ClassPrepareRequestor)this, classToBeLoaded);
        List<ReferenceType> list = debugProcess.getVirtualMachineProxy().classesByName(classToBeLoaded);
        for (ReferenceType aList : list) {
            ReferenceType refType = aList;
            if (!refType.isPrepared()) continue;
            this.processClassPrepare(debugProcess, refType);
        }
    }

    protected void createOrWaitPrepare(DebugProcessImpl debugProcess, @NotNull SourcePosition classPosition) {
        if (classPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classPosition", "com/intellij/debugger/ui/breakpoints/Breakpoint", "createOrWaitPrepare"));
        }
        debugProcess.getRequestsManager().callbackOnPrepareClasses((ClassPrepareRequestor)this, classPosition);
        debugProcess.getPositionManager().getAllClasses(classPosition).stream().filter(ReferenceType::isPrepared).forEach(refType -> this.processClassPrepare(debugProcess, (ReferenceType)refType));
    }

    protected ObjectReference getThisObject(SuspendContextImpl context, LocatableEvent event) throws EvaluateException {
        StackFrameProxyImpl stackFrameProxy;
        ThreadReferenceProxyImpl thread = context.getThread();
        if (thread != null && (stackFrameProxy = thread.frame(0)) != null) {
            return stackFrameProxy.thisObject();
        }
        return null;
    }

    @Override
    public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) throws LocatableEventRequestor.EventProcessingException {
        SuspendContextImpl context = action.getSuspendContext();
        if (!this.isValid()) {
            context.getDebugProcess().getRequestsManager().deleteRequest(this);
            return false;
        }
        String[] title = new String[]{DebuggerBundle.message((String)"title.error.evaluating.breakpoint.condition", (Object[])new Object[0])};
        try {
            StackFrameProxyImpl frameProxy = context.getThread().frame(0);
            if (frameProxy == null) {
                return false;
            }
            EvaluationContextImpl evaluationContext = new EvaluationContextImpl(action.getSuspendContext(), frameProxy, this.getThisObject(context, event));
            if (!this.evaluateCondition(evaluationContext, event)) {
                return false;
            }
            title[0] = DebuggerBundle.message((String)"title.error.evaluating.breakpoint.action", (Object[])new Object[0]);
            this.runAction(evaluationContext, event);
        }
        catch (EvaluateException ex) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                System.out.println(ex.getMessage());
                return false;
            }
            throw new LocatableEventRequestor.EventProcessingException(title[0], ex.getMessage(), ex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAction(final EvaluationContextImpl context, LocatableEvent event) {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        if (this.isLogEnabled() || this.isLogExpressionEnabled()) {
            StringBuilder buf = StringBuilderSpinAllocator.alloc();
            try {
                if (this.myXBreakpoint.isLogMessage()) {
                    buf.append(this.getEventMessage(event));
                    buf.append("\n");
                }
                if (this.isLogExpressionEnabled()) {
                    if (!debugProcess.isAttached()) {
                        return;
                    }
                    final TextWithImports expressionToEvaluate = this.getLogMessage();
                    try {
                        ExpressionEvaluator evaluator = DebuggerInvocationUtil.commitAndRunReadAction(this.myProject, new EvaluatingComputable<ExpressionEvaluator>(){

                            @Override
                            public ExpressionEvaluator compute() throws EvaluateException {
                                return EvaluatorBuilderImpl.build(expressionToEvaluate, ContextUtil.getContextElement((StackFrameContext)context), ContextUtil.getSourcePosition((StackFrameContext)context), Breakpoint.this.myProject);
                            }
                        });
                        Value eval = evaluator.evaluate((EvaluationContext)context);
                        String result2 = eval instanceof VoidValue ? "void" : DebuggerUtils.getValueAsString((EvaluationContext)context, (Value)eval);
                        buf.append(result2);
                    }
                    catch (EvaluateException e) {
                        buf.append(DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]));
                        buf.append(" \"");
                        buf.append(expressionToEvaluate);
                        buf.append("\"");
                        buf.append(" : ");
                        buf.append(e.getMessage());
                    }
                    buf.append("\n");
                }
                if (buf.length() > 0) {
                    debugProcess.printToConsole(buf.toString());
                }
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)buf);
            }
        }
        if (this.isRemoveAfterHit()) {
            this.handleTemporaryBreakpointHit(debugProcess);
        }
    }

    private boolean hasObjectID(long id) {
        for (InstanceFilter instanceFilter : this.getInstanceFilters()) {
            if (instanceFilter.getId() != id) continue;
            return true;
        }
        return false;
    }

    public boolean evaluateCondition(final EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
        ThreeState result2;
        Location location;
        String typeName;
        ObjectReference reference;
        Value value;
        DebugProcessImpl debugProcess = context.getDebugProcess();
        if (this.isCountFilterEnabled()) {
            debugProcess.getVirtualMachineProxy().suspend();
            debugProcess.getRequestsManager().deleteRequest(this);
            this.createRequest(debugProcess);
            debugProcess.getVirtualMachineProxy().resume();
        }
        if (this.isInstanceFiltersEnabled() && (value = context.getThisObject()) != null && !this.hasObjectID((reference = (ObjectReference)value).uniqueID())) {
            return false;
        }
        if (this.isClassFiltersEnabled() && !this.typeMatchesClassFilters(typeName = this.calculateEventClass(context, event))) {
            return false;
        }
        if (!this.isConditionEnabled() || this.getCondition().getText().isEmpty()) {
            return true;
        }
        StackFrameProxyImpl frame = context.getFrameProxy();
        if (frame != null && (location = frame.location()) != null && (result2 = debugProcess.getPositionManager().evaluateCondition(context, frame, location, this.getCondition().getText())) != ThreeState.UNSURE) {
            return result2 == ThreeState.YES;
        }
        try {
            final Project project2 = context.getProject();
            ExpressionEvaluator evaluator = DebuggerInvocationUtil.commitAndRunReadAction(project2, new EvaluatingComputable<ExpressionEvaluator>(){

                @Override
                public ExpressionEvaluator compute() throws EvaluateException {
                    SourcePosition contextSourcePosition = ContextUtil.getSourcePosition((StackFrameContext)context);
                    PsiElement contextPsiElement = ContextUtil.getContextElement(contextSourcePosition);
                    if (contextPsiElement == null) {
                        contextPsiElement = Breakpoint.this.getEvaluationElement();
                    }
                    return EvaluatorBuilderImpl.build(Breakpoint.this.getCondition(), contextPsiElement, contextSourcePosition, project2);
                }
            });
            Object value2 = UnBoxingEvaluator.unbox(evaluator.evaluate((EvaluationContext)context), context);
            if (!(value2 instanceof BooleanValue)) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.boolean.expected", (Object[])new Object[0]));
            }
            if (!((BooleanValue)value2).booleanValue()) {
                return false;
            }
        }
        catch (EvaluateException ex) {
            if (ex.getCause() instanceof VMDisconnectedException) {
                return false;
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"error.failed.evaluating.breakpoint.condition", (Object[])new Object[]{this.getCondition(), ex.getMessage()}));
        }
        return true;
    }

    protected String calculateEventClass(EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
        return event.location().declaringType().name();
    }

    private boolean typeMatchesClassFilters(@Nullable String typeName) {
        if (typeName == null) {
            return true;
        }
        boolean matches = false;
        boolean hasEnabled = false;
        for (ClassFilter classFilter : this.getClassFilters()) {
            if (!classFilter.isEnabled()) continue;
            hasEnabled = true;
            if (!classFilter.matches(typeName)) continue;
            matches = true;
            break;
        }
        if (hasEnabled && !matches) {
            return false;
        }
        for (ClassFilter classFilter : this.getClassExclusionFilters()) {
            if (!classFilter.isEnabled() || !classFilter.matches(typeName)) continue;
            return false;
        }
        return true;
    }

    private void handleTemporaryBreakpointHit(final DebugProcessImpl debugProcess) {
        debugProcess.getRequestsManager().deleteRequest(this);
        debugProcess.addDebugProcessListener(new DebugProcessListener(){

            public void resumed(SuspendContext suspendContext) {
                this.removeBreakpoint();
            }

            public void processDetached(DebugProcess process2, boolean closedByUser) {
                this.removeBreakpoint();
            }

            private void removeBreakpoint() {
                AppUIUtil.invokeOnEdt(() -> DebuggerManagerEx.getInstanceEx(Breakpoint.this.myProject).getBreakpointManager().removeBreakpoint(Breakpoint.this));
                debugProcess.removeDebugProcessListener(this);
            }
        });
    }

    public void updateUI() {
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        FilteredRequestorImpl requestor = new FilteredRequestorImpl(this.myProject);
        requestor.readTo(parentNode, this);
        try {
            this.setEnabled(Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"ENABLED")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setLogEnabled(Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"LOG_ENABLED")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String logMessage = JDOMExternalizerUtil.readField((Element)parentNode, (String)LOG_MESSAGE_OPTION_NAME);
            if (logMessage != null && !logMessage.isEmpty()) {
                XExpressionImpl expression = XExpressionImpl.fromText(logMessage);
                XDebuggerHistoryManager.getInstance(this.myProject).addRecentExpression("breakpointLogExpression", expression);
                this.myXBreakpoint.setLogExpressionObject((XExpression)expression);
                ((XBreakpointBase)this.myXBreakpoint).setLogExpressionEnabled(Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"LOG_EXPRESSION_ENABLED")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setRemoveAfterHit(Boolean.valueOf(JDOMExternalizerUtil.readField((Element)parentNode, (String)"REMOVE_AFTER_HIT")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public abstract PsiElement getEvaluationElement();

    protected TextWithImports getLogMessage() {
        return TextWithImportsImpl.fromXExpression(this.myXBreakpoint.getLogExpressionObject());
    }

    protected TextWithImports getCondition() {
        return TextWithImportsImpl.fromXExpression(this.myXBreakpoint.getConditionExpression());
    }

    public boolean isEnabled() {
        return this.myXBreakpoint.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.myXBreakpoint.setEnabled(enabled);
    }

    protected boolean isLogEnabled() {
        return this.myXBreakpoint.isLogMessage();
    }

    public void setLogEnabled(boolean logEnabled) {
        this.myXBreakpoint.setLogMessage(logEnabled);
    }

    protected boolean isLogExpressionEnabled() {
        XExpression expression = this.myXBreakpoint.getLogExpressionObject();
        if (XDebuggerUtilImpl.isEmptyExpression(expression)) {
            return false;
        }
        return !this.getLogMessage().isEmpty();
    }

    @Override
    public boolean isCountFilterEnabled() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).isCOUNT_FILTER_ENABLED();
    }

    public void setCountFilterEnabled(boolean enabled) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setCOUNT_FILTER_ENABLED(enabled)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public int getCountFilter() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).getCOUNT_FILTER();
    }

    public void setCountFilter(int filter) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setCOUNT_FILTER(filter)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public boolean isClassFiltersEnabled() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).isCLASS_FILTERS_ENABLED();
    }

    public void setClassFiltersEnabled(boolean enabled) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setCLASS_FILTERS_ENABLED(enabled)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public ClassFilter[] getClassFilters() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).getClassFilters();
    }

    public void setClassFilters(ClassFilter[] filters) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setClassFilters(filters)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public ClassFilter[] getClassExclusionFilters() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).getClassExclusionFilters();
    }

    protected void setClassExclusionFilters(ClassFilter[] filters) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setClassExclusionFilters(filters)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public boolean isInstanceFiltersEnabled() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).isINSTANCE_FILTERS_ENABLED();
    }

    public void setInstanceFiltersEnabled(boolean enabled) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setINSTANCE_FILTERS_ENABLED(enabled)) {
            this.fireBreakpointChanged();
        }
    }

    @Override
    public InstanceFilter[] getInstanceFilters() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).getInstanceFilters();
    }

    public void setInstanceFilters(InstanceFilter[] filters) {
        if (((JavaBreakpointProperties)((Object)this.getProperties())).setInstanceFilters(filters)) {
            this.fireBreakpointChanged();
        }
    }

    private static String getSuspendPolicy(XBreakpoint breakpoint) {
        switch (breakpoint.getSuspendPolicy()) {
            case ALL: {
                return "SuspendAll";
            }
            case THREAD: {
                return "SuspendThread";
            }
            case NONE: {
                return "SuspendNone";
            }
        }
        throw new IllegalArgumentException("unknown suspend policy");
    }

    static SuspendPolicy transformSuspendPolicy(String policy) {
        if ("SuspendAll".equals(policy)) {
            return SuspendPolicy.ALL;
        }
        if ("SuspendThread".equals(policy)) {
            return SuspendPolicy.THREAD;
        }
        if ("SuspendNone".equals(policy)) {
            return SuspendPolicy.NONE;
        }
        throw new IllegalArgumentException("unknown suspend policy");
    }

    protected boolean isSuspend() {
        return this.myXBreakpoint.getSuspendPolicy() != SuspendPolicy.NONE;
    }

    @Override
    public String getSuspendPolicy() {
        return Breakpoint.getSuspendPolicy(this.myXBreakpoint);
    }

    public void setSuspendPolicy(String policy) {
        this.myXBreakpoint.setSuspendPolicy(Breakpoint.transformSuspendPolicy(policy));
    }

    protected boolean isConditionEnabled() {
        XExpression condition = this.myXBreakpoint.getConditionExpression();
        if (XDebuggerUtilImpl.isEmptyExpression(condition)) {
            return false;
        }
        return !this.getCondition().isEmpty();
    }

    public void setCondition(@Nullable TextWithImports condition) {
        this.myXBreakpoint.setConditionExpression(TextWithImportsImpl.toXExpression(condition));
    }

    public void addInstanceFilter(long l) {
        ((JavaBreakpointProperties)((Object)this.getProperties())).addInstanceFilter(l);
    }

    protected void fireBreakpointChanged() {
        ((XBreakpointBase)this.myXBreakpoint).fireBreakpointChanged();
    }
}

