/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class DescriptorTree {
    private final HashMap<NodeDescriptor, List<NodeDescriptor>> myChildrenMap = new HashMap();
    private final List<NodeDescriptor> myRootChildren = new ArrayList<NodeDescriptor>();
    private final boolean myInitial;
    private int myFrameCount = -1;
    private int myFrameIndex = -1;

    public DescriptorTree() {
        this(false);
    }

    public DescriptorTree(boolean isInitial) {
        this.myInitial = isInitial;
    }

    public void clear() {
        this.myChildrenMap.clear();
        this.myRootChildren.clear();
    }

    public boolean frameIdEquals(int frameCount, int frameIndex) {
        return this.myFrameCount == frameCount && this.myFrameIndex == frameIndex;
    }

    public void setFrameId(int frameCount, int frameIndex) {
        this.myFrameIndex = frameIndex;
        this.myFrameCount = frameCount;
    }

    public void addChild(NodeDescriptor parent, NodeDescriptor child) {
        List children2 = parent == null ? this.myRootChildren : this.myChildrenMap.computeIfAbsent(parent, c -> new ArrayList());
        children2.add((NodeDescriptor)child);
        if (this.myInitial && child instanceof LocalVariableDescriptorImpl) {
            ((LocalVariableDescriptorImpl)child).setNewLocal(false);
        }
    }

    public List<NodeDescriptor> getChildren(NodeDescriptor parent) {
        if (parent == null) {
            return this.myRootChildren;
        }
        List<NodeDescriptor> children2 = this.myChildrenMap.get(parent);
        return children2 != null ? children2 : Collections.emptyList();
    }

    public void dfst(DFSTWalker walker) {
        this.dfstImpl(null, this.myRootChildren, walker);
    }

    private void dfstImpl(NodeDescriptor descriptor, List<NodeDescriptor> children2, DFSTWalker walker) {
        if (children2 != null) {
            for (NodeDescriptor child : children2) {
                walker.visit(descriptor, child);
                this.dfstImpl(child, this.myChildrenMap.get(child), walker);
            }
        }
    }

    public static interface DFSTWalker {
        public void visit(NodeDescriptor var1, NodeDescriptor var2);
    }
}

