/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public final class BasicRendererProperties
implements Cloneable,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.BasicRendererProperties");
    @NonNls
    private static final String NAME_OPTION = "NAME";
    private String myName;
    @NonNls
    private static final String ENABLED_OPTION = "ENABLED";
    private boolean myEnabled;
    @NonNls
    private static final String CLASSNAME_OPTION = "QUALIFIED_NAME";
    private String myClassName;
    @NonNls
    private static final String SHOWTYPE_OPTION = "SHOW_TYPE";
    private boolean myShowType = true;

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public String getClassName() {
        return this.myClassName;
    }

    public void setClassName(String className) {
        this.myClassName = className;
    }

    public boolean isShowType() {
        return this.myShowType;
    }

    public void setShowType(boolean showType) {
        this.myShowType = showType;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myName = null;
        this.myClassName = null;
        for (Element option : element.getChildren("option")) {
            String optionName = option.getAttributeValue("name");
            if (NAME_OPTION.equals(optionName)) {
                this.myName = option.getAttributeValue("value");
                continue;
            }
            if (ENABLED_OPTION.equals(optionName)) {
                this.myEnabled = Boolean.parseBoolean(option.getAttributeValue("value"));
                continue;
            }
            if (CLASSNAME_OPTION.equals(optionName)) {
                this.myClassName = option.getAttributeValue("value");
                continue;
            }
            if (!SHOWTYPE_OPTION.equals(optionName)) continue;
            this.myShowType = !"false".equalsIgnoreCase(option.getAttributeValue("value"));
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (this.myName != null) {
            BasicRendererProperties.addOption(element, NAME_OPTION, this.myName);
        }
        if (this.myEnabled) {
            BasicRendererProperties.addOption(element, ENABLED_OPTION, Boolean.toString(this.myEnabled));
        }
        if (this.myClassName != null) {
            BasicRendererProperties.addOption(element, CLASSNAME_OPTION, this.myClassName);
        }
        if (!this.myShowType) {
            BasicRendererProperties.addOption(element, SHOWTYPE_OPTION, Boolean.toString(this.myShowType));
        }
    }

    private static void addOption(Element element, String optionName, String optionValue) {
        Element option = new Element("option");
        element.addContent(option);
        option.setAttribute("name", optionName);
        option.setAttribute("value", optionValue);
    }

    public BasicRendererProperties clone() {
        try {
            return (BasicRendererProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }
}

