/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;
import org.jetbrains.annotations.NotNull;

public class LogMessage
extends AbstractMessage {
    private final Throwable myThrowable;
    private final String myHeader;
    private List<Attachment> myAttachments = null;

    public LogMessage(LoggingEvent aEvent) {
        this.myThrowable = aEvent.getThrowableInformation() == null ? null : aEvent.getThrowableInformation().getThrowable();
        this.myHeader = aEvent.getMessage() == null || aEvent.getMessage().toString().length() == 0 ? this.getThrowable().toString() : aEvent.getMessage().toString();
    }

    public LogMessage(IdeaLoggingEvent aEvent) {
        String message;
        this.myThrowable = aEvent.getThrowable();
        String header = null;
        if (!StringUtil.isEmptyOrSpaces((String)aEvent.getMessage())) {
            header = aEvent.getMessage();
        }
        if (this.myThrowable != null && StringUtil.isNotEmpty((String)(message = this.myThrowable.getMessage())) && (header == null || !header.startsWith(message))) {
            if (header != null) {
                if (header.endsWith(":")) {
                    header = header + " ";
                } else if (!header.endsWith(": ")) {
                    header = header + ": ";
                }
                header = header + message;
            } else {
                header = message;
            }
        }
        if (header == null) {
            header = "No message";
        }
        this.myHeader = header;
    }

    @Override
    public Throwable getThrowable() {
        return this.myThrowable;
    }

    @Override
    public String getMessage() {
        return this.myHeader;
    }

    @Override
    public String getThrowableText() {
        return StringUtil.join((String[])IdeaLogger.getThrowableRenderer().doRender(this.getThrowable()), (String)Layout.LINE_SEP);
    }

    public void addAttachment(Attachment attachment) {
        if (this.myAttachments == null) {
            this.myAttachments = ContainerUtil.createLockFreeCopyOnWriteList();
        }
        this.myAttachments.add(attachment);
    }

    @Override
    @NotNull
    public List<Attachment> getAllAttachments() {
        List<Object> list = this.myAttachments != null ? this.myAttachments : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/LogMessage", "getAllAttachments"));
        }
        return list;
    }
}

