/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncScrollSupport {
    private static final Logger LOG = Logger.getInstance(SyncScrollSupport.class);

    private static void doScrollVertically(@NotNull Editor editor, int offset, boolean animated) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/SyncScrollSupport", "doScrollVertically"));
        }
        ScrollingModel model = editor.getScrollingModel();
        if (!animated) {
            model.disableAnimation();
        }
        model.scrollVertically(offset);
        if (!animated) {
            model.enableAnimation();
        }
    }

    private static void doScrollHorizontally(@NotNull Editor editor, int offset, boolean animated) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/SyncScrollSupport", "doScrollHorizontally"));
        }
        ScrollingModel model = editor.getScrollingModel();
        if (!animated) {
            model.disableAnimation();
        }
        model.scrollHorizontally(offset);
        if (!animated) {
            model.enableAnimation();
        }
    }

    private static int getHeaderOffset(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/SyncScrollSupport", "getHeaderOffset"));
        }
        JComponent header = editor.getHeaderComponent();
        return header == null ? 0 : header.getHeight();
    }

    @NotNull
    public static int[] getTargetOffsets(@NotNull Editor editor1, @NotNull Editor editor2, int startLine1, int endLine1, int startLine2, int endLine2, int preferredTopShift) {
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/diff/tools/util/SyncScrollSupport", "getTargetOffsets"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/diff/tools/util/SyncScrollSupport", "getTargetOffsets"));
        }
        int[] nArray = SyncScrollSupport.getTargetOffsets(new Editor[]{editor1, editor2}, new int[]{startLine1, startLine2}, new int[]{endLine1, endLine2}, preferredTopShift);
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/SyncScrollSupport", "getTargetOffsets"));
        }
        return nArray;
    }

    @NotNull
    private static int[] getTargetOffsets(@NotNull Editor[] editors, int[] startLines, int[] endLines, int preferredTopShift) {
        int i;
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/util/SyncScrollSupport", "getTargetOffsets"));
        }
        int count = editors.length;
        assert (startLines.length == count);
        assert (endLines.length == count);
        int[] topOffsets = new int[count];
        int[] bottomOffsets = new int[count];
        int[] rangeHeights = new int[count];
        int[] gapLines = new int[count];
        int[] editorHeights = new int[count];
        int[] maximumOffsets = new int[count];
        int[] topShifts = new int[count];
        for (int i2 = 0; i2 < count; ++i2) {
            topOffsets[i2] = editors[i2].logicalPositionToXY((LogicalPosition)new LogicalPosition((int)startLines[i2], (int)0)).y;
            bottomOffsets[i2] = editors[i2].logicalPositionToXY((LogicalPosition)new LogicalPosition((int)(endLines[i2] + 1), (int)0)).y;
            rangeHeights[i2] = bottomOffsets[i2] - topOffsets[i2];
            gapLines[i2] = 2 * editors[i2].getLineHeight();
            editorHeights[i2] = editors[i2].getScrollingModel().getVisibleArea().height;
            maximumOffsets[i2] = ((EditorEx)editors[i2]).getScrollPane().getVerticalScrollBar().getMaximum() - editorHeights[i2];
            boolean canShow = 2 * gapLines[i2] + rangeHeights[i2] <= editorHeights[i2];
            int shift = preferredTopShift != -1 ? preferredTopShift : editorHeights[i2] / 3;
            topShifts[i2] = canShow ? Math.min(editorHeights[i2] - gapLines[i2] - rangeHeights[i2], shift) : gapLines[i2];
        }
        int topShift = SyncScrollSupport.min(topShifts);
        topShift = Math.min(topShift, SyncScrollSupport.min(topOffsets));
        int[] offsets = new int[count];
        boolean haveEnoughSpace = true;
        for (i = 0; i < count; ++i) {
            offsets[i] = topOffsets[i] - topShift;
            haveEnoughSpace &= maximumOffsets[i] > offsets[i];
        }
        if (haveEnoughSpace) {
            if (offsets == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/SyncScrollSupport", "getTargetOffsets"));
            }
            return offsets;
        }
        topShift = 0;
        for (i = 0; i < count; ++i) {
            topShift = Math.max(topOffsets[i] - maximumOffsets[i], topShift);
        }
        for (i = 0; i < count; ++i) {
            offsets[i] = topOffsets[i] - topShift + Math.max(topShift + rangeHeights[i] + gapLines[i] - editorHeights[i], 0);
            offsets[i] = Math.min(offsets[i], topOffsets[i] - gapLines[i]);
        }
        if (offsets == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/SyncScrollSupport", "getTargetOffsets"));
        }
        return offsets;
    }

    private static int min(int[] values) {
        int min = Integer.MAX_VALUE;
        for (int value : values) {
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    private static class Anchor {
        public final int masterStartOffset;
        public final int masterEndOffset;
        public final int slaveStartOffset;
        public final int slaveEndOffset;

        public Anchor(int masterStartOffset, int masterEndOffset, int slaveStartOffset, int slaveEndOffset) {
            this.masterStartOffset = masterStartOffset;
            this.masterEndOffset = masterEndOffset;
            this.slaveStartOffset = slaveStartOffset;
            this.slaveEndOffset = slaveEndOffset;
        }
    }

    private static abstract class ScrollHelper
    implements VisibleAreaListener {
        @NotNull
        private final List<? extends Editor> myEditors;
        private final int myMasterIndex;
        private final int mySlaveIndex;
        @Nullable
        private Anchor myAnchor;

        public ScrollHelper(@NotNull List<? extends Editor> editors, int masterIndex, int slaveIndex) {
            if (editors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/util/SyncScrollSupport$ScrollHelper", "<init>"));
            }
            this.myEditors = editors;
            this.myMasterIndex = masterIndex;
            this.mySlaveIndex = slaveIndex;
        }

        @NotNull
        public static ScrollHelper create(@NotNull List<? extends Editor> editors, int masterIndex, int slaveIndex, final @NotNull SyncScrollable scrollable, final @NotNull Side side) {
            if (editors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/util/SyncScrollSupport$ScrollHelper", "create"));
            }
            if (scrollable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollable", "com/intellij/diff/tools/util/SyncScrollSupport$ScrollHelper", "create"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/SyncScrollSupport$ScrollHelper", "create"));
            }
            ScrollHelper scrollHelper = new ScrollHelper(editors, masterIndex, slaveIndex){

                @Override
                protected int convertLine(int value) {
                    return scrollable.transfer(side, value);
                }
            };
            if (scrollHelper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/SyncScrollSupport$ScrollHelper", "create"));
            }
            return scrollHelper;
        }

        protected abstract int convertLine(int var1);

        public void setAnchor(int masterStartOffset, int masterEndOffset, int slaveStartOffset, int slaveEndOffset) {
            this.myAnchor = new Anchor(masterStartOffset, masterEndOffset, slaveStartOffset, slaveEndOffset);
        }

        public void removeAnchor() {
            this.myAnchor = null;
        }

        public void visibleAreaChanged(VisibleAreaEvent e) {
            Rectangle newRectangle = e.getNewRectangle();
            Rectangle oldRectangle = e.getOldRectangle();
            if (oldRectangle == null) {
                return;
            }
            if (newRectangle.x != oldRectangle.x) {
                this.syncHorizontalScroll(false);
            }
            if (newRectangle.y != oldRectangle.y) {
                this.syncVerticalScroll(false);
            }
        }

        public int getMasterIndex() {
            return this.myMasterIndex;
        }

        public int getSlaveIndex() {
            return this.mySlaveIndex;
        }

        @NotNull
        public Editor getMaster() {
            Editor editor = this.myEditors.get(this.myMasterIndex);
            if (editor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/SyncScrollSupport$ScrollHelper", "getMaster"));
            }
            return editor;
        }

        @NotNull
        public Editor getSlave() {
            Editor editor = this.myEditors.get(this.mySlaveIndex);
            if (editor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/SyncScrollSupport$ScrollHelper", "getSlave"));
            }
            return editor;
        }

        private void syncVerticalScroll(boolean animated) {
            int offset;
            if (this.getMaster().getDocument().getTextLength() == 0) {
                return;
            }
            Rectangle viewRect = this.getMaster().getScrollingModel().getVisibleArea();
            int middleY = viewRect.height / 3;
            if (this.myAnchor == null) {
                LogicalPosition masterPos = this.getMaster().xyToLogicalPosition(new Point(viewRect.x, viewRect.y + middleY));
                int masterCenterLine = masterPos.line;
                int convertedCenterLine = this.convertLine(masterCenterLine);
                Point point = this.getSlave().logicalPositionToXY(new LogicalPosition(convertedCenterLine, masterPos.column));
                int correction = (viewRect.y + middleY) % this.getMaster().getLineHeight();
                offset = point.y - middleY + correction;
            } else {
                double progress = this.myAnchor.masterStartOffset == this.myAnchor.masterEndOffset || viewRect.y == this.myAnchor.masterEndOffset ? 1.0 : (double)(viewRect.y - this.myAnchor.masterStartOffset) / (double)(this.myAnchor.masterEndOffset - this.myAnchor.masterStartOffset);
                offset = this.myAnchor.slaveStartOffset + (int)((double)(this.myAnchor.slaveEndOffset - this.myAnchor.slaveStartOffset) * progress);
            }
            int deltaHeaderOffset = SyncScrollSupport.getHeaderOffset(this.getSlave()) - SyncScrollSupport.getHeaderOffset(this.getMaster());
            SyncScrollSupport.doScrollVertically(this.getSlave(), offset + deltaHeaderOffset, animated);
        }

        private void syncHorizontalScroll(boolean animated) {
            int offset = this.getMaster().getScrollingModel().getVisibleArea().x;
            SyncScrollSupport.doScrollHorizontally(this.getSlave(), offset, animated);
        }
    }

    private static abstract class SyncScrollSupportBase
    implements Support {
        private int myDuringSyncScrollDepth = 0;

        private SyncScrollSupportBase() {
        }

        public boolean isDuringSyncScroll() {
            return this.myDuringSyncScrollDepth > 0;
        }

        @Override
        public void enterDisableScrollSection() {
            ++this.myDuringSyncScrollDepth;
        }

        @Override
        public void exitDisableScrollSection() {
            --this.myDuringSyncScrollDepth;
            assert (this.myDuringSyncScrollDepth >= 0);
        }

        @NotNull
        protected abstract List<? extends Editor> getEditors();

        @NotNull
        protected abstract List<? extends ScrollHelper> getScrollHelpers();

        protected void doMakeVisible(int masterIndex, int[] startLines, int[] endLines, boolean animate) {
            List<? extends Editor> editors = this.getEditors();
            List<? extends ScrollHelper> helpers = this.getScrollHelpers();
            int count = editors.size();
            assert (startLines.length == count);
            assert (endLines.length == count);
            int[] offsets = SyncScrollSupport.getTargetOffsets(editors.toArray(new Editor[count]), startLines, endLines, -1);
            int[] startOffsets = new int[count];
            for (int i = 0; i < count; ++i) {
                startOffsets[i] = editors.get((int)i).getScrollingModel().getVisibleArea().y;
            }
            Editor masterEditor = editors.get(masterIndex);
            int masterOffset = offsets[masterIndex];
            int masterStartOffset = startOffsets[masterIndex];
            for (ScrollHelper scrollHelper : helpers) {
                scrollHelper.setAnchor(startOffsets[scrollHelper.getMasterIndex()], offsets[scrollHelper.getMasterIndex()], startOffsets[scrollHelper.getSlaveIndex()], offsets[scrollHelper.getSlaveIndex()]);
            }
            SyncScrollSupport.doScrollHorizontally(masterEditor, 0, false);
            SyncScrollSupport.doScrollVertically(masterEditor, masterOffset, animate);
            masterEditor.getScrollingModel().runActionOnScrollingFinished(() -> {
                for (ScrollHelper helper : helpers) {
                    helper.removeAnchor();
                }
                int masterFinalOffset = masterEditor.getScrollingModel().getVisibleArea().y;
                boolean animateSlaves = animate && masterFinalOffset == masterStartOffset;
                for (int i = 0; i < count; ++i) {
                    if (i == masterIndex) continue;
                    Editor editor = (Editor)editors.get(i);
                    int finalOffset = editor.getScrollingModel().getVisibleArea().y;
                    if (finalOffset == offsets[i]) continue;
                    this.enterDisableScrollSection();
                    SyncScrollSupport.doScrollVertically(editor, offsets[i], animateSlaves);
                    editor.getScrollingModel().runActionOnScrollingFinished(() -> this.exitDisableScrollSection());
                }
            });
        }
    }

    public static class ThreesideSyncScrollSupport
    extends SyncScrollSupportBase {
        @NotNull
        private final List<? extends Editor> myEditors;
        @NotNull
        private final SyncScrollable myScrollable12;
        @NotNull
        private final SyncScrollable myScrollable23;
        @NotNull
        private final ScrollHelper myHelper12;
        @NotNull
        private final ScrollHelper myHelper21;
        @NotNull
        private final ScrollHelper myHelper23;
        @NotNull
        private final ScrollHelper myHelper32;

        public ThreesideSyncScrollSupport(@NotNull List<? extends Editor> editors, @NotNull SyncScrollable scrollable12, @NotNull SyncScrollable scrollable23) {
            if (editors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/util/SyncScrollSupport$ThreesideSyncScrollSupport", "<init>"));
            }
            if (scrollable12 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollable12", "com/intellij/diff/tools/util/SyncScrollSupport$ThreesideSyncScrollSupport", "<init>"));
            }
            if (scrollable23 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollable23", "com/intellij/diff/tools/util/SyncScrollSupport$ThreesideSyncScrollSupport", "<init>"));
            }
            assert (editors.size() == 3);
            this.myEditors = editors;
            this.myScrollable12 = scrollable12;
            this.myScrollable23 = scrollable23;
            this.myHelper12 = this.create(ThreeSide.LEFT, ThreeSide.BASE);
            this.myHelper21 = this.create(ThreeSide.BASE, ThreeSide.LEFT);
            this.myHelper23 = this.create(ThreeSide.BASE, ThreeSide.RIGHT);
            this.myHelper32 = this.create(ThreeSide.RIGHT, ThreeSide.BASE);
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            List<? extends Editor> list = this.myEditors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/SyncScrollSupport$ThreesideSyncScrollSupport", "getEditors"));
            }
            return list;
        }

        @Override
        @NotNull
        protected List<? extends ScrollHelper> getScrollHelpers() {
            List list = ContainerUtil.list((Object[])new ScrollHelper[]{this.myHelper12, this.myHelper21, this.myHelper23, this.myHelper32});
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/SyncScrollSupport$ThreesideSyncScrollSupport", "getScrollHelpers"));
            }
            return list;
        }

        @NotNull
        public SyncScrollable getScrollable12() {
            SyncScrollable syncScrollable = this.myScrollable12;
            if (syncScrollable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/SyncScrollSupport$ThreesideSyncScrollSupport", "getScrollable12"));
            }
            return syncScrollable;
        }

        @NotNull
        public SyncScrollable getScrollable23() {
            SyncScrollable syncScrollable = this.myScrollable23;
            if (syncScrollable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/SyncScrollSupport$ThreesideSyncScrollSupport", "getScrollable23"));
            }
            return syncScrollable;
        }

        public void visibleAreaChanged(VisibleAreaEvent e) {
            if (this.isDuringSyncScroll()) {
                return;
            }
            this.enterDisableScrollSection();
            try {
                if (e.getEditor() == ThreeSide.LEFT.select(this.myEditors)) {
                    if (this.myScrollable12.isSyncScrollEnabled()) {
                        this.myHelper12.visibleAreaChanged(e);
                        if (this.myScrollable23.isSyncScrollEnabled()) {
                            this.myHelper23.visibleAreaChanged(e);
                        }
                    }
                } else if (e.getEditor() == ThreeSide.BASE.select(this.myEditors)) {
                    if (this.myScrollable12.isSyncScrollEnabled()) {
                        this.myHelper21.visibleAreaChanged(e);
                    }
                    if (this.myScrollable23.isSyncScrollEnabled()) {
                        this.myHelper23.visibleAreaChanged(e);
                    }
                } else if (e.getEditor() == ThreeSide.RIGHT.select(this.myEditors) && this.myScrollable23.isSyncScrollEnabled()) {
                    this.myHelper32.visibleAreaChanged(e);
                    if (this.myScrollable12.isSyncScrollEnabled()) {
                        this.myHelper21.visibleAreaChanged(e);
                    }
                }
            }
            finally {
                this.exitDisableScrollSection();
            }
        }

        public void makeVisible(@NotNull ThreeSide masterSide, int[] startLines, int[] endLines, boolean animate) {
            if (masterSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "masterSide", "com/intellij/diff/tools/util/SyncScrollSupport$ThreesideSyncScrollSupport", "makeVisible"));
            }
            this.doMakeVisible(masterSide.getIndex(), startLines, endLines, animate);
        }

        @NotNull
        private ScrollHelper create(@NotNull ThreeSide master, @NotNull ThreeSide slave) {
            SyncScrollable scrollable;
            if (master == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "master", "com/intellij/diff/tools/util/SyncScrollSupport$ThreesideSyncScrollSupport", "create"));
            }
            if (slave == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slave", "com/intellij/diff/tools/util/SyncScrollSupport$ThreesideSyncScrollSupport", "create"));
            }
            assert (master != slave);
            assert (master == ThreeSide.BASE || slave == ThreeSide.BASE);
            boolean leftSide = master == ThreeSide.LEFT || slave == ThreeSide.LEFT;
            SyncScrollable syncScrollable = scrollable = leftSide ? this.myScrollable12 : this.myScrollable23;
            Side side = leftSide ? Side.fromLeft((master == ThreeSide.LEFT ? 1 : 0) != 0) : Side.fromLeft((master == ThreeSide.BASE ? 1 : 0) != 0);
            ScrollHelper scrollHelper = ScrollHelper.create(this.myEditors, master.getIndex(), slave.getIndex(), scrollable, side);
            if (scrollHelper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/SyncScrollSupport$ThreesideSyncScrollSupport", "create"));
            }
            return scrollHelper;
        }
    }

    public static class TwosideSyncScrollSupport
    extends SyncScrollSupportBase {
        @NotNull
        private final List<? extends Editor> myEditors;
        @NotNull
        private final SyncScrollable myScrollable;
        @NotNull
        private final ScrollHelper myHelper1;
        @NotNull
        private final ScrollHelper myHelper2;

        public TwosideSyncScrollSupport(@NotNull List<? extends Editor> editors, @NotNull SyncScrollable scrollable) {
            if (editors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/util/SyncScrollSupport$TwosideSyncScrollSupport", "<init>"));
            }
            if (scrollable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollable", "com/intellij/diff/tools/util/SyncScrollSupport$TwosideSyncScrollSupport", "<init>"));
            }
            this.myEditors = editors;
            this.myScrollable = scrollable;
            this.myHelper1 = this.create(Side.LEFT);
            this.myHelper2 = this.create(Side.RIGHT);
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            List<? extends Editor> list = this.myEditors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/SyncScrollSupport$TwosideSyncScrollSupport", "getEditors"));
            }
            return list;
        }

        @Override
        @NotNull
        protected List<? extends ScrollHelper> getScrollHelpers() {
            List list = ContainerUtil.list((Object[])new ScrollHelper[]{this.myHelper1, this.myHelper2});
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/SyncScrollSupport$TwosideSyncScrollSupport", "getScrollHelpers"));
            }
            return list;
        }

        @NotNull
        public SyncScrollable getScrollable() {
            SyncScrollable syncScrollable = this.myScrollable;
            if (syncScrollable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/SyncScrollSupport$TwosideSyncScrollSupport", "getScrollable"));
            }
            return syncScrollable;
        }

        public void visibleAreaChanged(VisibleAreaEvent e) {
            if (!this.myScrollable.isSyncScrollEnabled() || this.isDuringSyncScroll()) {
                return;
            }
            this.enterDisableScrollSection();
            try {
                if (e.getEditor() == Side.LEFT.select(this.myEditors)) {
                    this.myHelper1.visibleAreaChanged(e);
                } else if (e.getEditor() == Side.RIGHT.select(this.myEditors)) {
                    this.myHelper2.visibleAreaChanged(e);
                }
            }
            finally {
                this.exitDisableScrollSection();
            }
        }

        public void makeVisible(@NotNull Side masterSide, int startLine1, int endLine1, int startLine2, int endLine2, boolean animate) {
            if (masterSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "masterSide", "com/intellij/diff/tools/util/SyncScrollSupport$TwosideSyncScrollSupport", "makeVisible"));
            }
            this.doMakeVisible(masterSide.getIndex(), new int[]{startLine1, startLine2}, new int[]{endLine1, endLine2}, animate);
        }

        @NotNull
        private ScrollHelper create(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/SyncScrollSupport$TwosideSyncScrollSupport", "create"));
            }
            ScrollHelper scrollHelper = ScrollHelper.create(this.myEditors, side.getIndex(), side.other().getIndex(), this.myScrollable, side);
            if (scrollHelper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/SyncScrollSupport$TwosideSyncScrollSupport", "create"));
            }
            return scrollHelper;
        }
    }

    public static interface Support {
        public void enterDisableScrollSection();

        public void exitDisableScrollSection();
    }

    public static interface SyncScrollable {
        public boolean isSyncScrollEnabled();

        public int transfer(@NotNull Side var1, int var2);
    }
}

