/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.diff.impl.splitter.Transformation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffDividerDrawUtil {
    public static final BasicStroke BOLD_DOTTED_STROKE = new BasicStroke(2.3f, 0, 0, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);

    @NotNull
    public static Graphics2D getDividerGraphics(@NotNull Graphics g, @NotNull Component divider, @NotNull Component base) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDividerDrawUtil", "getDividerGraphics"));
        }
        if (divider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "divider", "com/intellij/diff/util/DiffDividerDrawUtil", "getDividerGraphics"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/diff/util/DiffDividerDrawUtil", "getDividerGraphics"));
        }
        int width = divider.getWidth();
        int editorHeight = base.getHeight();
        int dividerOffset = divider.getLocationOnScreen().y;
        int editorOffset = base.getLocationOnScreen().y;
        Graphics2D graphics2D = (Graphics2D)g.create(0, editorOffset - dividerOffset, width, editorHeight);
        if (graphics2D == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDividerDrawUtil", "getDividerGraphics"));
        }
        return graphics2D;
    }

    public static void paintSeparators(@NotNull Graphics2D gg, int width, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerSeparatorPaintable paintable) {
        if (gg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/util/DiffDividerDrawUtil", "paintSeparators"));
        }
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/diff/util/DiffDividerDrawUtil", "paintSeparators"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/diff/util/DiffDividerDrawUtil", "paintSeparators"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/diff/util/DiffDividerDrawUtil", "paintSeparators"));
        }
        List<DividerSeparator> polygons = DiffDividerDrawUtil.createVisibleSeparators(editor1, editor2, paintable);
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)gg);
        for (DividerSeparator polygon : polygons) {
            polygon.paint(gg, width);
        }
        config.restore();
    }

    public static void paintPolygons(@NotNull Graphics2D gg, int width, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        if (gg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/util/DiffDividerDrawUtil", "paintPolygons"));
        }
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/diff/util/DiffDividerDrawUtil", "paintPolygons"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/diff/util/DiffDividerDrawUtil", "paintPolygons"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/diff/util/DiffDividerDrawUtil", "paintPolygons"));
        }
        DiffDividerDrawUtil.paintPolygons(gg, width, true, true, editor1, editor2, paintable);
    }

    public static void paintSimplePolygons(@NotNull Graphics2D gg, int width, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        if (gg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/util/DiffDividerDrawUtil", "paintSimplePolygons"));
        }
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/diff/util/DiffDividerDrawUtil", "paintSimplePolygons"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/diff/util/DiffDividerDrawUtil", "paintSimplePolygons"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/diff/util/DiffDividerDrawUtil", "paintSimplePolygons"));
        }
        DiffDividerDrawUtil.paintPolygons(gg, width, true, false, editor1, editor2, paintable);
    }

    public static void paintPolygons(@NotNull Graphics2D gg, int width, boolean paintBorder, boolean curved, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        if (gg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/util/DiffDividerDrawUtil", "paintPolygons"));
        }
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/diff/util/DiffDividerDrawUtil", "paintPolygons"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/diff/util/DiffDividerDrawUtil", "paintPolygons"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/diff/util/DiffDividerDrawUtil", "paintPolygons"));
        }
        List<DividerPolygon> polygons = DiffDividerDrawUtil.createVisiblePolygons(editor1, editor2, paintable);
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)gg);
        for (DividerPolygon polygon : polygons) {
            polygon.paint(gg, width, paintBorder, curved);
        }
        config.restore();
    }

    @NotNull
    public static List<DividerPolygon> createVisiblePolygons(@NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/diff/util/DiffDividerDrawUtil", "createVisiblePolygons"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/diff/util/DiffDividerDrawUtil", "createVisiblePolygons"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/diff/util/DiffDividerDrawUtil", "createVisiblePolygons"));
        }
        final ArrayList<DividerPolygon> polygons = new ArrayList<DividerPolygon>();
        final Transformation[] transformations = new Transformation[]{DiffDividerDrawUtil.getTransformation(editor1), DiffDividerDrawUtil.getTransformation(editor2)};
        final LineRange leftInterval = DiffDividerDrawUtil.getVisibleInterval(editor1);
        final LineRange rightInterval = DiffDividerDrawUtil.getVisibleInterval(editor2);
        paintable.process(new DividerPaintable.Handler(){

            @Override
            public boolean process(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Color color, boolean resolved) {
                if (color == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/diff/util/DiffDividerDrawUtil$1", "process"));
                }
                if (leftInterval.start > endLine1 && rightInterval.start > endLine2) {
                    return true;
                }
                if (leftInterval.end < startLine1 && rightInterval.end < startLine2) {
                    return false;
                }
                polygons.add(DiffDividerDrawUtil.createPolygon(transformations, startLine1, endLine1, startLine2, endLine2, color, resolved));
                return true;
            }

            @Override
            public boolean process(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Color color) {
                if (color == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/diff/util/DiffDividerDrawUtil$1", "process"));
                }
                return this.process(startLine1, endLine1, startLine2, endLine2, color, false);
            }
        });
        ArrayList<DividerPolygon> arrayList = polygons;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDividerDrawUtil", "createVisiblePolygons"));
        }
        return arrayList;
    }

    @NotNull
    public static List<DividerSeparator> createVisibleSeparators(@NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerSeparatorPaintable paintable) {
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/diff/util/DiffDividerDrawUtil", "createVisibleSeparators"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/diff/util/DiffDividerDrawUtil", "createVisibleSeparators"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/diff/util/DiffDividerDrawUtil", "createVisibleSeparators"));
        }
        ArrayList<DividerSeparator> separators = new ArrayList<DividerSeparator>();
        Transformation[] transformations = new Transformation[]{DiffDividerDrawUtil.getTransformation(editor1), DiffDividerDrawUtil.getTransformation(editor2)};
        LineRange leftInterval = DiffDividerDrawUtil.getVisibleInterval(editor1);
        LineRange rightInterval = DiffDividerDrawUtil.getVisibleInterval(editor2);
        int height1 = editor1.getLineHeight();
        int height2 = editor2.getLineHeight();
        EditorColorsScheme scheme = editor1.getColorsScheme();
        paintable.process((line1, line2) -> {
            if (leftInterval.start > line1 + 1 && rightInterval.start > line2 + 1) {
                return true;
            }
            if (leftInterval.end < line1 && rightInterval.end < line2) {
                return false;
            }
            separators.add(DiffDividerDrawUtil.createSeparator(transformations, line1, line2, height1, height2, scheme));
            return true;
        });
        ArrayList<DividerSeparator> arrayList = separators;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDividerDrawUtil", "createVisibleSeparators"));
        }
        return arrayList;
    }

    @NotNull
    private static Transformation getTransformation(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDividerDrawUtil", "getTransformation"));
        }
        Transformation transformation = line -> {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDividerDrawUtil", "lambda$getTransformation$1"));
            }
            int yOffset = editor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)line, (int)0)).y;
            JComponent header = editor.getHeaderComponent();
            int headerOffset = header == null ? 0 : header.getHeight();
            return yOffset - editor.getScrollingModel().getVerticalScrollOffset() + headerOffset;
        };
        if (transformation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDividerDrawUtil", "getTransformation"));
        }
        return transformation;
    }

    @NotNull
    private static DividerPolygon createPolygon(@NotNull Transformation[] transformations, int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Color color) {
        if (transformations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformations", "com/intellij/diff/util/DiffDividerDrawUtil", "createPolygon"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/diff/util/DiffDividerDrawUtil", "createPolygon"));
        }
        DividerPolygon dividerPolygon = DiffDividerDrawUtil.createPolygon(transformations, startLine1, endLine1, startLine2, endLine2, color, false);
        if (dividerPolygon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDividerDrawUtil", "createPolygon"));
        }
        return dividerPolygon;
    }

    @NotNull
    private static DividerPolygon createPolygon(@NotNull Transformation[] transformations, int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Color color, boolean resolved) {
        if (transformations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformations", "com/intellij/diff/util/DiffDividerDrawUtil", "createPolygon"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/diff/util/DiffDividerDrawUtil", "createPolygon"));
        }
        int start1 = transformations[0].transform(startLine1);
        int end1 = transformations[0].transform(endLine1);
        int start2 = transformations[1].transform(startLine2);
        int end2 = transformations[1].transform(endLine2);
        DividerPolygon dividerPolygon = new DividerPolygon(start1, start2, end1, end2, color, resolved);
        if (dividerPolygon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDividerDrawUtil", "createPolygon"));
        }
        return dividerPolygon;
    }

    @NotNull
    private static DividerSeparator createSeparator(@NotNull Transformation[] transformations, int line1, int line2, int height1, int height2, @Nullable EditorColorsScheme scheme) {
        if (transformations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformations", "com/intellij/diff/util/DiffDividerDrawUtil", "createSeparator"));
        }
        int start1 = transformations[0].transform(line1);
        int start2 = transformations[1].transform(line2);
        DividerSeparator dividerSeparator = new DividerSeparator(start1, start2, start1 + height1, start2 + height2, scheme);
        if (dividerSeparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDividerDrawUtil", "createSeparator"));
        }
        return dividerSeparator;
    }

    @NotNull
    private static LineRange getVisibleInterval(Editor editor) {
        Rectangle area = editor.getScrollingModel().getVisibleArea();
        if (area.height < 0) {
            LineRange lineRange = new LineRange(0, 0);
            if (lineRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDividerDrawUtil", "getVisibleInterval"));
            }
            return lineRange;
        }
        LogicalPosition position1 = editor.xyToLogicalPosition(new Point(0, area.y));
        LogicalPosition position2 = editor.xyToLogicalPosition(new Point(0, area.y + area.height));
        LineRange lineRange = new LineRange(position1.line, position2.line);
        if (lineRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDividerDrawUtil", "getVisibleInterval"));
        }
        return lineRange;
    }

    public static class DividerSeparator {
        private final int myStart1;
        private final int myStart2;
        private final int myEnd1;
        private final int myEnd2;
        @Nullable
        private final EditorColorsScheme myScheme;

        public DividerSeparator(int start1, int start2, int end1, int end2) {
            this(start1, start2, end1, end2, null);
        }

        public DividerSeparator(int start1, int start2, int end1, int end2, @Nullable EditorColorsScheme scheme) {
            this.myStart1 = start1;
            this.myStart2 = start2;
            this.myEnd1 = end1;
            this.myEnd2 = end2;
            this.myScheme = scheme;
        }

        public void paint(Graphics2D g, int width) {
            DiffDrawUtil.drawConnectorLineSeparator(g, 0, width, this.myStart1, this.myEnd1, this.myStart2, this.myEnd2, this.myScheme);
        }

        public String toString() {
            return "<" + this.myStart1 + ", " + this.myEnd1 + " : " + this.myStart2 + ", " + this.myEnd2 + "> ";
        }
    }

    public static class DividerPolygon {
        private final int myStart1;
        private final int myStart2;
        private final int myEnd1;
        private final int myEnd2;
        @NotNull
        private final Color myColor;
        private final boolean myResolved;

        public DividerPolygon(int start1, int start2, int end1, int end2, @NotNull Color color) {
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/diff/util/DiffDividerDrawUtil$DividerPolygon", "<init>"));
            }
            this(start1, start2, end1, end2, color, false);
        }

        public DividerPolygon(int start1, int start2, int end1, int end2, @NotNull Color color, boolean resolved) {
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/diff/util/DiffDividerDrawUtil$DividerPolygon", "<init>"));
            }
            this.myStart1 = start1;
            this.myStart2 = start2;
            this.myEnd1 = end1;
            this.myEnd2 = end2;
            this.myColor = color;
            this.myResolved = resolved;
        }

        public void paint(Graphics2D g, int width, boolean paintBorder, boolean curve) {
            Color borderColor;
            int startY1 = this.myStart1 - 1;
            int endY1 = this.myEnd1 - 1;
            int startY2 = this.myStart2 - 1;
            int endY2 = this.myEnd2 - 1;
            if (endY1 - startY1 < 2) {
                endY1 = startY1 + 1;
            }
            if (endY2 - startY2 < 2) {
                endY2 = startY2 + 1;
            }
            Stroke oldStroke = g.getStroke();
            if (this.myResolved) {
                g.setStroke(BOLD_DOTTED_STROKE);
            }
            Color fillColor = this.myResolved ? null : this.myColor;
            Color color = borderColor = this.myResolved ? this.myColor : null;
            if (curve) {
                DiffDrawUtil.drawCurveTrapezium(g, 0, width, startY1, endY1, startY2, endY2, fillColor, borderColor);
            } else {
                DiffDrawUtil.drawTrapezium(g, 0, width, startY1, endY1, startY2, endY2, fillColor, borderColor);
            }
            g.setStroke(oldStroke);
        }

        public String toString() {
            return "<" + this.myStart1 + ", " + this.myEnd1 + " : " + this.myStart2 + ", " + this.myEnd2 + "> " + this.myColor;
        }
    }

    public static interface DividerSeparatorPaintable {
        public void process(@NotNull Handler var1);

        public static interface Handler {
            public boolean process(int var1, int var2);
        }
    }

    public static interface DividerPaintable {
        public void process(@NotNull Handler var1);

        public static abstract class Handler {
            public abstract boolean process(int var1, int var2, int var3, int var4, @NotNull Color var5);

            public abstract boolean process(int var1, int var2, int var3, int var4, @NotNull Color var5, boolean var6);
        }
    }
}

