/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.editor;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.testFramework.LightPlatformTestCase;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class EditorColorSchemeTestCase
extends LightPlatformTestCase {
    protected static EditorColorsScheme loadScheme(@NotNull String docText) throws ParserConfigurationException, IOException, SAXException {
        if (docText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docText", "com/intellij/editor/EditorColorSchemeTestCase", "loadScheme"));
        }
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource inputSource = new InputSource(new StringReader(docText));
        Document doc = docBuilder.parse(inputSource);
        Element root = new DOMBuilder().build(doc.getDocumentElement());
        EditorColorsScheme defaultScheme = EditorColorsManager.getInstance().getScheme("Default");
        EditorColorsSchemeImpl targetScheme = new EditorColorsSchemeImpl(defaultScheme);
        targetScheme.readExternal(root);
        return targetScheme;
    }

    @NotNull
    protected Pair<EditorColorsScheme, TextAttributes> doTestWriteRead(TextAttributesKey key2, TextAttributes attributes) throws WriteExternalException {
        EditorColorsScheme defaultScheme = EditorColorsManager.getInstance().getScheme("Default");
        EditorColorsScheme sourceScheme = (EditorColorsScheme)defaultScheme.clone();
        sourceScheme.setName("test");
        sourceScheme.setAttributes(key2, attributes);
        Element root = new Element("scheme");
        ((AbstractColorsScheme)sourceScheme).writeExternal(root);
        EditorColorsSchemeImpl targetScheme = new EditorColorsSchemeImpl(defaultScheme);
        targetScheme.readExternal(root);
        EditorColorSchemeTestCase.assertEquals((String)"test", (String)targetScheme.getName());
        TextAttributes targetAttrs = targetScheme.getAttributes(key2);
        Pair pair = Pair.create((Object)targetScheme, (Object)targetAttrs);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/editor/EditorColorSchemeTestCase", "doTestWriteRead"));
        }
        return pair;
    }

    protected static void assertXmlOutputEquals(String expected, Element root) throws IOException {
        StringWriter writer = new StringWriter();
        Format format = Format.getPrettyFormat();
        format.setLineSeparator("\n");
        new XMLOutputter(format).output(root, (Writer)writer);
        String actual = writer.toString();
        EditorColorSchemeTestCase.assertEquals((String)expected, (String)actual);
    }
}

