/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.impl.GenericDebuggerRunner;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JavaTestFrameworkRunnableState;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaTestFrameworkDebuggerRunner
extends GenericDebuggerRunner {
    @Override
    @NotNull
    public abstract String getRunnerId();

    protected abstract boolean validForProfile(@NotNull RunProfile var1);

    @NotNull
    protected abstract String getThreadName();

    @Override
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/execution/JavaTestFrameworkDebuggerRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/execution/JavaTestFrameworkDebuggerRunner", "canRun"));
        }
        return DefaultDebugExecutor.EXECUTOR_ID.equals(executorId) && this.validForProfile(profile);
    }

    @Override
    @Nullable
    protected RunContentDescriptor createContentDescriptor(final @NotNull RunProfileState state, final @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/execution/JavaTestFrameworkDebuggerRunner", "createContentDescriptor"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/JavaTestFrameworkDebuggerRunner", "createContentDescriptor"));
        }
        final RunContentDescriptor res = super.createContentDescriptor(state, environment);
        final ServerSocket socket = ((JavaTestFrameworkRunnableState)state).getForkSocket();
        if (socket != null) {
            Thread thread = new Thread(this.getThreadName() + " debugger runner"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try (Socket accept2 = socket.accept();
                         DataInputStream stream = new DataInputStream(accept2.getInputStream());){
                        int read = stream.readInt();
                        while (read != -1) {
                            DebugProcess process2 = DebuggerManager.getInstance((Project)environment.getProject()).getDebugProcess(res.getProcessHandler());
                            if (process2 == null) {
                                break;
                            }
                            RemoteConnection connection = new RemoteConnection(true, "127.0.0.1", String.valueOf(read), true);
                            DefaultDebugEnvironment env = new DefaultDebugEnvironment(environment, state, connection, true);
                            SwingUtilities.invokeLater(() -> {
                                try {
                                    ((DebugProcessImpl)process2).reattach(env);
                                    accept2.getOutputStream().write(0);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            });
                            read = stream.readInt();
                        }
                    }
                    catch (EOFException accept2) {
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
        return res;
    }
}

