/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerRegistryImpl
extends RunnerRegistry {
    public boolean hasRunner(@NotNull String executorId, @NotNull RunProfile settings) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/execution/impl/RunnerRegistryImpl", "hasRunner"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/impl/RunnerRegistryImpl", "hasRunner"));
        }
        return this.getRunner(executorId, settings) != null;
    }

    public ProgramRunner getRunner(@NotNull String executorId, @Nullable RunProfile settings) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/execution/impl/RunnerRegistryImpl", "getRunner"));
        }
        if (settings == null) {
            return null;
        }
        for (ProgramRunner runner : (ProgramRunner[])ProgramRunner.PROGRAM_RUNNER_EP.getExtensions()) {
            if (!runner.canRun(executorId, settings)) continue;
            return runner;
        }
        return null;
    }

    public ProgramRunner[] getRegisteredRunners() {
        return (ProgramRunner[])ProgramRunner.PROGRAM_RUNNER_EP.getExtensions();
    }

    @Nullable
    public ProgramRunner findRunnerById(String id) {
        for (ProgramRunner registeredRunner : (ProgramRunner[])ProgramRunner.PROGRAM_RUNNER_EP.getExtensions()) {
            if (!Comparing.equal((String)id, (String)registeredRunner.getRunnerId())) continue;
            return registeredRunner;
        }
        return null;
    }
}

