/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.scratch;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScratchPositionManager
extends PositionManagerImpl {
    private final VirtualFile myScratchFile;

    public JavaScratchPositionManager(DebugProcessImpl debugProcess, VirtualFile scratchFile) {
        super(debugProcess);
        this.myScratchFile = scratchFile;
    }

    @Override
    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) throws NoDataException {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/execution/scratch/JavaScratchPositionManager", "locationsOfLine"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/execution/scratch/JavaScratchPositionManager", "locationsOfLine"));
        }
        this.checkPosition(position);
        List<Location> list = super.locationsOfLine(type, position);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/scratch/JavaScratchPositionManager", "locationsOfLine"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) throws NoDataException {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/execution/scratch/JavaScratchPositionManager", "createPrepareRequests"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/execution/scratch/JavaScratchPositionManager", "createPrepareRequests"));
        }
        this.checkPosition(position);
        List<ClassPrepareRequest> list = super.createPrepareRequests(requestor, position);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/scratch/JavaScratchPositionManager", "createPrepareRequests"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition position) throws NoDataException {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/execution/scratch/JavaScratchPositionManager", "getAllClasses"));
        }
        this.checkPosition(position);
        List<ReferenceType> list = super.getAllClasses(position);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/scratch/JavaScratchPositionManager", "getAllClasses"));
        }
        return list;
    }

    private void checkPosition(@NotNull SourcePosition position) throws NoDataException {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/execution/scratch/JavaScratchPositionManager", "checkPosition"));
        }
        if (!this.myScratchFile.equals(position.getFile().getVirtualFile())) {
            throw NoDataException.INSTANCE;
        }
    }

    @Override
    @Nullable
    public SourcePosition getSourcePosition(Location location) throws NoDataException {
        SourcePosition position = super.getSourcePosition(location);
        if (position == null) {
            throw NoDataException.INSTANCE;
        }
        return position;
    }

    @Override
    @Nullable
    protected PsiFile getPsiFileByLocation(Project project2, Location location) {
        String alternativeQName;
        if (location == null) {
            return null;
        }
        ReferenceType refType = location.declaringType();
        if (refType == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(this.myScratchFile);
        if (!(psiFile instanceof PsiJavaFile)) {
            return null;
        }
        PsiClass[] classes = ((PsiJavaFile)psiFile).getClasses();
        if (classes.length == 0) {
            return null;
        }
        String originalQName = refType.name();
        for (PsiClass aClass : classes) {
            if (!StringUtil.equals((CharSequence)originalQName, (CharSequence)aClass.getQualifiedName())) continue;
            return psiFile;
        }
        int dollar = originalQName.indexOf(36);
        String string = alternativeQName = dollar > 0 ? originalQName.substring(0, dollar) : null;
        if (!StringUtil.isEmpty((String)alternativeQName)) {
            for (PsiClass aClass : classes) {
                if (!StringUtil.equals((CharSequence)alternativeQName, (CharSequence)aClass.getQualifiedName())) continue;
                return psiFile;
            }
        }
        return null;
    }
}

