/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.execution.testDiscovery.TestDiscoveryConfiguration;
import com.intellij.execution.testDiscovery.TestDiscoveryIndex;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Collection;

public abstract class TestDiscoveryConfigurationProducer
extends JavaRunConfigurationProducerBase<TestDiscoveryConfiguration> {
    protected TestDiscoveryConfigurationProducer(ConfigurationType type) {
        super(type);
    }

    protected boolean setupConfigurationFromContext(TestDiscoveryConfiguration configuration, ConfigurationContext configurationContext, Ref<PsiElement> ref) {
        if (!Registry.is((String)"testDiscovery.enabled")) {
            return false;
        }
        Location contextLocation = configurationContext.getLocation();
        assert (contextLocation != null);
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location == null) {
            return false;
        }
        Pair<String, String> position = TestDiscoveryConfigurationProducer.getPosition(location);
        if (position != null) {
            try {
                Collection<String> testsByMethodName = TestDiscoveryIndex.getInstance(configuration.getProject()).getTestsByMethodName((String)position.first, (String)position.second);
                if (testsByMethodName == null || ContainerUtil.filter(testsByMethodName, s -> s.startsWith(configuration.getFrameworkPrefix())).isEmpty()) {
                    return false;
                }
            }
            catch (IOException e) {
                return false;
            }
            configuration.setPosition(position);
            configuration.setName("Tests for " + StringUtil.getShortName((String)((String)position.first)) + "." + (String)position.second);
            this.setupPackageConfiguration(configurationContext, configuration, TestSearchScope.MODULE_WITH_DEPENDENCIES);
            return true;
        }
        return false;
    }

    @Override
    protected Module findModule(TestDiscoveryConfiguration configuration, Module contextModule) {
        return null;
    }

    private static Pair<String, String> getPosition(Location location) {
        PsiClass containingClass;
        PsiElement psiElement = location.getPsiElement();
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethod.class);
        if (psiMethod != null && (containingClass = psiMethod.getContainingClass()) != null) {
            TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)containingClass);
            if (testFramework != null) {
                return null;
            }
            String qualifiedName = containingClass.getQualifiedName();
            if (qualifiedName != null) {
                return Pair.create((Object)qualifiedName, (Object)psiMethod.getName());
            }
        }
        return null;
    }

    public boolean isConfigurationFromContext(TestDiscoveryConfiguration configuration, ConfigurationContext configurationContext) {
        Pair<String, String> position = TestDiscoveryConfigurationProducer.getPosition(configurationContext.getLocation());
        return position != null && position.equals(configuration.getPosition());
    }
}

