/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.CommonFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesOptions;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.ui.StateRestoringCheckBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class JavaFindUsagesDialog<T extends JavaFindUsagesOptions>
extends CommonFindUsagesDialog {
    private StateRestoringCheckBox myCbIncludeOverloadedMethods;
    private boolean myIncludeOverloadedMethodsAvailable;

    protected JavaFindUsagesDialog(@NotNull PsiElement element, @NotNull Project project2, @NotNull FindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, @NotNull FindUsagesHandler handler2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/JavaFindUsagesDialog", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/findUsages/JavaFindUsagesDialog", "<init>"));
        }
        if (findUsagesOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findUsagesOptions", "com/intellij/find/findUsages/JavaFindUsagesDialog", "<init>"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/findUsages/JavaFindUsagesDialog", "<init>"));
        }
        super(element, project2, findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler2);
    }

    @Override
    protected void init() {
        this.myIncludeOverloadedMethodsAvailable = this.myPsiElement instanceof PsiMethod && MethodSignatureUtil.hasOverloads((PsiMethod)((PsiMethod)this.myPsiElement));
        super.init();
    }

    public void calcFindUsagesOptions(T options) {
        if (options instanceof JavaMethodFindUsagesOptions) {
            ((JavaMethodFindUsagesOptions)options).isIncludeOverloadUsages = this.myIncludeOverloadedMethodsAvailable && JavaFindUsagesDialog.isToChange(this.myCbIncludeOverloadedMethods) && this.myCbIncludeOverloadedMethods.isSelected();
        }
    }

    @Override
    public void calcFindUsagesOptions(FindUsagesOptions options) {
        super.calcFindUsagesOptions(options);
        this.calcFindUsagesOptions((T)((JavaFindUsagesOptions)options));
    }

    @Override
    protected void doOKAction() {
        if (this.shouldDoOkAction()) {
            if (this.myIncludeOverloadedMethodsAvailable) {
                FindSettings.getInstance().setSearchOverloadedMethods(this.myCbIncludeOverloadedMethods.isSelected());
            }
        } else {
            return;
        }
        super.doOKAction();
    }

    @Override
    protected void addUsagesOptions(JPanel optionsPanel) {
        super.addUsagesOptions(optionsPanel);
        if (this.myIncludeOverloadedMethodsAvailable) {
            this.myCbIncludeOverloadedMethods = this.addCheckboxToPanel(FindBundle.message("find.options.include.overloaded.methods.checkbox", new Object[0]), FindSettings.getInstance().isSearchOverloadedMethods(), optionsPanel, false);
        }
    }

    @NotNull
    protected final PsiElement getPsiElement() {
        PsiElement psiElement = this.myPsiElement;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesDialog", "getPsiElement"));
        }
        return psiElement;
    }

    @NotNull
    protected T getFindUsagesOptions() {
        JavaFindUsagesOptions javaFindUsagesOptions = (JavaFindUsagesOptions)this.myFindUsagesOptions;
        if (javaFindUsagesOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/JavaFindUsagesDialog", "getFindUsagesOptions"));
        }
        return (T)javaFindUsagesOptions;
    }
}

