/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="FindSettings", storages={@Storage(value="find.xml"), @Storage(value="other.xml", deprecated=true)})
public class FindSettingsImpl
extends FindSettings
implements PersistentStateComponent<FindSettingsImpl> {
    @NonNls
    private static final String FIND_DIRECTION_FORWARD = "forward";
    @NonNls
    private static final String FIND_DIRECTION_BACKWARD = "backward";
    @NonNls
    private static final String FIND_ORIGIN_FROM_CURSOR = "from_cursor";
    @NonNls
    private static final String FIND_ORIGIN_ENTIRE_SCOPE = "entire_scope";
    @NonNls
    private static final String FIND_SCOPE_GLOBAL = "global";
    @NonNls
    private static final String FIND_SCOPE_SELECTED = "selected";
    private static final String DEFAULT_SEARCH_SCOPE = FindBundle.message("find.scope.all.project.classes", new Object[0]);
    private static final int MAX_RECENT_SIZE = 30;
    public boolean SEARCH_OVERLOADED_METHODS = false;
    public boolean SEARCH_IN_LIBRARIES = false;
    public boolean SKIP_RESULTS_WHEN_ONE_USAGE = false;
    public String FIND_DIRECTION = "forward";
    public String FIND_ORIGIN = "from_cursor";
    public String FIND_SCOPE = "global";
    public String FIND_CUSTOM_SCOPE = null;
    public boolean CASE_SENSITIVE_SEARCH = false;
    public boolean LOCAL_CASE_SENSITIVE_SEARCH = false;
    public boolean PRESERVE_CASE_REPLACE = false;
    public boolean WHOLE_WORDS_ONLY = false;
    public boolean COMMENTS_ONLY = false;
    public boolean STRING_LITERALS_ONLY = false;
    public boolean EXCEPT_COMMENTS = false;
    public boolean EXCEPT_COMMENTS_AND_STRING_LITERALS = false;
    public boolean EXCEPT_STRING_LITERALS = false;
    public boolean LOCAL_WHOLE_WORDS_ONLY = false;
    public boolean REGULAR_EXPRESSIONS = false;
    public boolean LOCAL_REGULAR_EXPRESSIONS = false;
    public boolean WITH_SUBDIRECTORIES = true;
    public boolean SHOW_RESULTS_IN_SEPARATE_VIEW = false;
    public String SEARCH_SCOPE = DEFAULT_SEARCH_SCOPE;
    public String FILE_MASK;
    @Tag(value="recentFileMasks")
    @Property(surroundWithTag=false)
    @AbstractCollection(surroundWithTag=false, elementTag="mask", elementValueAttribute="")
    public List<String> recentFileMasks = new ArrayList<String>();

    public FindSettingsImpl() {
        this.recentFileMasks.add("*.properties");
        this.recentFileMasks.add("*.html");
        this.recentFileMasks.add("*.jsp");
        this.recentFileMasks.add("*.xml");
        this.recentFileMasks.add("*.java");
        this.recentFileMasks.add("*.js");
        this.recentFileMasks.add("*.as");
        this.recentFileMasks.add("*.css");
        this.recentFileMasks.add("*.mxml");
        if (PlatformUtils.isPyCharm()) {
            this.recentFileMasks.add("*.py");
        } else if (PlatformUtils.isRubyMine()) {
            this.recentFileMasks.add("*.rb");
        } else if (PlatformUtils.isPhpStorm()) {
            this.recentFileMasks.add("*.php");
        } else if (PlatformUtils.isDatabaseIDE()) {
            this.recentFileMasks.add("*.sql");
        }
    }

    @Override
    public boolean isSearchOverloadedMethods() {
        return this.SEARCH_OVERLOADED_METHODS;
    }

    @Override
    public void setSearchOverloadedMethods(boolean search) {
        this.SEARCH_OVERLOADED_METHODS = search;
    }

    public void loadState(FindSettingsImpl state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public FindSettingsImpl getState() {
        return this;
    }

    @Override
    public boolean isSkipResultsWithOneUsage() {
        return this.SKIP_RESULTS_WHEN_ONE_USAGE;
    }

    @Override
    public void setSkipResultsWithOneUsage(boolean skip) {
        this.SKIP_RESULTS_WHEN_ONE_USAGE = skip;
    }

    @Override
    public String getDefaultScopeName() {
        return this.SEARCH_SCOPE;
    }

    @Override
    public void setDefaultScopeName(String scope) {
        this.SEARCH_SCOPE = scope;
    }

    @Override
    public boolean isForward() {
        return FIND_DIRECTION_FORWARD.equals(this.FIND_DIRECTION);
    }

    @Override
    public void setForward(boolean findDirectionForward) {
        this.FIND_DIRECTION = findDirectionForward ? FIND_DIRECTION_FORWARD : FIND_DIRECTION_BACKWARD;
    }

    @Override
    public boolean isFromCursor() {
        return FIND_ORIGIN_FROM_CURSOR.equals(this.FIND_ORIGIN);
    }

    @Override
    public void setFromCursor(boolean findFromCursor) {
        this.FIND_ORIGIN = findFromCursor ? FIND_ORIGIN_FROM_CURSOR : FIND_ORIGIN_ENTIRE_SCOPE;
    }

    @Override
    public boolean isGlobal() {
        return FIND_SCOPE_GLOBAL.equals(this.FIND_SCOPE);
    }

    @Override
    public void setGlobal(boolean findGlobalScope) {
        this.FIND_SCOPE = findGlobalScope ? FIND_SCOPE_GLOBAL : FIND_SCOPE_SELECTED;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.CASE_SENSITIVE_SEARCH;
    }

    @Override
    public void setCaseSensitive(boolean caseSensitiveSearch) {
        this.CASE_SENSITIVE_SEARCH = caseSensitiveSearch;
    }

    @Override
    public boolean isLocalCaseSensitive() {
        return this.LOCAL_CASE_SENSITIVE_SEARCH;
    }

    @Override
    public boolean isLocalWholeWordsOnly() {
        return this.LOCAL_WHOLE_WORDS_ONLY;
    }

    @Override
    public void setLocalCaseSensitive(boolean caseSensitiveSearch) {
        this.LOCAL_CASE_SENSITIVE_SEARCH = caseSensitiveSearch;
    }

    @Override
    public void setLocalWholeWordsOnly(boolean wholeWordsOnly) {
        this.LOCAL_WHOLE_WORDS_ONLY = wholeWordsOnly;
    }

    @Override
    public boolean isPreserveCase() {
        return this.PRESERVE_CASE_REPLACE;
    }

    @Override
    public void setPreserveCase(boolean preserveCase) {
        this.PRESERVE_CASE_REPLACE = preserveCase;
    }

    @Override
    public boolean isWholeWordsOnly() {
        return this.WHOLE_WORDS_ONLY;
    }

    @Override
    public void setWholeWordsOnly(boolean wholeWordsOnly) {
        this.WHOLE_WORDS_ONLY = wholeWordsOnly;
    }

    @Override
    public boolean isRegularExpressions() {
        return this.REGULAR_EXPRESSIONS;
    }

    @Override
    public void setRegularExpressions(boolean regularExpressions) {
        this.REGULAR_EXPRESSIONS = regularExpressions;
    }

    @Override
    public boolean isLocalRegularExpressions() {
        return this.LOCAL_REGULAR_EXPRESSIONS;
    }

    @Override
    public void setLocalRegularExpressions(boolean regularExpressions) {
        this.LOCAL_REGULAR_EXPRESSIONS = regularExpressions;
    }

    @Override
    public void setWithSubdirectories(boolean b) {
        this.WITH_SUBDIRECTORIES = b;
    }

    private boolean isWithSubdirectories() {
        return this.WITH_SUBDIRECTORIES;
    }

    @Override
    public void initModelBySetings(@NotNull FindModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindSettingsImpl", "initModelBySetings"));
        }
        model.setCaseSensitive(this.isCaseSensitive());
        model.setForward(this.isForward());
        model.setFromCursor(this.isFromCursor());
        model.setGlobal(this.isGlobal());
        model.setRegularExpressions(this.isRegularExpressions());
        model.setWholeWordsOnly(this.isWholeWordsOnly());
        FindModel.SearchContext searchContext = this.isInCommentsOnly() ? FindModel.SearchContext.IN_COMMENTS : (this.isInStringLiteralsOnly() ? FindModel.SearchContext.IN_STRING_LITERALS : (this.isExceptComments() ? FindModel.SearchContext.EXCEPT_COMMENTS : (this.isExceptStringLiterals() ? FindModel.SearchContext.EXCEPT_STRING_LITERALS : (this.isExceptCommentsAndLiterals() ? FindModel.SearchContext.EXCEPT_COMMENTS_AND_STRING_LITERALS : FindModel.SearchContext.ANY))));
        model.setSearchContext(searchContext);
        model.setWithSubdirectories(this.isWithSubdirectories());
        model.setFileFilter(this.FILE_MASK);
        model.setCustomScopeName(this.FIND_SCOPE);
    }

    private static void addStringToList(@NotNull String str, @NotNull List<String> list, int maxSize) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/find/impl/FindSettingsImpl", "addStringToList"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/find/impl/FindSettingsImpl", "addStringToList"));
        }
        if (list.contains(str)) {
            list.remove(str);
        }
        list.add(str);
        while (list.size() > maxSize) {
            list.remove(0);
        }
    }

    @Override
    public void addStringToFind(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/find/impl/FindSettingsImpl", "addStringToFind"));
        }
        if (s.indexOf(13) >= 0 || s.indexOf(10) >= 0) {
            return;
        }
        FindSettingsImpl.addStringToList(s, FindRecents.getInstance().findStrings, 30);
    }

    @Override
    public void addStringToReplace(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/find/impl/FindSettingsImpl", "addStringToReplace"));
        }
        if (s.indexOf(13) >= 0 || s.indexOf(10) >= 0) {
            return;
        }
        FindSettingsImpl.addStringToList(s, FindRecents.getInstance().replaceStrings, 30);
    }

    @Override
    public void addDirectory(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/find/impl/FindSettingsImpl", "addDirectory"));
        }
        if (s.isEmpty()) {
            return;
        }
        FindSettingsImpl.addStringToList(s, FindRecents.getInstance().dirStrings, 30);
    }

    @Override
    @NotNull
    public String[] getRecentFindStrings() {
        String[] stringArray = ArrayUtil.toStringArray(FindRecents.getInstance().findStrings);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindSettingsImpl", "getRecentFindStrings"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String[] getRecentReplaceStrings() {
        String[] stringArray = ArrayUtil.toStringArray(FindRecents.getInstance().replaceStrings);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindSettingsImpl", "getRecentReplaceStrings"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String[] getRecentFileMasks() {
        String[] stringArray = ArrayUtil.toStringArray(this.recentFileMasks);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindSettingsImpl", "getRecentFileMasks"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public List<String> getRecentDirectories() {
        ArrayList<String> arrayList = new ArrayList<String>(FindRecents.getInstance().dirStrings);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindSettingsImpl", "getRecentDirectories"));
        }
        return arrayList;
    }

    @Override
    @Transient
    public String getFileMask() {
        return this.FILE_MASK;
    }

    @Override
    public void setFileMask(String _fileMask) {
        this.FILE_MASK = _fileMask;
        if (!StringUtil.isEmptyOrSpaces((String)_fileMask)) {
            FindSettingsImpl.addStringToList(_fileMask, this.recentFileMasks, 30);
        }
    }

    @Override
    public String getCustomScope() {
        return this.SEARCH_SCOPE;
    }

    @Override
    public boolean isInStringLiteralsOnly() {
        return this.STRING_LITERALS_ONLY;
    }

    @Override
    public boolean isInCommentsOnly() {
        return this.COMMENTS_ONLY;
    }

    @Override
    public void setInCommentsOnly(boolean selected) {
        this.COMMENTS_ONLY = selected;
    }

    @Override
    public void setInStringLiteralsOnly(boolean selected) {
        this.STRING_LITERALS_ONLY = selected;
    }

    @Override
    public void setCustomScope(String SEARCH_SCOPE) {
        this.SEARCH_SCOPE = SEARCH_SCOPE;
    }

    @Override
    public boolean isExceptComments() {
        return this.EXCEPT_COMMENTS;
    }

    @Override
    public void setExceptCommentsAndLiterals(boolean selected) {
        this.EXCEPT_COMMENTS_AND_STRING_LITERALS = selected;
    }

    @Override
    public boolean isShowResultsInSeparateView() {
        return this.SHOW_RESULTS_IN_SEPARATE_VIEW;
    }

    @Override
    public void setShowResultsInSeparateView(boolean optionValue) {
        this.SHOW_RESULTS_IN_SEPARATE_VIEW = optionValue;
    }

    @Override
    public boolean isExceptCommentsAndLiterals() {
        return this.EXCEPT_COMMENTS_AND_STRING_LITERALS;
    }

    @Override
    public void setExceptComments(boolean selected) {
        this.EXCEPT_COMMENTS = selected;
    }

    @Override
    public boolean isExceptStringLiterals() {
        return this.EXCEPT_STRING_LITERALS;
    }

    @Override
    public void setExceptStringLiterals(boolean selected) {
        this.EXCEPT_STRING_LITERALS = selected;
    }

    @State(name="FindRecents", storages={@Storage(value="find.recents.xml", roamingType=RoamingType.DISABLED)})
    static final class FindRecents
    implements PersistentStateComponent<FindRecents> {
        @Tag(value="findStrings")
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false, elementTag="find", elementValueAttribute="")
        public List<String> findStrings = new ArrayList<String>();
        @Tag(value="replaceStrings")
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false, elementTag="replace", elementValueAttribute="")
        public List<String> replaceStrings = new ArrayList<String>();
        @Tag(value="dirStrings")
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false, elementTag="dir", elementValueAttribute="")
        public List<String> dirStrings = new ArrayList<String>();

        FindRecents() {
        }

        public static FindRecents getInstance() {
            return (FindRecents)ServiceManager.getService(FindRecents.class);
        }

        public void loadState(FindRecents state) {
            XmlSerializerUtil.copyBean((Object)state, (Object)this);
            LinkedHashSet<String> tmp = new LinkedHashSet<String>(this.findStrings);
            this.findStrings.clear();
            this.findStrings.addAll(tmp);
            tmp.clear();
            tmp.addAll(this.replaceStrings);
            this.replaceStrings.clear();
            this.replaceStrings.addAll(tmp);
            tmp.clear();
            tmp.addAll(this.dirStrings);
            this.dirStrings.clear();
            this.dirStrings.addAll(tmp);
        }

        public FindRecents getState() {
            return this;
        }
    }
}

