/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.tree;

import com.intellij.history.core.Content;
import com.intellij.history.core.Paths;
import com.intellij.history.core.StreamUtil;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.tree.DirectoryEntry;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.util.SmartList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class Entry {
    private int myNameId;
    private DirectoryEntry myParent;
    private static final int NULL_NAME_ID = -1;
    private static final int EMPTY_NAME_ID = 0;

    public Entry(String name) {
        this(Entry.toNameId(name));
    }

    public Entry(int nameId) {
        this.myNameId = nameId;
    }

    protected static int toNameId(String name) {
        if (name == null) {
            return -1;
        }
        if (name.isEmpty()) {
            return 0;
        }
        return FileNameCache.storeName(name);
    }

    private static CharSequence fromNameId(int nameId) {
        if (nameId == -1) {
            return null;
        }
        if (nameId == 0) {
            return "";
        }
        return FileNameCache.getVFileName(nameId);
    }

    public Entry(DataInput in) throws IOException {
        this.myNameId = Entry.toNameId(StreamUtil.readString(in));
    }

    public void write(DataOutput out) throws IOException {
        StreamUtil.writeString(out, this.getName());
    }

    public String getName() {
        CharSequence sequence = Entry.fromNameId(this.myNameId);
        if (sequence != null && !(sequence instanceof String)) {
            return sequence.toString();
        }
        return (String)sequence;
    }

    public CharSequence getNameSequence() {
        return Entry.fromNameId(this.myNameId);
    }

    public int getNameId() {
        return this.myNameId;
    }

    public String getPath() {
        StringBuilder builder = new StringBuilder();
        Entry.buildPath(this, builder);
        return builder.toString();
    }

    private static void buildPath(Entry e, StringBuilder builder) {
        if (e == null) {
            return;
        }
        Entry.buildPath(e.getParent(), builder);
        if (builder.length() > 0 && builder.charAt(builder.length() - 1) != '/') {
            builder.append('/');
        }
        builder.append(e.getNameSequence());
    }

    public boolean nameEquals(String name) {
        return Paths.equals(this.getName(), name);
    }

    public boolean pathEquals(String path) {
        return Paths.equals(this.getPath(), path);
    }

    public abstract long getTimestamp();

    public boolean isReadOnly() {
        throw new UnsupportedOperationException(this.formatPath());
    }

    public void setReadOnly(boolean isReadOnly) {
        throw new UnsupportedOperationException(this.formatPath());
    }

    public boolean isOutdated(long timestamp) {
        return this.getTimestamp() != timestamp;
    }

    public Content getContent() {
        throw new UnsupportedOperationException(this.formatPath());
    }

    public boolean hasUnavailableContent() {
        return this.hasUnavailableContent(new ArrayList<Entry>());
    }

    public boolean hasUnavailableContent(List<Entry> entriesWithUnavailableContent) {
        return false;
    }

    public Entry getParent() {
        return this.myParent;
    }

    protected void setParent(DirectoryEntry parent) {
        this.myParent = parent;
    }

    public boolean isDirectory() {
        return false;
    }

    public void addChild(Entry child) {
        throw new UnsupportedOperationException(this.formatAddRemove(child));
    }

    public void addChildren(Collection<Entry> children2) {
        throw new UnsupportedOperationException();
    }

    public void removeChild(Entry child) {
        throw new UnsupportedOperationException(this.formatAddRemove(child));
    }

    private String formatAddRemove(Entry child) {
        return "add/remove " + child.formatPath() + " to " + this.formatPath();
    }

    public List<Entry> getChildren() {
        return Collections.emptyList();
    }

    public Entry findChild(String name) {
        for (Entry e : this.getChildren()) {
            if (!e.nameEquals(name)) continue;
            return e;
        }
        return null;
    }

    public boolean hasEntry(String path) {
        return this.findEntry(path) != null;
    }

    public Entry getEntry(String path) {
        Entry result2 = this.findEntry(path);
        if (result2 == null) {
            throw new RuntimeException(String.format("entry '%s' not found", path));
        }
        return result2;
    }

    public Entry findEntry(String relativePath) {
        Iterable<String> parts = Paths.split(relativePath);
        Entry result2 = this;
        for (String each : parts) {
            if ((result2 = result2.findChild(each)) != null) continue;
            return null;
        }
        return result2;
    }

    @NotNull
    public abstract Entry copy();

    public void setName(String newName) {
        if (this.myParent != null) {
            this.myParent.checkDoesNotExist(this, newName);
        }
        this.myNameId = Entry.toNameId(newName);
    }

    public void setContent(Content newContent, long timestamp) {
        throw new UnsupportedOperationException(this.formatPath());
    }

    public static List<Difference> getDifferencesBetween(Entry left, Entry right) {
        SmartList result2 = new SmartList();
        if (left == null) {
            right.collectCreatedDifferences((List<Difference>)result2);
        } else if (right == null) {
            left.collectDeletedDifferences((List<Difference>)result2);
        } else {
            left.collectDifferencesWith(right, (List<Difference>)result2);
        }
        return result2;
    }

    protected abstract void collectDifferencesWith(Entry var1, List<Difference> var2);

    protected abstract void collectCreatedDifferences(List<Difference> var1);

    protected abstract void collectDeletedDifferences(List<Difference> var1);

    public String toString() {
        return this.getName();
    }

    private String formatPath() {
        String type = this.isDirectory() ? "dir: " : "file: ";
        return type + this.getPath();
    }
}

