/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Desktop;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.filechooser.FileSystemView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowFilePathAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.ShowFilePathAction");
    public static final NotificationListener FILE_SELECTING_LISTENER = new NotificationListener.Adapter(){

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/ide/actions/ShowFilePathAction$1", "hyperlinkActivated"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ShowFilePathAction$1", "hyperlinkActivated"));
            }
            URL url = e.getURL();
            if (url != null) {
                ShowFilePathAction.openFile(new File(url.getPath()));
            }
            notification.expire();
        }
    };
    private static NotNullLazyValue<Boolean> canUseNautilus = new AtomicNotNullLazyValue<Boolean>(){

        @NotNull
        protected Boolean compute() {
            if (!(SystemInfo.isUnix && SystemInfo.hasXdgMime() && new File("/usr/bin/nautilus").canExecute())) {
                Boolean bl = false;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$2", "compute"));
                }
                return bl;
            }
            String appName = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"xdg-mime", "query", "default", "inode/directory"}));
            if (appName == null || !appName.matches("nautilus.*\\.desktop")) {
                Boolean bl = false;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$2", "compute"));
                }
                return bl;
            }
            String version = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"nautilus", "--version"}));
            if (version == null) {
                Boolean bl = false;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$2", "compute"));
                }
                return bl;
            }
            Matcher m = Pattern.compile("GNOME nautilus ([0-9.]+)").matcher(version);
            Boolean bl = m.find() && StringUtil.compareVersionNumbers((String)m.group(1), (String)"3") >= 0;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$2", "compute"));
            }
            return bl;
        }
    };
    private static final NotNullLazyValue<String> fileManagerName = new AtomicNotNullLazyValue<String>(){

        @NotNull
        protected String compute() {
            String name;
            if (SystemInfo.isMac) {
                if ("Finder" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$3", "compute"));
                }
                return "Finder";
            }
            if (SystemInfo.isWindows) {
                if ("Explorer" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$3", "compute"));
                }
                return "Explorer";
            }
            if (SystemInfo.isUnix && SystemInfo.hasXdgMime() && (name = ShowFilePathAction.getUnixFileManagerName()) != null) {
                String string = name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$3", "compute"));
                }
                return string;
            }
            if ("File Manager" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$3", "compute"));
            }
            return "File Manager";
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String getUnixFileManagerName() {
        String appName = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"xdg-mime", "query", "default", "inode/directory"}));
        if (appName == null) return null;
        if (!appName.matches(".+\\.desktop")) {
            return null;
        }
        String dirs = System.getenv("XDG_DATA_DIRS");
        if (dirs == null) {
            return null;
        }
        try {
            String[] stringArray = dirs.split(File.pathSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String dir = stringArray[n2];
                File appFile = new File(dir, "applications/" + appName);
                if (appFile.exists()) {
                    try (BufferedReader reader = new BufferedReader(new FileReader(appFile));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if (!line.startsWith("Name=")) continue;
                            String string = line.substring(5);
                            return string;
                        }
                    }
                }
                ++n2;
            }
            return null;
        }
        catch (IOException e) {
            LOG.info("Cannot read desktop file", (Throwable)e);
        }
        return null;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ShowFilePathAction", "update"));
        }
        boolean visible = !SystemInfo.isMac && ShowFilePathAction.isSupported();
        e.getPresentation().setVisible(visible);
        if (visible) {
            VirtualFile file2 = ShowFilePathAction.getFile(e);
            e.getPresentation().setEnabled(file2 != null);
            e.getPresentation().setText(ActionsBundle.message((String)"action.ShowFilePath.tuned", (Object[])new Object[]{file2 != null && file2.isDirectory() ? 1 : 0}));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ShowFilePathAction", "actionPerformed"));
        }
        VirtualFile file2 = ShowFilePathAction.getFile(e);
        if (file2 != null) {
            ShowFilePathAction.show(file2, (ListPopup popup) -> {
                DataManager dataManager = DataManager.getInstance();
                if (dataManager != null) {
                    dataManager.getDataContextFromFocus().doWhenDone(arg_0 -> ((ListPopup)popup).showInBestPositionFor(arg_0));
                }
            });
        }
    }

    public static void show(@NotNull VirtualFile file2, @NotNull MouseEvent e) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/actions/ShowFilePathAction", "show"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ShowFilePathAction", "show"));
        }
        ShowFilePathAction.show(file2, (ListPopup popup) -> {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/ShowFilePathAction", "lambda$show$1"));
            }
            if (e.getComponent().isShowing()) {
                popup.show(new RelativePoint(e));
            }
        });
    }

    private static void show(@NotNull VirtualFile file2, @NotNull ShowAction show) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/actions/ShowFilePathAction", "show"));
        }
        if (show == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "show", "com/intellij/ide/actions/ShowFilePathAction", "show"));
        }
        if (!ShowFilePathAction.isSupported()) {
            return;
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        ArrayList<String> fileUrls = new ArrayList<String>();
        for (VirtualFile eachParent = file2; eachParent != null; eachParent = eachParent.getParent()) {
            int index = files.size() == 0 ? 0 : files.size();
            files.add(index, eachParent);
            fileUrls.add(index, ShowFilePathAction.getPresentableUrl(eachParent));
            if (eachParent.getParent() == null && eachParent.getFileSystem() instanceof JarFileSystem && (eachParent = JarFileSystem.getInstance().getVirtualFileForJar(eachParent)) == null) break;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (show == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "show", "com/intellij/ide/actions/ShowFilePathAction", "lambda$show$3"));
            }
            ArrayList<Icon> icons = new ArrayList<Icon>();
            for (String url : fileUrls) {
                File ioFile = new File(url);
                icons.add(ioFile.exists() ? FileSystemView.getFileSystemView().getSystemIcon(ioFile) : EmptyIcon.ICON_16);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (show == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "show", "com/intellij/ide/actions/ShowFilePathAction", "lambda$null$2"));
                }
                show.show(ShowFilePathAction.createPopup(files, icons));
            });
        });
    }

    private static String getPresentableUrl(VirtualFile file2) {
        String url = file2.getPresentableUrl();
        if (file2.getParent() == null && SystemInfo.isWindows) {
            url = url + "\\";
        }
        return url;
    }

    private static ListPopup createPopup(List<VirtualFile> files, List<Icon> icons) {
        BaseListPopupStep<VirtualFile> step = new BaseListPopupStep<VirtualFile>(RevealFileAction.getActionName(), files, icons){

            @NotNull
            public String getTextFor(VirtualFile value) {
                String string = value.getPresentableName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$4", "getTextFor"));
                }
                return string;
            }

            public PopupStep onChosen(VirtualFile selectedValue, boolean finalChoice) {
                File selectedFile = new File(ShowFilePathAction.getPresentableUrl(selectedValue));
                if (selectedFile.exists()) {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> ShowFilePathAction.openFile(selectedFile));
                }
                return FINAL_CHOICE;
            }
        };
        return JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
    }

    public static boolean isSupported() {
        return SystemInfo.isWindows || SystemInfo.hasXdgOpen() || (Boolean)canUseNautilus.getValue() != false || Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN);
    }

    @NotNull
    public static String getFileManagerName() {
        String string = (String)fileManagerName.getValue();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction", "getFileManagerName"));
        }
        return string;
    }

    public static void openFile(@NotNull File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/actions/ShowFilePathAction", "openFile"));
        }
        if (!file2.exists()) {
            return;
        }
        File parent = (file2 = file2.getAbsoluteFile()).getParentFile();
        if (parent == null) {
            return;
        }
        try {
            ShowFilePathAction.doOpen(parent, file2);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    public static void openDirectory(@NotNull File directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/ide/actions/ShowFilePathAction", "openDirectory"));
        }
        if (!directory.isDirectory()) {
            return;
        }
        try {
            ShowFilePathAction.doOpen(directory, null);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    private static void doOpen(@NotNull File dir, @Nullable File toSelect) throws IOException, ExecutionException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/ide/actions/ShowFilePathAction", "doOpen"));
        }
        dir = new File(FileUtil.toCanonicalPath((String)dir.getPath()));
        File file2 = toSelect = toSelect == null ? null : new File(FileUtil.toCanonicalPath((String)toSelect.getPath()));
        if (SystemInfo.isWindows) {
            String cmd = toSelect != null ? "explorer /select," + toSelect.getAbsolutePath() : "explorer /root," + dir.getAbsolutePath();
            Runtime.getRuntime().exec(cmd);
            return;
        }
        if (SystemInfo.isMac) {
            if (toSelect != null) {
                String script = String.format("tell application \"Finder\"\n\treveal {\"%s\"} as POSIX file\n\tactivate\nend tell", toSelect.getAbsolutePath());
                new GeneralCommandLine(new String[]{ExecUtil.getOsascriptPath(), "-e", script}).createProcess();
            } else {
                new GeneralCommandLine(new String[]{"open", dir.getAbsolutePath()}).createProcess();
            }
            return;
        }
        if (((Boolean)canUseNautilus.getValue()).booleanValue()) {
            new GeneralCommandLine(new String[]{"nautilus", (toSelect != null ? toSelect : dir).getAbsolutePath()}).createProcess();
            return;
        }
        String path = dir.getAbsolutePath();
        if (SystemInfo.hasXdgOpen()) {
            new GeneralCommandLine(new String[]{"/usr/bin/xdg-open", path}).createProcess();
        } else if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
            Desktop.getDesktop().open(new File(path));
        } else {
            Messages.showErrorDialog((String)"This action isn't supported on the current platform", (String)"Cannot Open File");
        }
    }

    @Nullable
    private static VirtualFile getFile(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
        return files == null || files.length == 1 ? (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext()) : null;
    }

    public static Boolean showDialog(Project project2, String message, String title, File file2) {
        final Boolean[] ref = new Boolean[1];
        DialogWrapper.DoNotAskOption option = new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return true;
            }

            public void setToBeShown(boolean value, int exitCode) {
                if (!value) {
                    ref[0] = exitCode == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                }
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return true;
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = CommonBundle.message((String)"dialog.options.do.not.ask", (Object[])new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/ShowFilePathAction$5", "getDoNotShowMessage"));
                }
                return string;
            }
        };
        ShowFilePathAction.showDialog(project2, message, title, file2, option);
        return ref[0];
    }

    public static void showDialog(Project project2, String message, String title, File file2, DialogWrapper.DoNotAskOption option) {
        if (Messages.showOkCancelDialog((Project)project2, (String)message, (String)title, (String)RevealFileAction.getActionName(), (String)IdeBundle.message((String)"action.close", (Object[])new Object[0]), (Icon)Messages.getInformationIcon(), (DialogWrapper.DoNotAskOption)option) == 0) {
            ShowFilePathAction.openFile(file2);
        }
    }

    @Nullable
    public static VirtualFile findLocalFile(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        if (file2.isInLocalFileSystem()) {
            return file2;
        }
        VirtualFileSystem fs = file2.getFileSystem();
        if (fs instanceof JarFileSystem && file2.getParent() == null) {
            return ((JarFileSystem)fs).getLocalVirtualFileFor(file2);
        }
        return null;
    }

    private static interface ShowAction {
        public void show(ListPopup var1);
    }
}

