/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTargetBase;
import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.ide.browsers.actions.BaseOpenInBrowserAction;
import com.intellij.ide.browsers.impl.WebBrowserServiceImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.HtmlUtil;

final class SelectInDefaultBrowserTarget
extends SelectInTargetBase {
    private static final Logger LOG = Logger.getInstance(SelectInDefaultBrowserTarget.class);

    SelectInDefaultBrowserTarget() {
    }

    public boolean canSelect(SelectInContext context) {
        OpenInBrowserRequest request;
        Object selectorInFile = context.getSelectorInFile();
        OpenInBrowserRequest openInBrowserRequest = request = selectorInFile instanceof PsiElement ? OpenInBrowserRequest.create((PsiElement)((PsiElement)selectorInFile)) : null;
        if (request == null) {
            return false;
        }
        WebBrowserUrlProvider urlProvider = WebBrowserServiceImpl.getProvider(request);
        if (urlProvider == null) {
            VirtualFile virtualFile = request.getVirtualFile();
            return virtualFile instanceof HttpVirtualFile || HtmlUtil.isHtmlFile((PsiElement)request.getFile()) && !(virtualFile instanceof LightVirtualFile);
        }
        return true;
    }

    public String toString() {
        return XmlBundle.message((String)"browser.select.in.default.name", (Object[])new Object[0]);
    }

    public void selectIn(SelectInContext context, boolean requestFocus) {
        PsiElement element = (PsiElement)context.getSelectorInFile();
        LOG.assertTrue(element != null);
        BaseOpenInBrowserAction.open(OpenInBrowserRequest.create((PsiElement)element), false, null);
    }

    public float getWeight() {
        return 9.5f;
    }
}

