/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.extensionResources;

import com.intellij.ide.extensionResources.ExtensionsRootType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;

public class RestoreBundledExtensionsAction
extends DumbAwareAction {
    RestoreBundledExtensionsAction() {
        super("Restore Default Extensions", "Restore bundled extensions for this directory", null);
    }

    public void update(AnActionEvent e) {
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        boolean isDirectory = file2 != null && file2.isDirectory();
        e.getPresentation().setEnabledAndVisible(isDirectory && ExtensionsRootType.getInstance().getPath(file2) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        ExtensionsRootType extensionsRootType = ExtensionsRootType.getInstance();
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        PluginId pluginId = extensionsRootType.getOwner(file2);
        String path = extensionsRootType.getPath(file2);
        assert (file2 != null && pluginId != null && path != null);
        try {
            extensionsRootType.extractBundledResources(pluginId, path);
        }
        catch (IOException ex) {
            ExtensionsRootType.LOG.warn("Failed to extract bundled extensions for " + file2.getPath(), (Throwable)ex);
        }
    }
}

