/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.hierarchy.HierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.util.SystemProperties;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

class ExporterToTextFileHierarchy
implements ExporterToTextFile {
    private final HierarchyBrowserBase myHierarchyBrowserBase;

    public ExporterToTextFileHierarchy(@NotNull HierarchyBrowserBase hierarchyBrowserBase) {
        if (hierarchyBrowserBase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchyBrowserBase", "com/intellij/ide/hierarchy/ExporterToTextFileHierarchy", "<init>"));
        }
        this.myHierarchyBrowserBase = hierarchyBrowserBase;
    }

    public JComponent getSettingsEditor() {
        return null;
    }

    public void addSettingsChangedListener(ChangeListener listener2) throws TooManyListenersException {
    }

    public void removeSettingsChangedListener(ChangeListener listener2) {
    }

    @NotNull
    public String getReportText() {
        StringBuilder buf = new StringBuilder();
        this.appendNode(buf, this.myHierarchyBrowserBase.getCurrentBuilder().getRootNode(), SystemProperties.getLineSeparator(), "");
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/ExporterToTextFileHierarchy", "getReportText"));
        }
        return string;
    }

    private void appendNode(StringBuilder buf, DefaultMutableTreeNode node, String lineSeparator, String indent) {
        String childIndent;
        buf.append(indent);
        if (node.getParent() != null) {
            childIndent = indent + "    ";
            HierarchyNodeDescriptor descriptor = this.myHierarchyBrowserBase.getDescriptor(node);
            if (descriptor != null) {
                buf.append(descriptor.getHighlightedText().getText()).append(lineSeparator);
            }
        } else {
            childIndent = indent;
        }
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumeration.nextElement();
            this.appendNode(buf, child, lineSeparator, childIndent);
        }
    }

    @NotNull
    public String getDefaultFilePath() {
        HierarchyBrowserManager.State state = HierarchyBrowserManager.getInstance(this.myHierarchyBrowserBase.myProject).getState();
        String string = state != null && state.EXPORT_FILE_PATH != null ? state.EXPORT_FILE_PATH : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/ExporterToTextFileHierarchy", "getDefaultFilePath"));
        }
        return string;
    }

    public void exportedTo(String filePath) {
        HierarchyBrowserManager.State state = HierarchyBrowserManager.getInstance(this.myHierarchyBrowserBase.myProject).getState();
        if (state != null) {
            state.EXPORT_FILE_PATH = filePath;
        }
    }

    public boolean canExport() {
        return true;
    }
}

