/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeBuilder;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.TreeBuilderUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.stripe.ErrorStripe;
import com.intellij.ui.stripe.ErrorStripePainter;
import com.intellij.ui.stripe.TreeUpdater;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractProjectViewPSIPane
extends AbstractProjectViewPane {
    private JScrollPane myComponent;

    protected AbstractProjectViewPSIPane(Project project2) {
        super(project2);
    }

    @Override
    public JComponent createComponent() {
        if (this.myComponent != null) {
            return this.myComponent;
        }
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(null);
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.myTree = this.createTree(treeModel);
        this.enableDnD();
        this.myComponent = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree));
        if (Registry.is((String)"error.stripe.enabled")) {
            ErrorStripePainter painter = new ErrorStripePainter(true);
            Disposer.register((Disposable)this, (Disposable)new TreeUpdater<ErrorStripePainter>(painter, this.myComponent, (JTree)((Object)this.myTree)){

                @Override
                protected void update(ErrorStripePainter painter, int index, Object object) {
                    if (object instanceof DefaultMutableTreeNode) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
                        object = node.getUserObject();
                    }
                    if (object instanceof PsiDirectoryNode && !AbstractProjectViewPSIPane.this.myTree.isCollapsed(index)) {
                        object = null;
                    }
                    super.update(painter, index, object);
                }

                @Override
                protected ErrorStripe getErrorStripe(Object object) {
                    TextAttributes attributes;
                    PresentableNodeDescriptor node;
                    PresentationData presentation;
                    TextAttributesKey key2;
                    if (object instanceof PresentableNodeDescriptor && (key2 = (presentation = (node = (PresentableNodeDescriptor)object).getPresentation()).getTextAttributesKey()) != null && (attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(key2)) != null && EffectType.WAVE_UNDERSCORE == attributes.getEffectType()) {
                        return ErrorStripe.create(attributes.getEffectColor(), 1);
                    }
                    return null;
                }
            });
        }
        this.myTreeStructure = this.createStructure();
        this.setTreeBuilder(this.createBuilder(treeModel));
        this.installComparator();
        this.initTree();
        return this.myComponent;
    }

    @Override
    public final void dispose() {
        this.myComponent = null;
        super.dispose();
    }

    private void initTree() {
        this.myTree.getSelectionModel().setSelectionMode(4);
        UIUtil.setLineStyleAngled((JTree)((Object)this.myTree));
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.expandPath(new TreePath(this.myTree.getModel().getRoot()));
        this.myTree.setSelectionPath(new TreePath(this.myTree.getModel().getRoot()));
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this.myTree));
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.myTree));
        TreeUtil.installActions((JTree)((Object)this.myTree));
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                AbstractProjectViewPSIPane.this.fireTreeChangeListener();
            }
        });
        this.myTree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                AbstractProjectViewPSIPane.this.fireTreeChangeListener();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                AbstractProjectViewPSIPane.this.fireTreeChangeListener();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                AbstractProjectViewPSIPane.this.fireTreeChangeListener();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                AbstractProjectViewPSIPane.this.fireTreeChangeListener();
            }
        });
        new MySpeedSearch((JTree)((Object)this.myTree));
        this.myTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    DefaultMutableTreeNode selectedNode = ((ProjectViewTree)AbstractProjectViewPSIPane.this.myTree).getSelectedNode();
                    if (selectedNode != null && !selectedNode.isLeaf()) {
                        return;
                    }
                    DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)AbstractProjectViewPSIPane.this.myTree));
                    OpenSourceUtil.openSourcesFrom((DataContext)dataContext, (boolean)ScreenReader.isActive());
                } else if (27 == e.getKeyCode()) {
                    boolean[] isCopied;
                    if (e.isConsumed()) {
                        return;
                    }
                    PsiCopyPasteManager copyPasteManager = PsiCopyPasteManager.getInstance();
                    if (copyPasteManager.getElements(isCopied = new boolean[1]) != null && !isCopied[0]) {
                        copyPasteManager.clear();
                        e.consume();
                    }
                }
            }
        });
        CustomizationUtil.installPopupHandler((JComponent)((Object)this.myTree), "ProjectViewPopupMenu", "ProjectViewPopup");
    }

    @Override
    @NotNull
    public final ActionCallback updateFromRoot(boolean restoreExpandedPaths) {
        Runnable afterUpdate;
        ArrayList pathsToExpand = new ArrayList();
        ArrayList selectionPaths = new ArrayList();
        ActionCallback cb = new ActionCallback();
        if (restoreExpandedPaths) {
            TreeBuilderUtil.storePaths((AbstractTreeBuilder)this.getTreeBuilder(), (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.myTree.getModel().getRoot()), pathsToExpand, selectionPaths, (boolean)true);
            afterUpdate = () -> {
                if (this.myTree != null && this.getTreeBuilder() != null && !this.getTreeBuilder().isDisposed()) {
                    this.myTree.setSelectionPaths(new TreePath[0]);
                    TreeBuilderUtil.restorePaths((AbstractTreeBuilder)this.getTreeBuilder(), (List)pathsToExpand, (List)selectionPaths, (boolean)true);
                }
                cb.setDone();
            };
        } else {
            afterUpdate = cb.createSetDoneRunnable();
        }
        if (this.getTreeBuilder() != null) {
            this.getTreeBuilder().addSubtreeToUpdate(this.getTreeBuilder().getRootNode(), afterUpdate);
        }
        ActionCallback actionCallback = cb;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/AbstractProjectViewPSIPane", "updateFromRoot"));
        }
        return actionCallback;
    }

    @Override
    public void select(Object element, VirtualFile file2, boolean requestFocus) {
        this.selectCB(element, file2, requestFocus);
    }

    @NotNull
    public ActionCallback selectCB(Object element, VirtualFile file2, boolean requestFocus) {
        if (file2 != null) {
            ActionCallback actionCallback = ((BaseProjectTreeBuilder)this.getTreeBuilder()).select(element, file2, requestFocus);
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/AbstractProjectViewPSIPane", "selectCB"));
            }
            return actionCallback;
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/AbstractProjectViewPSIPane", "selectCB"));
        }
        return actionCallback;
    }

    @NotNull
    protected BaseProjectTreeBuilder createBuilder(DefaultTreeModel treeModel) {
        ProjectTreeBuilder projectTreeBuilder = new ProjectTreeBuilder(this.myProject, (JTree)((Object)this.myTree), treeModel, null, (ProjectAbstractTreeStructureBase)this.myTreeStructure){

            protected AbstractTreeUpdater createUpdater() {
                return AbstractProjectViewPSIPane.this.createTreeUpdater(this);
            }
        };
        if (projectTreeBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/AbstractProjectViewPSIPane", "createBuilder"));
        }
        return projectTreeBuilder;
    }

    protected abstract ProjectAbstractTreeStructureBase createStructure();

    protected abstract ProjectViewTree createTree(DefaultTreeModel var1);

    protected abstract AbstractTreeUpdater createTreeUpdater(AbstractTreeBuilder var1);

    protected static final class MySpeedSearch
    extends TreeSpeedSearch {
        MySpeedSearch(JTree tree) {
            super(tree);
        }

        @Override
        protected boolean isMatchingElement(Object element, String pattern) {
            Object userObject = ((DefaultMutableTreeNode)((TreePath)element).getLastPathComponent()).getUserObject();
            if (userObject instanceof PsiDirectoryNode) {
                String str = this.getElementText(element);
                if (str == null) {
                    return false;
                }
                str = str.toLowerCase();
                if (pattern.indexOf(46) >= 0) {
                    return this.compare(str, pattern);
                }
                StringTokenizer tokenizer = new StringTokenizer(str, ".");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (!this.compare(token, pattern)) continue;
                    return true;
                }
                return false;
            }
            return super.isMatchingElement(element, pattern);
        }
    }
}

