/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.openapi.ui.GraphicsConfig;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.JTextComponent;

public class DarculaPasswordFieldUI
extends BasicPasswordFieldUI {
    public DarculaPasswordFieldUI(final JPasswordField passwordField) {
        passwordField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                passwordField.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                passwordField.repaint();
            }
        });
    }

    public static ComponentUI createUI(JComponent c) {
        return new DarculaPasswordFieldUI((JPasswordField)c);
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        Border border;
        Graphics2D g = (Graphics2D)graphics;
        JTextComponent c = this.getComponent();
        Container parent = c.getParent();
        if (c.isOpaque() && parent != null) {
            g.setColor(parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        if ((border = c.getBorder()) instanceof DarculaTextBorder) {
            if (c.isEnabled() && c.isEditable()) {
                g.setColor(c.getBackground());
            }
            int width = c.getWidth();
            int height = c.getHeight();
            Insets i = border.getBorderInsets(c);
            if (c.hasFocus()) {
                GraphicsConfig config = new GraphicsConfig((Graphics)g);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                g.fillRoundRect(i.left - 5, i.top - 2, width - i.left - i.right + 10, height - i.top - i.bottom + 6, 5, 5);
                config.restore();
            } else {
                g.fillRect(i.left - 5, i.top - 2, width - i.left - i.right + 12, height - i.top - i.bottom + 6);
            }
        } else {
            super.paintBackground(g);
        }
    }
}

