/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicSpinnerUI;
import org.jetbrains.annotations.NotNull;

public class DarculaSpinnerUI
extends BasicSpinnerUI {
    protected JButton prevButton;
    protected JButton nextButton;
    private FocusAdapter myFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            DarculaSpinnerUI.this.spinner.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            DarculaSpinnerUI.this.spinner.repaint();
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new DarculaSpinnerUI();
    }

    private void addEditorFocusListener(JComponent editor) {
        if (editor != null) {
            editor.getComponents()[0].addFocusListener(this.myFocusListener);
        }
    }

    private void removeEditorFocusListener(JComponent editor) {
        if (editor != null) {
            editor.getComponents()[0].removeFocusListener(this.myFocusListener);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.removeEditorFocusListener(this.spinner.getEditor());
    }

    @Override
    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        super.replaceEditor(oldEditor, newEditor);
        this.removeEditorFocusListener(oldEditor);
        this.addEditorFocusListener(newEditor);
    }

    @Override
    protected JComponent createEditor() {
        JComponent editor = super.createEditor();
        this.addEditorFocusListener(editor);
        return editor;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        Border border = this.spinner.getBorder();
        if (border != null) {
            border.paintBorder(c, g, 0, 0, this.spinner.getWidth(), this.spinner.getHeight());
        }
    }

    protected JButton createButton(int direction, String name) {
        JButton button = this.createArrow(direction);
        button.setName(name);
        button.setBorder(new EmptyBorder(1, 1, 1, 1));
        if (direction == 1) {
            this.installNextButtonListeners(button);
        } else {
            this.installPreviousButtonListeners(button);
        }
        return button;
    }

    @Override
    protected Component createPreviousButton() {
        this.prevButton = this.createButton(5, "Spinner.previousButton");
        return this.prevButton;
    }

    @Override
    protected Component createNextButton() {
        this.nextButton = this.createButton(1, "Spinner.nextButton");
        return this.nextButton;
    }

    @Override
    protected LayoutManager createLayout() {
        return new LayoutManagerDelegate(super.createLayout()){

            @Override
            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                JComponent editor = DarculaSpinnerUI.this.spinner.getEditor();
                if (editor != null) {
                    DarculaSpinnerUI.this.layoutEditor(editor);
                }
            }
        };
    }

    protected void layoutEditor(@NotNull JComponent editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ide/ui/laf/darcula/ui/DarculaSpinnerUI", "layoutEditor"));
        }
        if (editor != null) {
            Rectangle bounds = editor.getBounds();
            editor.setBounds(bounds.x, bounds.y, bounds.width - 6, bounds.height);
        }
    }

    protected void paintArrowButton(Graphics g, BasicArrowButton button, int direction) {
        int y = direction == 1 ? button.getHeight() - 6 : 2;
        button.paintTriangle(g, (button.getWidth() - 8) / 2 - 1, y, 0, direction, this.spinner.isEnabled());
    }

    private JButton createArrow(int direction) {
        Color shadow = UIUtil.getPanelBackground();
        JBColor enabledColor = new JBColor((Color)Gray._255, UIUtil.getLabelForeground());
        JBColor disabledColor = new JBColor((Color)Gray._200, UIUtil.getLabelForeground().darker());
        BasicArrowButton b = new BasicArrowButton(direction, shadow, shadow, (Color)enabledColor, shadow, (Color)enabledColor, (Color)disabledColor){
            final /* synthetic */ Color val$enabledColor;
            final /* synthetic */ Color val$disabledColor;
            {
                this.val$enabledColor = color;
                this.val$disabledColor = color2;
                super(x0, x1, x2, x3, x4);
            }

            @Override
            public void paint(Graphics g) {
                DarculaSpinnerUI.this.paintArrowButton(g, this, this.direction);
            }

            @Override
            public boolean isOpaque() {
                return false;
            }

            @Override
            public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
                GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
                int w = 8;
                int h = 6;
                int mid = 4;
                g.setColor(isEnabled ? this.val$enabledColor : this.val$disabledColor);
                g.translate(x, y);
                switch (direction) {
                    case 5: {
                        g.fillPolygon(new int[]{0, 8, mid}, new int[]{1, 1, 6}, 3);
                        break;
                    }
                    case 1: {
                        g.fillPolygon(new int[]{0, 8, mid}, new int[]{5, 5, 0}, 3);
                        break;
                    }
                }
                g.translate(-x, -y);
                config.restore();
            }
        };
        Border buttonBorder = UIManager.getBorder("Spinner.arrowButtonBorder");
        if (buttonBorder instanceof UIResource) {
            b.setBorder(new CompoundBorder(buttonBorder, null));
        } else {
            b.setBorder(buttonBorder);
        }
        b.setInheritsPopupMenu(true);
        return b;
    }

    protected static class LayoutManagerDelegate
    implements LayoutManager {
        protected final LayoutManager myDelegate;

        public LayoutManagerDelegate(LayoutManager delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.myDelegate.addLayoutComponent(name, comp);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this.myDelegate.removeLayoutComponent(comp);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.myDelegate.preferredLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.myDelegate.minimumLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            this.myDelegate.layoutContainer(parent);
        }
    }
}

