/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class WinIntelliJButtonPainter
implements Border,
UIResource {
    private static final int myOffset = 4;

    @Override
    public void paintBorder(Component c, Graphics graphics, int x, int y, int width, int height) {
        Graphics2D g = (Graphics2D)graphics;
        boolean hasFocus = c.hasFocus();
        boolean isDefault = DarculaButtonUI.isDefaultButton((JComponent)c);
        if (hasFocus || isDefault) {
            if (!DarculaButtonUI.isHelpButton((JComponent)c)) {
                g.setColor(UIManager.getColor("Button.intellij.native.activeBorderColor"));
                int d = JBUI.scale((int)1);
                int dd = JBUI.scale((int)2);
                Area s1 = new Area(new Rectangle2D.Float(d, d, width - 2 * d, height - 2 * d));
                Area s2 = new Area(new Rectangle2D.Float(d + dd, d + dd, width - 2 * d - 2 * dd, height - 2 * d - 2 * dd));
                s1.subtract(s2);
                g.fill(s1);
                g.translate(x, y);
                if (hasFocus) {
                    g.setStroke(new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{1.0f}, 1.0f));
                    g.setColor((Color)Gray.x0F);
                    g.drawRect(2 * dd, 2 * dd, width - 4 * dd - 1, height - 4 * dd - 1);
                }
                g.translate(-x, -y);
            }
        } else {
            g.setColor(UIManager.getColor("Button.intellij.native.borderColor"));
            if (!DarculaButtonUI.isHelpButton((JComponent)c)) {
                g.translate(x, y);
                g.drawRect(0, 0, width - 1, height - 1);
                g.translate(-x, -y);
            }
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (c.getParent() instanceof ActionToolbar) {
            return JBUI.insets((int)4, (int)16).asUIResource();
        }
        if (DarculaButtonUI.isSquare(c)) {
            return JBUI.insets((int)2, (int)0).asUIResource();
        }
        return JBUI.insets((int)3, (int)17).asUIResource();
    }

    protected int getOffset() {
        return 4;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

