/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.intellij.IntelliJCheckBoxUI;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class WinIntelliJCheckBoxUI
extends IntelliJCheckBoxUI {
    public static ComponentUI createUI(JComponent c) {
        return new WinIntelliJCheckBoxUI();
    }

    @Override
    protected void drawCheckIcon(JComponent c, Graphics2D g, JCheckBox b, Rectangle iconRect, boolean selected, boolean enabled) {
        Color color = enabled ? b.getForeground() : this.getBorderColor1(false, false);
        g.setColor(color);
        Rectangle r = new Rectangle(iconRect.x + JBUI.scale((int)2), iconRect.y + JBUI.scale((int)2), iconRect.width - JBUI.scale((int)4), iconRect.height - JBUI.scale((int)4));
        g.drawRect(r.x, r.y, r.width, r.height);
        if (selected) {
            int x1 = r.x + JBUI.scale((int)3);
            int y1 = r.y + r.height / 2 + JBUI.scale((int)1);
            int x2 = r.x + r.height / 2 - JBUI.scale((int)1);
            int y2 = r.y + r.height - JBUI.scale((int)4);
            Graphics2D iconGraphics = (Graphics2D)g.create(0, 0, c.getWidth(), c.getHeight());
            iconGraphics.setColor(color);
            iconGraphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            iconGraphics.setStroke(new BasicStroke(JBUI.scale((float)1.5f), 0, 0));
            if (enabled) {
                iconGraphics.drawLine(x1, y1, x2, y2);
                iconGraphics.drawLine(x2, y2, r.x + r.width - JBUI.scale((int)2), r.y + JBUI.scale((int)4));
            }
            iconGraphics.dispose();
        }
    }

    @Override
    protected void drawText(JComponent c, Graphics2D g, JCheckBox b, FontMetrics fm, Rectangle textRect, String text) {
        super.drawText(c, g, b, fm, textRect, text);
        if (b.hasFocus()) {
            g.setColor(b.getForeground());
            UIUtil.drawDottedRectangle((Graphics)g, (int)(textRect.x - 2), (int)(textRect.y - 1), (int)(textRect.width + textRect.x + 1), (int)(textRect.height + 3));
        }
    }

    @Override
    public Icon getDefaultIcon() {
        return JBUI.emptyIcon((int)18).asUIResource();
    }
}

