/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.impl.AbstractProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectTreeBuilder;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.TreeFileChooser;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePanel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TreeFileChooserDialog
extends DialogWrapper
implements TreeFileChooser {
    private Tree myTree;
    private PsiFile mySelectedFile = null;
    private final Project myProject;
    private BaseProjectTreeBuilder myBuilder;
    private TabbedPaneWrapper myTabbedPane;
    private ChooseByNamePanel myGotoByNamePanel;
    @Nullable
    private final PsiFile myInitialFile;
    @Nullable
    private final TreeFileChooser.PsiFileFilter myFilter;
    @Nullable
    private final FileType myFileType;
    private final boolean myDisableStructureProviders;
    private final boolean myShowLibraryContents;
    private boolean mySelectSearchByNameTab = false;

    public TreeFileChooserDialog(Project project2, String title, @Nullable PsiFile initialFile, @Nullable FileType fileType, @Nullable TreeFileChooser.PsiFileFilter filter, boolean disableStructureProviders, boolean showLibraryContents) {
        super(project2, true);
        this.myInitialFile = initialFile;
        this.myFilter = filter;
        this.myFileType = fileType;
        this.myDisableStructureProviders = disableStructureProviders;
        this.myShowLibraryContents = showLibraryContents;
        this.setTitle(title);
        this.myProject = project2;
        this.init();
        if (initialFile != null) {
            SwingUtilities.invokeLater(() -> this.selectFile(initialFile));
        }
        SwingUtilities.invokeLater(() -> this.handleSelectionChanged());
    }

    protected JComponent createCenterPanel() {
        DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree((TreeModel)model);
        AbstractProjectTreeStructure treeStructure = new AbstractProjectTreeStructure(this.myProject){

            public boolean isFlattenPackages() {
                return false;
            }

            @Override
            public boolean isShowMembers() {
                return false;
            }

            public boolean isHideEmptyMiddlePackages() {
                return true;
            }

            @Override
            public Object[] getChildElements(Object element) {
                return TreeFileChooserDialog.this.filterFiles(super.getChildElements(element));
            }

            public boolean isAbbreviatePackageNames() {
                return false;
            }

            public boolean isShowLibraryContents() {
                return TreeFileChooserDialog.this.myShowLibraryContents;
            }

            public boolean isShowModules() {
                return false;
            }

            @Override
            public List<TreeStructureProvider> getProviders() {
                return TreeFileChooserDialog.this.myDisableStructureProviders ? null : super.getProviders();
            }
        };
        this.myBuilder = new ProjectTreeBuilder(this.myProject, (JTree)this.myTree, model, (Comparator<NodeDescriptor>)AlphaComparator.INSTANCE, treeStructure);
        this.myTree.setRootVisible(false);
        this.myTree.expandRow(0);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        scrollPane.setPreferredSize((Dimension)JBUI.size((int)500, (int)300));
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    TreeFileChooserDialog.this.doOKAction();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                TreePath path = TreeFileChooserDialog.this.myTree.getPathForLocation(e.getX(), e.getY());
                if (path != null && TreeFileChooserDialog.this.myTree.isPathSelected(path)) {
                    TreeFileChooserDialog.this.doOKAction();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myTree);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreeFileChooserDialog.this.handleSelectionChanged();
            }
        });
        new TreeSpeedSearch((JTree)this.myTree);
        this.myTabbedPane = new TabbedPaneWrapper(this.getDisposable());
        final JPanel dummyPanel = new JPanel(new BorderLayout());
        String name = null;
        if (this.myInitialFile != null) {
            name = this.myInitialFile.getName();
        }
        PsiFile context = this.myInitialFile == null ? null : this.myInitialFile;
        this.myGotoByNamePanel = new ChooseByNamePanel(this.myProject, new MyGotoFileModel(), name, true, (PsiElement)context){

            @Override
            protected void close(boolean isOk) {
                super.close(isOk);
                if (isOk) {
                    TreeFileChooserDialog.this.doOKAction();
                } else {
                    TreeFileChooserDialog.this.doCancelAction();
                }
            }

            @Override
            protected void initUI(ChooseByNamePopupComponent.Callback callback, ModalityState modalityState, boolean allowMultipleSelection) {
                super.initUI(callback, modalityState, allowMultipleSelection);
                dummyPanel.add((Component)TreeFileChooserDialog.this.myGotoByNamePanel.getPanel(), "Center");
                if (TreeFileChooserDialog.this.mySelectSearchByNameTab) {
                    TreeFileChooserDialog.this.myTabbedPane.setSelectedIndex(1);
                }
            }

            @Override
            protected void showTextFieldPanel() {
            }

            @Override
            protected void chosenElementMightChange() {
                TreeFileChooserDialog.this.handleSelectionChanged();
            }
        };
        this.myTabbedPane.addTab(IdeBundle.message((String)"tab.chooser.project", (Object[])new Object[0]), scrollPane);
        this.myTabbedPane.addTab(IdeBundle.message((String)"tab.chooser.search.by.name", (Object[])new Object[0]), dummyPanel);
        SwingUtilities.invokeLater(() -> this.myGotoByNamePanel.invoke(new MyCallback(), ModalityState.stateForComponent((Component)this.getRootPane()), false));
        this.myTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TreeFileChooserDialog.this.handleSelectionChanged();
            }
        });
        return this.myTabbedPane.getComponent();
    }

    public void selectSearchByNameTab() {
        this.mySelectSearchByNameTab = true;
    }

    private void handleSelectionChanged() {
        PsiFile selection = this.calcSelectedClass();
        this.setOKActionEnabled(selection != null);
    }

    protected void doOKAction() {
        this.mySelectedFile = this.calcSelectedClass();
        if (this.mySelectedFile == null) {
            return;
        }
        super.doOKAction();
    }

    public void doCancelAction() {
        this.mySelectedFile = null;
        super.doCancelAction();
    }

    public PsiFile getSelectedFile() {
        return this.mySelectedFile;
    }

    public void selectFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/util/TreeFileChooserDialog", "selectFile"));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/util/TreeFileChooserDialog", "lambda$selectFile$3"));
            }
            if (this.myBuilder != null) {
                this.myBuilder.select(file2, file2.getVirtualFile(), true);
            }
        }, ModalityState.stateForComponent((Component)this.getWindow()));
    }

    public void showDialog() {
        this.show();
    }

    private PsiFile calcSelectedClass() {
        if (this.myTabbedPane.getSelectedIndex() == 1) {
            return (PsiFile)this.myGotoByNamePanel.getChosenElement();
        }
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object userObject = node.getUserObject();
        if (!(userObject instanceof ProjectViewNode)) {
            return null;
        }
        ProjectViewNode pvNode = (ProjectViewNode)userObject;
        VirtualFile vFile = pvNode.getVirtualFile();
        if (vFile != null && !vFile.isDirectory()) {
            return PsiManager.getInstance((Project)this.myProject).findFile(vFile);
        }
        return null;
    }

    public void dispose() {
        if (this.myBuilder != null) {
            Disposer.dispose((Disposable)this.myBuilder);
            this.myBuilder = null;
        }
        super.dispose();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.util.TreeFileChooserDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    private Object[] filterFiles(Object[] list) {
        Condition condition = psiFile -> {
            if (this.myFilter != null && !this.myFilter.accept(psiFile)) {
                return false;
            }
            boolean accepted = this.myFileType == null || psiFile.getFileType() == this.myFileType;
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile != null && !accepted) {
                accepted = virtualFile.getFileType() == this.myFileType;
            }
            return accepted;
        };
        ArrayList<Object> result2 = new ArrayList<Object>(list.length);
        for (Object o : list) {
            ProjectViewNode projectViewNode;
            Object psiFile2 = o instanceof PsiFile ? (PsiFile)o : (o instanceof PsiFileNode ? (PsiFile)((PsiFileNode)((Object)o)).getValue() : null);
            if (psiFile2 != null && !condition.value(psiFile2) || o instanceof ProjectViewNode && !(projectViewNode = (ProjectViewNode)o).canHaveChildrenMatching(condition)) continue;
            result2.add(o);
        }
        return ArrayUtil.toObjectArray(result2);
    }

    private final class MyCallback
    extends ChooseByNamePopupComponent.Callback {
        private MyCallback() {
        }

        public void elementChosen(Object element) {
            TreeFileChooserDialog.this.mySelectedFile = (PsiFile)element;
            TreeFileChooserDialog.this.close(0);
        }
    }

    private final class MyGotoFileModel
    implements ChooseByNameModel,
    DumbAware {
        private final int myMaxSize;

        private MyGotoFileModel() {
            this.myMaxSize = WindowManagerEx.getInstanceEx().getFrame((Project)((TreeFileChooserDialog)TreeFileChooserDialog.this).myProject).getSize().width;
        }

        @NotNull
        public Object[] getElementsByName(String name, boolean checkBoxState, String pattern) {
            GlobalSearchScope scope = TreeFileChooserDialog.this.myShowLibraryContents ? GlobalSearchScope.allScope((Project)TreeFileChooserDialog.this.myProject) : GlobalSearchScope.projectScope((Project)TreeFileChooserDialog.this.myProject);
            Object[] psiFiles = FilenameIndex.getFilesByName(TreeFileChooserDialog.this.myProject, name, scope);
            Object[] objectArray = TreeFileChooserDialog.this.filterFiles(psiFiles);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TreeFileChooserDialog$MyGotoFileModel", "getElementsByName"));
            }
            return objectArray;
        }

        public String getPromptText() {
            return IdeBundle.message((String)"prompt.filechooser.enter.file.name", (Object[])new Object[0]);
        }

        public String getCheckBoxName() {
            return null;
        }

        public char getCheckBoxMnemonic() {
            return '\u0000';
        }

        public String getNotInMessage() {
            return "";
        }

        public String getNotFoundMessage() {
            return "";
        }

        public boolean loadInitialCheckBoxState() {
            return true;
        }

        public void saveInitialCheckBoxState(boolean state) {
        }

        public PsiElementListCellRenderer getListCellRenderer() {
            return new GotoFileCellRenderer(this.myMaxSize);
        }

        @NotNull
        public String[] getNames(boolean checkBoxState) {
            String[] fileNames;
            if (TreeFileChooserDialog.this.myFileType != null && TreeFileChooserDialog.this.myProject != null) {
                GlobalSearchScope scope = TreeFileChooserDialog.this.myShowLibraryContents ? GlobalSearchScope.allScope((Project)TreeFileChooserDialog.this.myProject) : GlobalSearchScope.projectScope((Project)TreeFileChooserDialog.this.myProject);
                Collection<VirtualFile> collection = FileTypeIndex.getFiles(TreeFileChooserDialog.this.myFileType, scope);
                fileNames = (String[])ContainerUtil.map2Array(collection, String.class, file2 -> file2.getName());
            } else {
                fileNames = FilenameIndex.getAllFilenames(TreeFileChooserDialog.this.myProject);
            }
            THashSet array = new THashSet();
            for (String fileName : fileNames) {
                if (array.contains(fileName)) continue;
                array.add(fileName);
            }
            Object[] objectArray = ArrayUtil.toStringArray((Collection)array);
            Arrays.sort(objectArray);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TreeFileChooserDialog$MyGotoFileModel", "getNames"));
            }
            return objectArray;
        }

        public boolean willOpenEditor() {
            return true;
        }

        public String getElementName(Object element) {
            if (!(element instanceof PsiFile)) {
                return null;
            }
            return ((PsiFile)element).getName();
        }

        @Nullable
        public String getFullName(Object element) {
            if (element instanceof PsiFile) {
                VirtualFile virtualFile = ((PsiFile)element).getVirtualFile();
                return virtualFile != null ? virtualFile.getPath() : null;
            }
            return this.getElementName(element);
        }

        public String getHelpId() {
            return null;
        }

        @NotNull
        public String[] getSeparators() {
            String[] stringArray = new String[]{"/", "\\"};
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TreeFileChooserDialog$MyGotoFileModel", "getSeparators"));
            }
            return stringArray;
        }

        public boolean useMiddleMatching() {
            return false;
        }
    }
}

